#ifndef KSPLINEDEMO_H
#define KSPLINEDEMO_H

#include <qmenubar.h>
#include <qpopmenu.h>
#include <qpainter.h>
#include <qwindow.h>
#include <qdialog.h>
#include <qgrpbox.h>
#include <kapp.h>
#include <klocale.h>
#include <krestrictedline.h>
#include <kspline.h>
#include <ksplineedit.h>

class DrawWidget : public QWindow {
  Q_OBJECT

public:
   DrawWidget( QWidget* parent=0, const char* name=0, WFlags f=0 );
   ~DrawWidget();
   double l,r,o,u;
   SplineCurve *Spline, *Spline2;
   int PosNeg;
   double Zoom;

protected:
   void paintEvent( QPaintEvent * );
   
private:
   QPainter *Paint;
   void Plot(void);
};

class DisplayDlg : public QDialog {
   Q_OBJECT
public:
   DisplayDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0);
   int SetParams(void);
private:
   KRestrictedLine *Links,*Rechts,*Unten,*Oben;
   DrawWidget* Client;
};

class SplineManDlg : public QDialog {
   Q_OBJECT
public:
   SplineManDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0);
public slots:
   void PrevClick();
   void NextClick();
   void FirstClick();
   void LastClick();
   void DeleteClick();
   void ModifyClick();
   void AddClick();
private:
   void DispPoint(int Num);
   QLabel* PointLab, *StatusLab;
   KRestrictedLine *PointX,*PointY,*NewX,*NewY;
   DrawWidget* Client;
   int Count;   // Aktueller Punkt
};

class SplineVisDlg : public QDialog {
   Q_OBJECT
public:
   SplineVisDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0);
   KSplineEdit *SplEdit;
public slots:
   void Spl1BtnClick();
   void Spl2BtnClick();
private:
   DrawWidget* Client;
};

class SplineWidget : public KTopLevelWidget {
  Q_OBJECT

public:

  SplineWidget();
  ~SplineWidget();

public slots:
   void MenuDisplay();
   void MenuSplMan();
   void MenuSplVis();
  
private:
    KToolBar *ToolBar; 
    KMenuBar *MainMenu;
    DrawWidget *Client;
    
protected:
    int initMenu();
};

#endif
