#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
//#include <klocale.h>
#include "ksplinedlg.h"
#include "ksplinedlg.moc"
#include <kapp.h> // hier ist 'klocale' definiert !!!
//#define TRS klocale->translate

KSplineDlg::KSplineDlg(SplineCurve* Spl,QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
// Einstellungsdialoch
char Strg[20];

   setFixedSize(250,200);
   Spline = Spl;
   
   NaturalCheck = new QCheckBox(klocale->translate("natural Spline"), this, "KubischCheck");
   NaturalCheck->setGeometry(10,20,150,20);
   NaturalCheck->setChecked(Spline->natural());

   QLabel* Label1 = new QLabel("Y1", this, "Y1Edit");
   Label1->setGeometry(10,60,40,20);
   QLabel* Label2 = new QLabel("Yn", this, "YnEdit");
   Label2->setGeometry(10,90,40,20);

   Y1Edit = new KRestrictedLine(this, "Y1Edit", "01234567890.eE+-");
   Y1Edit->setGeometry(50,60,100,20);
   sprintf(Strg, "%0.3f", Spline->getY1());
   Y1Edit->setText(Strg);

   YnEdit = new KRestrictedLine(this, "YnEdit", "01234567890.eE+-");
   YnEdit->setGeometry(50,90,100,20);
   sprintf(Strg, "%0.3f", Spline->getYn());
   YnEdit->setText(Strg);
   
   // OK-Button
   QPushButton *OkBtn = new QPushButton(klocale->translate("OK"), this, "OkBtn");
   OkBtn->setGeometry(10,170,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   // cancel-Button
   QPushButton *AbortBtn = new QPushButton(klocale->translate("Cancel"), this, "OkBtn");
   AbortBtn->setGeometry(110,170,80,30);
   connect(AbortBtn, SIGNAL(clicked()), SLOT(reject()) );
}

int KSplineDlg::setParams(void) {
char* eptr;
double d1,d2;

   d1 = strtod(Y1Edit->text(), &eptr);
   if (*eptr!=0) return FALSE;
   d2 = strtod(YnEdit->text(), &eptr);
   if (*eptr!=0) return FALSE;
   
   Spline->setY1(d1);
   Spline->setYn(d2);
   Spline->setNatural(NaturalCheck->isChecked());
   return TRUE;
}