#include <stdio.h>
#include "kspline.h"

// #define BORDER 2   // (unsichtbarer) Rahmen um den Spline

char * Errors[] = {"Ok",
                   "Fehler (allgemein)",
                   "Max. Punktezahl erreicht",
                   "Doppelter X-Wert",
                   "Koordinatenindex auerhalb des Bereiches",
                   "Gesuchter Punkt nicht gefunden"
                   };
SplineCurve::SplineCurve(void) {
   n=0;
   Natuerlich=TRUE;
   yp1=0.0;
   ypn=0.0;
   ReCalc = TRUE;
}

SplineCurve::~SplineCurve(void) {

}

int SplineCurve::add(double x, double y) {
int i,pos;

   if (n==MAXPNTS)
      return SPL_ERRMAXPOINTS;     // Maximale Anzahl von Punkten erreicht
   pos=0;
   // Einfgeposition suchen
   for (pos=0; pos<n; pos++) {

      if (X[pos]==x)   // doppelter X-Wert
         return SPL_ERRXDOPPELT;  // Fehler, Abbruch
      else
      if (X[pos]>x) {
                    // Position gefunden
         break;     // hier einfgen
      }
   }

   // Restliche Elemente nach hinten verschieben
   for (i=n; i>pos; i--) {
      X[i]=X[i-1];
      Y[i]=Y[i-1];
   }
   // neue Sttzstelle einfgen
   n++;
   X[pos]=x;
   Y[pos]=y;
//printf("val = %7.2f  pos=%d\n",x,pos);
   ReCalc = TRUE;
   return pos;
}

void SplineCurve::calcSpline(void)
{
double u[MAXPNTS];
double sig,p,qn,un;
int i;   

   // Berechnung der zweiten Ableitung
   if (Natuerlich) { y2[0]=u[0]=0.0; }
   else {
      y2[0] = -0.5;
      u[0] = (3.0/(X[1]-X[0]))*((Y[1]-Y[0])/(X[1]-X[0])-yp1);
   }
   for (i=1;i<=n-2;i++) {
      sig=(X[i]-X[i-1]) / (X[i+1]-X[i-1]);
      p = sig*y2[i-1]+2.0;
      y2[i] = (sig-1.0)/p;
      u[i] = (Y[i+1]-Y[i]) / (X[i+1]-X[i]) - (Y[i]-Y[i-1]) / (X[i] - X[i-1]);
      u[i] = (6.0*u[i] / (X[i+1] - X[i-1]) - sig *u[i-1])/p;
   }
   if (Natuerlich) { qn=un=0.0; }
   else {
      qn = 0.5;
      un = (3.0 / (X[n-1] - X[n-2])) * (ypn - (Y[n-1] - Y[n-2]) / (X[n-1] - X[n-2]));
   }
   y2[n-1] = (un - qn * u[n-2]) / (qn*y2[n-2] +1.0 );

   for (i=n-2;i>=0; i--) {
      y2[i] = y2[i] * y2[i+1]+u[i];
   }
   ReCalc = FALSE;
}

double SplineCurve::spline(double xarg)
{
int k, klo, khi;
double a,b,h;

   if (n==0) return 0.0;
   if (n==1) return Y[0];
   
   if (ReCalc) calcSpline();
   
   klo=0;
   khi=n-1;
   while (khi-klo > 1) {
      k = khi+klo;
      if (k % 2) {k = (k+1) / 2; }
      else { k = k/2; }
      if (X[k] > xarg) khi=k;
      else klo=k;
   }
   h = X[khi] - X[klo];
   if (h==0) {
      printf("fauler X-Wert\n");
      return 0;
   }
   a = (X[khi] - xarg) / h;
   b = (xarg - X[klo]) / h;
   return a * Y[klo] + b*Y[khi] + ((a*a*a-a)*y2[klo] + (b*b*b-b) * y2[khi]) * (h*h) / 6.0;
}

void SplineCurve::TestAus(void) {
int i;
   printf("---Spline Testausgabe\n");
   printf("n=%d\n",n);
   for (i=0;i<n;i++)
      printf("%10.4f  %10.4f\n",X[i],Y[i]);
}

double SplineCurve::getX(int Num) {
   if (n<0) return 0.0;
   if (n>=MAXPNTS) return 0.0;
   return X[Num];
}

double SplineCurve::getY(int Num) {
   if (n<0) return 0.0;
   if (n>=MAXPNTS) return 0.0;
   return Y[Num];
}

int SplineCurve::findX(double x) {
int i;
   for (i=0; i<n; i++)
      if (X[i]==x)  // gefunden
         return i;
   return SPL_NOTFOUND;
}

int SplineCurve::del(int Num) {
int i;
   if (Num<0) return SPL_ERRRANGE;
   if (Num>=n) return SPL_ERRRANGE;
   for (i=Num;i<n-1;i++) {
      X[i]=X[i+1];
      Y[i]=Y[i+1];
   }
   X[n-1]=0.0;
   Y[n-1]=0.0;
   n--;
//TestAus();
   ReCalc = TRUE;
   return SPL_OK;
}

int SplineCurve::modify(int Num, double x, double y) {
int Nr;
   Nr = findX(x);
   if ((Nr>=0) && (Nr!=Num))    // gefunden, aber nicht aktueller Punkt
      return SPL_ERRXDOPPELT;     // neuer X-Wert ist bereits enthalten
   ReCalc = TRUE;   
   del(Num);
   return add(x,y);
}

void SplineCurve::clear(void) {
   n=0;
   ypn=0.0;
   yp1=0.0;
   Natuerlich=TRUE;
   ReCalc=TRUE;
}

char* SplineCurve::errorText(int ErrorCode) {
   if (ErrorCode > 0) return "";
   if (ErrorCode < SPL_NOTFOUND) return "";
   return Errors[-ErrorCode];
}

void SplineCurve::defaultInit(void) {
   clear();
   add(0,0);
   add(0.5,0.5);
   add(1,1);
   Natuerlich=TRUE;
}
