#include <qbttngrp.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qvalidator.h>
#include <qpushbt.h>
#include <kapp.h>
#include <kcolordlg.h>
#include <kmsgbox.h>

#include "fileoperations.h"
#include "kfunction.moc"
#include "koverview.moc"
#include "fnchooser.h"

RCSTAG( "$Id: koverview.cpp,v 3.16 1998/02/14 16:22:32 kde Exp $" );

//#define __DEBUG

KOverviewDlg::KOverviewDlg( QWidget* parent ) : QTabDialog( parent,
							 "overviewdlg", TRUE )
{
  setCaption( klocale->translate( "Overview" ) );

  QWidget* w = new KExpressionListDlg( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );

  w = new KCoordinatesDlg( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );
  connect( this, SIGNAL( applyButtonPressed() ), w, SLOT( Ok() ) );

  w = new KGridDialog( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );
  connect( this, SIGNAL( applyButtonPressed() ), w, SLOT( Ok() ) );

  w = new KLabelListDlg( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );
} // KOverview constructor


KExpressionListDlg::KExpressionListDlg( QWidget* parent ) : QWidget( parent )
{
  setCaption( klocale->translate( "&Expressions" ) );

  lb = new QListBox( this );
  CHECK_PTR( lb );
  connect( lb, SIGNAL( selected( int ) ), SLOT( settings() ) );
  QToolTip::add( lb, klocale->translate( "The expressions you have entered") );

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );
  hbox->addWidget( lb, 2 );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addSpacing( 5 );
  hbox->addLayout( vbox, 1 );
  
  QPushButton* btn = new QPushButton( klocale->translate( "&Settings" ),
				      this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( settings() ) );
  QToolTip::add( btn, klocale->translate( "Opens a dialog to set e.g. the line"
					  " color" ) );
  //vbox->addSpacing( 5 );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );

  btn = new QPushButton( klocale->translate( "&Delete" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( deleteExpression() ) );
  QToolTip::add( btn, klocale->translate( "Delete the selected expression" ) );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );
  
  btn = new QPushButton( klocale->translate( "&New" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( newExpression() ) );
  QToolTip::add( btn, klocale->translate( "Add a new expression" ) );
  vbox->addWidget( btn, 1 );

  btn = new QPushButton( klocale->translate( "&Differentiate" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( differentiateExpression() ) );
  vbox->addStretch( 1 );
  vbox->addWidget( btn, 1 );

  btn = new QPushButton( klocale->translate( "&Tangent" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( tangent() ) );
  vbox->addStretch( 1 );
  vbox->addWidget( btn, 1 );

  // add the current functions to the listbox
  uint n;
  for( n = 0; n < functions->count(); n++ ) {
    lb->insertItem( functions->at( n )->text );
  } // for

  connect( this, SIGNAL( expressionAdded() ), kapp, SIGNAL( expressionAdded() )
	   );
  connect( this, SIGNAL( expressionDeleted( uint ) ), kapp,
	   SIGNAL( expressionDeleted( uint ) ) );
} // KExpressionListDlg constructor


void
KExpressionListDlg::settings()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    KFunction* f = functions->at( n );

    KSettingsDialog* dlg = new KSettingsDialog( f, this );
    CHECK_PTR( dlg );
    dlg->exec();
    delete dlg;

    lb->removeItem( n );
    lb->insertItem( f->text, n );
    lb->setSelected( n, TRUE );
  } // if
} // KExpressionListDlg::settings


void
KExpressionListDlg::deleteExpression()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    int Delete = 1;
    if ( askOnDelete ) Delete = KMsgBox::yesNo( kapp->mainWidget(),
		klocale->translate( "delete expression" ),
	        klocale->translate(
		   "Are you sure that you want to delete this expression?" ) );

    if ( Delete != 1 ) return;
    lb->removeItem( n );
    functions->remove( n );

    emit expressionDeleted( n );

    // doesn't work !?!
    kapp->mainWidget()->repaint( TRUE );
  } // if
} // KExpressionListDlg::delete

void
KExpressionListDlg::newExpression()
{
  KFunction* f = new KFunction;
  CHECK_PTR( f );
  f->text = "";
  f->pen = black;

  KSettingsDialog* dlg = new KSettingsDialog( f, this );
  if ( dlg->exec() == 1 ) {
    functions->append( f );
    lb->insertItem( f->text );

    emit expressionAdded();

    kapp->mainWidget()->repaint( TRUE );
  } // if
  else delete f;
} // KExpressionListDlg::newExpression


void
KExpressionListDlg::differentiateExpression()
{
  int n;
  if ( ( n = lb->currentItem() ) == -1 ) return;
  
  KFunction* f = new KFunction;
  CHECK_PTR( f );
  f->text = "";
  f->pen = blue;

  KFunction* fOrig = functions->at( n );
  KExpression* diff = fOrig->expression.differentiate( "x" );
  if ( !diff ) {
    QString s;
    s.sprintf( klocale->translate(
	       "Cannot differentiate this expression (yet)!" ) );
    KMsgBox::message( kapp->mainWidget(),
		      klocale->translate( "differentiate" ), s );

    return;
  } // if

  diff->simplify();
  f->expression = *diff;
  f->text = diff->print();
  functions->append( f );
  lb->insertItem( f->text );
  kapp->mainWidget()->repaint( FALSE );
} // KExpressionListDlg::differentiateExpression


void
KExpressionListDlg::tangent()
{
  int n;
  if ( ( n = lb->currentItem() ) == -1 ) return;

  KFunction* f = functions->at( n );
  KExpression* diff = f->expression.differentiate( "x" );
  if ( !diff ) {
    QString s;
    s.sprintf( klocale->translate(
	       "Cannot differentiate this expression (yet)!" ) );
    KMsgBox::message( kapp->mainWidget(),
		      klocale->translate( "Tangent" ), s );
    return;
  } // if
  diff->simplify();

  KTangentDlg* dlg = new KTangentDlg( this, &f->expression, diff );
  CHECK_PTR( dlg );
  dlg->exec();
  delete dlg;

  lb->clear();
  uint u;
  for( u = 0; u < functions->count(); u++ )
    lb->insertItem( functions->at( u )->text );
  kapp->mainWidget()->repaint( FALSE );
} // KExpressionListDlg::tangent



KCoordinatesDlg::KCoordinatesDlg( QWidget* parent ) : QWidget( parent )
{
  setCaption( klocale->translate( "&Coordinates" ) );

  QHBoxLayout* hbox1 = new QHBoxLayout( this );
  CHECK_PTR( hbox1 );
  hbox1->addSpacing( 5 );

  QVBoxLayout* vbox1 = new QVBoxLayout();
  CHECK_PTR( vbox1 );
  hbox1->addLayout( vbox1, 4 );
  
  ex = new KCoordExample( this );
  CHECK_PTR( ex );
  vbox1->addSpacing( 5 );
  vbox1->addWidget( ex, 5 );

  QHBoxLayout* hbox2 = new QHBoxLayout();
  CHECK_PTR( hbox2 );
  vbox1->addLayout( hbox2, 2 );
  vbox1->addSpacing( 5 );

  QVBoxLayout* vbox3 = new QVBoxLayout();
  CHECK_PTR( vbox3 );
  hbox2->addLayout( vbox3, 1 );
  
  QLabel* l = new QLabel( "minX", this );
  CHECK_PTR( l );
  vbox3->addWidget( l, 1 );

  leMinX = new KLined( this, "leMinX" );
  CHECK_PTR( leMinX );
  vbox3->addWidget( leMinX, 1 );
  QDoubleValidator* val = new QDoubleValidator( -1000, 1000, 5, leMinX );
  CHECK_PTR( val );
  leMinX->setValidator( val );
  QToolTip::add( leMinX, klocale->translate( "the x-coordinate on the left"
					    " screen border" ) );

  QVBoxLayout* vbox4 = new QVBoxLayout();
  CHECK_PTR( vbox4 );
  hbox2->addSpacing( 5 );
  hbox2->addLayout( vbox4, 1 );
  hbox2->addStretch( 2 );
  
  l = new QLabel( "minY", this );
  CHECK_PTR( l );
  vbox4->addWidget( l, 1 );

  leMinY = new KLined( this, "leMinY" );
  CHECK_PTR( leMinY );
  vbox4->addWidget( leMinY, 1 );
  val = new QDoubleValidator( -1000, 1000, 5, leMinY );
  CHECK_PTR( val );
  leMinY->setValidator( val );
  QToolTip::add( leMinY, klocale->translate( "the y-coordinate on the lower"
					     " screen border" ) );


  QVBoxLayout* vbox5 = new QVBoxLayout();
  CHECK_PTR( vbox5 );
  hbox1->addSpacing( 5 );
  hbox1->addLayout( vbox5, 1 );
  hbox1->addSpacing( 5 );

  l = new QLabel( "maxX", this );
  CHECK_PTR( l );
  vbox5->addWidget( l, 1 );

  leMaxX = new KLined( this, "leMaxX" );
  CHECK_PTR( leMaxX );
  vbox5->addWidget( leMaxX, 1 );
  vbox5->addSpacing( 5 );
  val = new QDoubleValidator( -1000, 1000, 5, leMaxX );
  CHECK_PTR( val );
  leMaxX->setValidator( val );
  QToolTip::add( leMaxX, klocale->translate( "the x-coordninate on the right"
					     " screen border" ) );

  l = new QLabel( "maxY", this );
  CHECK_PTR( l );
  vbox5->addWidget( l, 1 );

  leMaxY = new KLined( this, "leMaxY" );
  CHECK_PTR( leMaxY );
  vbox5->addWidget( leMaxY, 1 );
  val = new QDoubleValidator( -1000, 1000, 5, leMaxY );
  CHECK_PTR( val );
  leMaxY->setValidator( val );
  QToolTip::add( leMaxY, klocale->translate( "the y-coordinate on the upper"
					     " screen border" ) );

  vbox5->addStretch( 4 );

  QString s;
  s.setNum( minX );
  leMinX->setText( s );

  s.setNum( minY );
  leMinY->setText( s );

  s.setNum( maxX );
  leMaxX->setText( s );

  s.setNum( maxY );
  leMaxY->setText( s );
} // KCoordinatesDlg constructor

void
KCoordinatesDlg::Ok()
{
  QString s;
  s = leMinX->text();
  minX = s.toDouble();

  s = leMinY->text();
  minY = s.toDouble();

  s = leMaxX->text();
  maxX = s.toDouble();

  s = leMaxY->text();
  maxY = s.toDouble();

  kapp->mainWidget()->repaint( TRUE );
} // KCoordinatesDlg::Ok


void
KCoordExample::paintEvent( QPaintEvent* e )
{
  QFrame::paintEvent( e );

  QPainter p( this );
  p.setPen( QPen( black, 2 ) );

  p.drawRect( 10, 10, width()-92, height()-35 );
  p.moveTo( 10, ( height()-35 ) / 2 );
  p.lineTo( width()-82, ( height()-35 ) / 2 );

  p.moveTo( ( width()-92 ) / 2, 10 );
  p.lineTo( ( width()-92 ) / 2, height()-25 );

  p.drawText( 5, height() - 7, "(minX|minY)" );
  p.drawText( width()-80, 18, "(maxX|maxY)" );
} // KCoordExample::paintEvent



KSettingsDialog::KSettingsDialog( KFunction* f, QWidget* parent )
  : QDialog( parent, "settingsdlg", TRUE )
{
  setCaption( klocale->translate( "Settings" ) );

  _f = f;

  QGridLayout* layout = new QGridLayout (this, 5, 4, 10, 2);
  CHECK_PTR( layout );

  //This is unattractive (but functional) right now...
  le = new KMLEa ( this, "f(x)" );
  CHECK_PTR( le );
  QToolTip::add( le, klocale->translate( "the function term" ) );
  connect (le, SIGNAL (textChanged ()), SLOT (leTextChanged ()));
  layout->addMultiCellWidget (le, 0, 0, 1, 3);

  QLabel* label = new QLabel( le, "f(&x)=", this );
  CHECK_PTR( label );
  label->setAlignment( AlignVCenter | AlignRight | ShowPrefix );
  layout->addWidget (label, 0, 0);
  
  lb = new QListBox( this );
  CHECK_PTR( lb );
  layout->addMultiCellWidget (lb, 2, 4, 0, 1);
  
  label = new QLabel( lb, klocale->translate( "Line &Style" ), this );
  CHECK_PTR( label );
  layout->addWidget (label, 1, 0);
  
  QPushButton* btn = new QPushButton( klocale->translate( "&Color" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( color() ) );
  layout->addWidget (btn, 3, 2);

  btnOK = new QPushButton( klocale->translate( "OK" ), this );
  CHECK_PTR( btnOK );
  connect( btnOK, SIGNAL( clicked() ), SLOT( ok() ) );
  btnOK->setDefault( TRUE );
  layout->addWidget (btnOK, 4, 2);
  btnOK->setEnabled (FALSE);

  btn = new QPushButton( klocale->translate( "Cancel" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( cancel() ) );
  layout->addWidget (btn, 4, 3);

  btn = new QPushButton ( klocale->translate( "Insert" ), this);
  CHECK_PTR ( btn );
  connect ( btn, SIGNAL ( clicked() ), SLOT ( fndialog() ) );
  layout->addWidget (btn, 3, 3);


  layout->activate();
  resize( 340, 220 );

  // fill the list box
  // later, the line styles will be shown directly by creating a new
  //   QListBoxItem
  lb->insertItem( klocale->translate( "solid" ) );
  lb->insertItem( klocale->translate( "dashes" ) );
  lb->insertItem( klocale->translate( "dots" ) );
  lb->insertItem( klocale->translate( "dash dot" ) );
  lb->insertItem( klocale->translate( "dash dot dot" ) );
  lb->setCurrentItem( _f->pen.style() - 1 );

  le->setText( _f->text );

  newColor = _f->pen.color();

  le->setFocus();
} // KSettingsDialog constructor

void
KSettingsDialog::fndialog ()
{
  KFnChooser kfc (this, "fndialog");
  kfc.exec();
  
  QString qs = kfc.expression();
  
  int e, c, l;
  if ((e=qs.find ("$x$",0,FALSE))!=-1)
    {
      qs.replace (e, 3, "x");
      le->deleteMarkedText();
      le->getCursorPosition (&l, &c);
      le->insertAt (qs.data(), l, c);
      le->markText (l, c+e,c+e+1);
    }
  else
    {
      le->getCursorPosition (&l, &c);
      le->insertAt (qs.data(), l, c);
    }

  leTextChanged();
}
 
  
void
KSettingsDialog::leTextChanged ()
{
  if (le->text().length()!=0)
    btnOK->setEnabled (TRUE);
  else
    btnOK->setEnabled (FALSE);
}

void
KSettingsDialog::color()
{
  KColorDialog::getColor( newColor );
} // KSettingsDialog::color


void
KSettingsDialog::ok()
{
  QString sExpression = le->text();
  if( sExpression.find( ":=" ) != -1 ) {
    QStrList slist;
    if( processLine( sExpression, 1, slist ) ) { done( 2 ); return; }
    else {
      QString sError = slist.at( 0 );
      sError.remove( 0, 5 );
      KMsgBox::message( this, klocale->translate( "Error" ), sError );
      return;
    } // else
  } // if

  KExpression* tmp = new KExpression;
  CHECK_PTR( tmp );

  QStrList slist;
  slist.append( "x" );
  int nError = tmp->parse( le->text().data(), &slist, this );
  delete tmp;

  if ( nError != err_Ok ) return;

  _f->pen.setColor( newColor );
  _f->pen.setStyle( static_cast<PenStyle>( lb->currentItem() + 1 ) );
  _f->text = le->text().data();
  _f->expression.parse( _f->text, &slist );

  done( 1 );
} // KSettingsDialog::ok


void
KSettingsDialog::cancel()
{
  done( 0 );
} // KSettingsDialog::cancel


KLineStyleItem::KLineStyleItem( PenStyle style ) : QListBoxItem()
{
  _style = style;
} // KLineStyleItem constructor


void
KLineStyleItem::paint( QPainter* p )
{
  QPen pen( _style );
  p->setPen( pen );
  p->moveTo( 0, 5 );
  p->lineTo( 100, 5 );
} // KLineStyleItem::paint



KGridDialog::KGridDialog( QWidget* parent ): QWidget( parent )
{
  QLabel* lab = static_cast<QLabel*>( NULL );

  setCaption( klocale->translate( "&Grid" ) );

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addLayout( vbox );
  hbox->addSpacing( 5 );

  QButtonGroup* btngrp = new QButtonGroup( klocale->translate( "grid" ),
					   this );
  CHECK_PTR( btngrp );
  vbox->addWidget( btngrp, 4 );
  //  vbox->addSpacing( 5 );

  QVBoxLayout* vboxBtns = new QVBoxLayout( btngrp, 20, 5 );
  CHECK_PTR( vboxBtns );

  rb[0] = new QRadioButton( klocale->translate( "off" ), this );
  CHECK_PTR( rb[0] );
  btngrp->insert( rb[0] );
  vboxBtns->addWidget( rb[0] );
  if ( showGrid == grid_Off ) rb[0]->setChecked( TRUE );

  rb[1] = new QRadioButton( klocale->translate( "text on axes" ), this );
  CHECK_PTR( rb[1] );
  btngrp->insert( rb[1] );
  vboxBtns->addWidget( rb[1] );
  if ( showGrid == grid_Axes ) rb[1]->setChecked( TRUE );

  rb[2] = new QRadioButton( klocale->translate( "grid" ), this );
  CHECK_PTR( rb[2] );
  btngrp->insert( rb[2] );
  vboxBtns->addWidget( rb[2] );
  if ( showGrid == grid_Grid ) rb[2]->setChecked( TRUE );

  rb[3] = new QRadioButton( klocale->translate( "dots" ), this );
  CHECK_PTR( rb[3] );
  btngrp->insert( rb[3] );
  vboxBtns->addWidget( rb[3] );
  if ( showGrid == grid_Dots ) rb[3]->setChecked( TRUE );

  
  // the edit lines
  QHBoxLayout* hb = new QHBoxLayout();
  CHECK_PTR( hb );
  vbox->addLayout( hb, 1 );
  leX = new KLined( this, "leX" );
  CHECK_PTR( leX );
  QLabel* lab1 = new QLabel( leX, klocale->translate( "grid &width" ), this );
  CHECK_PTR( lab1 );
  hb->addWidget( lab1, 1 );
  int width1 = lab1->sizeHint().width();
  hb->addWidget( leX, 2 );
  QDoubleValidator* val = new QDoubleValidator( 0.0000000001, 1000, 5, leX );
  CHECK_PTR( val );
  leX->setValidator( val );

  hb = new QHBoxLayout();
  CHECK_PTR( hb );
  vbox->addLayout( hb, 1 );
  leY = new KLined( this, "leY" );
  CHECK_PTR( leY );
  lab = new QLabel( leY, klocale->translate( "grid &height" ), this );
  CHECK_PTR( lab );
  hb->addWidget( lab, 1 );
  int width2 = lab->sizeHint().width();
  int width = ( width1 > width2 ) ? width1 : width2;
  lab1->setFixedWidth( width );
  lab->setFixedWidth( width );
  hb->addWidget( leY, 2 );
  val = new QDoubleValidator( 0.0000000001, 1000, 5, leY );
  CHECK_PTR( val );
  leY->setValidator( val );


  QVBoxLayout* vbox2 = new QVBoxLayout();
  CHECK_PTR( vbox2 );
  hbox->addLayout( vbox2 );
  
  lb = new QListBox( this );
  CHECK_PTR( lb );

  lab = new QLabel( lb, klocale->translate( "line &style" ), this );
  CHECK_PTR( lab );
  vbox2->addWidget( lab, 1 );
  vbox2->addWidget( lb, 4 );

  QPushButton* btn = new QPushButton( klocale->translate( "&Color" ), this );
  CHECK_PTR( btn );
  vbox2->addWidget( btn, 2 );
  connect( btn, SIGNAL( clicked() ), SLOT( color() ) );

  lb->insertItem( klocale->translate( "solid" ) );
  lb->insertItem( klocale->translate( "dashes" ) );
  lb->insertItem( klocale->translate( "dots" ) );
  lb->insertItem( klocale->translate( "dash dot" ) );
  lb->insertItem( klocale->translate( "dash dot dot" ) );
  lb->setCurrentItem( gridPenStyle - 1 );

  QString s;
  s.setNum( gridX );
  leX->setText( s );

  s.setNum( gridY );
  leY->setText( s );

  newColor = gridColor;
} // KGridDialog constructor


KGridDialog::~KGridDialog()
{
  int n;
  for ( n = 0; n < 4; n++ ) if ( rb[ n ]->isChecked() ) showGrid = n;
} // KGridDialog destructor


void
KGridDialog::Ok()
{
  QString s;
  s = leX->text();
  gridX = s.toDouble();

  s = leY->text();
  gridY = s.toDouble();

  gridColor = newColor;

  gridPenStyle = static_cast<PenStyle>( lb->currentItem() + 1 );
} // KGridDialog::Ok


void
KGridDialog::color()
{
  KColorDialog::getColor( newColor );
} // KGridDialog::color


KLabelListDlg::KLabelListDlg( QWidget* parent ) : QWidget( parent )
{
  setCaption( klocale->translate( "&Labels" ) );

  lb = new QListBox( this );
  CHECK_PTR( lb );
  connect( lb, SIGNAL( selected( int ) ), SLOT( settings() ) );

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );
  hbox->addWidget( lb, 2 );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addSpacing( 5 );
  hbox->addLayout( vbox, 1 );
  
  QPushButton* btn = new QPushButton( klocale->translate( "&Settings" ),
				      this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( settings() ) );
  //  vbox->addSpacing( 5 );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );

  btn = new QPushButton( klocale->translate( "&Delete" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( deleteLabel() ) );
  QToolTip::add( btn, klocale->translate( "Delete the selected expression" ) );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );
  
  btn = new QPushButton( klocale->translate( "&New" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( newLabel() ) );
  vbox->addWidget( btn, 1 );

  vbox->addStretch( 3 );

  //hbox->addSpacing( 5 );

  uint n;
  for( n = 0; n < Labels.count(); n++ ) {
    QString s, sTemp;
    s = "(";
    sTemp.setNum( Labels.at( n )->x );
    s = s + sTemp + "|";
    sTemp.setNum( Labels.at( n )->y );
    s = s + sTemp + ") ";
    sTemp = Labels.at( n )->text;
    s = s + sTemp;
    lb->insertItem( s );
  } // for
} // KLabelListDlg constructor


void
KLabelListDlg::settings()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    KTextLabel* lab = Labels.at( n );

    KGetLabelTextDlg* dlg = new KGetLabelTextDlg( this, lab );
    CHECK_PTR( dlg );
    dlg->exec();
    delete dlg;

    QString s, sTemp;
    s = "(";
    sTemp.setNum( lab->x );
    s = s + sTemp + "|";
    sTemp.setNum( lab->y );
    s = s + sTemp + ") ";
    sTemp = lab->text;
    s = s + sTemp;
    lb->removeItem( n );
    lb->insertItem( s, n );
    lb->setSelected( n, TRUE );
  } // if
} // KLabelListDlg::settings


void
KLabelListDlg::deleteLabel()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    int Delete = 1;
    if ( askOnDelete ) Delete = KMsgBox::yesNo( kapp->mainWidget(),
		klocale->translate( "delete expression" ),
	        klocale->translate(
		   "Are you sure that you want to delete this label?" ) );

    if ( Delete != 1 ) return;
    lb->removeItem( n );
    Labels.remove( n );

    kapp->mainWidget()->repaint( TRUE );
  } // if
} // KExpressionListDlg::deleteLabel


void
KLabelListDlg::newLabel()
{
  KTextLabel* lab = new KTextLabel;
  CHECK_PTR( lab );
  lab->text = "";
  lab->color = black;
  lab->x = lab->y = 0;
  lab->showCross = KTextLabel::off;

  KGetLabelTextDlg* dlg = new KGetLabelTextDlg( this, lab );
  if ( dlg->exec() ) {
    Labels.append( lab );

    QString s, sTemp;
    s = "(";
    sTemp.setNum( lab->x );
    s = s + sTemp + "|";
    sTemp.setNum( lab->y );
    s = s + sTemp + ") ";
    sTemp = lab->text;
    s = s + sTemp;
    lb->insertItem( s );

    kapp->mainWidget()->repaint( TRUE );
  } // if
  else delete lab;
} // KLabelListDlg::newLabel



KGetLabelTextDlg::KGetLabelTextDlg( QWidget* parent, KTextLabel* _tlabel ) :
  QDialog( parent, "getLabelText", TRUE )
{
  setCaption( klocale->translate( "add label" ) );

  tlabel = _tlabel;
  newColor = tlabel->color;

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );
  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addLayout( vbox, 2 );

  editline = new KLined( this, "editline" );
  CHECK_PTR( editline );
  QLabel* label = new QLabel( editline, klocale->translate( "label text" ),
			      this );
  CHECK_PTR( label );
  vbox->addWidget( label, 1 );
  vbox->addWidget( editline, 2 );

  QPushButton* btn = new QPushButton( klocale->translate( "&Color" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( color() ) );
  vbox->addSpacing( 5 );
  vbox->addWidget( btn, 2 );

  QButtonGroup* btngrp = new QButtonGroup( klocale->translate( "cross" ),
					   this );
  CHECK_PTR( btngrp );
  vbox->addSpacing( 5 );
  vbox->addWidget( btngrp, 5 );

  QVBoxLayout* vboxBtns = new QVBoxLayout( btngrp, 5 );
  CHECK_PTR( vboxBtns );
  vboxBtns->addSpacing( 10 );

  rb[0] = new QRadioButton( klocale->translate( "off" ), btngrp );
  CHECK_PTR( rb[0] );
  btngrp->insert( rb[0] );
  vboxBtns->addWidget( rb[0] );
  if ( tlabel->showCross == KTextLabel::off ) rb[0]->setChecked( TRUE );

  rb[1] = new QRadioButton( klocale->translate( "top left" ), btngrp );
  CHECK_PTR( rb[1] );
  btngrp->insert( rb[1] );
  vboxBtns->addWidget( rb[1] );
  if ( tlabel->showCross == KTextLabel::leftTop ) rb[1]->setChecked( TRUE );

  rb[2] = new QRadioButton( klocale->translate( "bottom left" ), btngrp );
  CHECK_PTR( rb[2] );
  btngrp->insert( rb[2] );
  vboxBtns->addWidget( rb[2] );
  if ( tlabel->showCross == KTextLabel::leftBottom ) rb[2]->setChecked( TRUE );

  rb[3] = new QRadioButton( klocale->translate( "top right" ), btngrp );
  CHECK_PTR( rb[3] );
  btngrp->insert( rb[3] );
  vboxBtns->addWidget( rb[3] );
  if ( tlabel->showCross == KTextLabel::rightTop ) rb[3]->setChecked( TRUE );

  rb[4] = new QRadioButton( klocale->translate( "bottom right" ), btngrp );
  CHECK_PTR( rb[4] );
  btngrp->insert( rb[4] );
  vboxBtns->addWidget( rb[4] );
  if ( tlabel->showCross == KTextLabel::rightBottom )
    rb[4]->setChecked( TRUE );

  QHBoxLayout* hbox2 = new QHBoxLayout();
  CHECK_PTR( hbox2 );
  vbox->addSpacing( 5 );
  vbox->addLayout( hbox2, 2 );

  QVBoxLayout* vbox2 = new QVBoxLayout();
  CHECK_PTR( vbox2 );
  hbox2->addLayout( vbox2, 1 );
  leX = new KLined( this, "leX" );
  CHECK_PTR( leX );
  label = new QLabel( leX, "&x", this );
  CHECK_PTR( label );
  vbox2->addWidget( label, 1 );
  vbox2->addWidget( leX, 2 );

  vbox2 = new QVBoxLayout();
  CHECK_PTR( vbox2 );
  hbox2->addLayout( vbox2, 1 );
  leY = new KLined( this, "leY" );
  CHECK_PTR( leY );
  label = new QLabel( leY, "&y", this );
  CHECK_PTR( label );
  vbox2->addWidget( label, 1 );
  vbox2->addWidget( leY, 2 );

  vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addSpacing( 5 );
  hbox->addLayout( vbox, 1 );

  btn = new QPushButton( klocale->translate( "Ok" ), this );
  CHECK_PTR( btn );
  btn->setDefault( TRUE );
  connect( btn, SIGNAL( clicked() ), SLOT( Ok() ) );
  vbox->addWidget( btn, 1 );

  btn = new QPushButton( klocale->translate( "Cancel" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( Cancel() ) );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 5 );

  resize( 300, 280 );

  QString s;
  s.setNum( tlabel->x );
  leX->setText( s );
  s.setNum( tlabel->y );
  leY->setText( s );

  editline->setText( tlabel->text );
  editline->setFocus();
} // KGetLabelTextDlg constructor


void
KGetLabelTextDlg::color()
{
  KColorDialog::getColor( newColor );
} // KGetLabelTextDlg::color


void
KGetLabelTextDlg::Ok()
{
  if ( rb[0]->isChecked() ) tlabel->showCross = KTextLabel::off;
  else if ( rb[1]->isChecked() ) tlabel->showCross = KTextLabel::leftTop;
  else if ( rb[2]->isChecked() ) tlabel->showCross = KTextLabel::leftBottom;
  else if ( rb[3]->isChecked() ) tlabel->showCross = KTextLabel::rightTop;
  else if ( rb[4]->isChecked() ) tlabel->showCross = KTextLabel::rightBottom;

  KExpression* tmp = new KExpression;
  CHECK_PTR( tmp );
  QStrList slist;
  int nError = tmp->parse( leX->text(), &slist, this );
  QDict<double> dict; dict.setAutoDelete( TRUE );
  dict.insert( "x", new double( 1.0 ) );
  if ( nError != err_Ok ) { leX->setFocus(); return; }
  tlabel->x = tmp->getValue( &dict );

  nError = tmp->parse( leY->text(), &slist, this );
  if ( nError != err_Ok ) { leY->setFocus(); return; }
  tlabel->y = tmp->getValue( &dict );

  delete tmp;
  /*
  QString s;
  s = leX->text();
  tlabel->x = s.toDouble();
  s = leY->text();
  tlabel->y = s.toDouble();
  */

  tlabel->text = editline->text();
  tlabel->color = newColor;
  done( TRUE );
} // KGetLabelTextDlg::Ok


void
KGetLabelTextDlg::Cancel()
{
  done( FALSE );
} // KGetLabelTextDlg::Cancel


KTangentDlg::KTangentDlg( QWidget* parent, KExpression* _e, KExpression* _e1 )
  : QDialog( parent, "KTangentDlg", TRUE )
{
  setCaption( klocale->translate( "Plot tangent" ) );
  resize( 300, 90 );

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addLayout( vbox, 2 );
  QLabel* lab = new QLabel(
       klocale->translate( "Plot a tangent to the selected\nfunction in x0." ),
       this );
  vbox->addWidget( lab, 1 );

  QHBoxLayout* hbox2 = new QHBoxLayout();
  CHECK_PTR( hbox2 );
  vbox->addLayout( hbox2, 1 );
  le = new KLined( this, "le" );
  CHECK_PTR( le );
  connect( le, SIGNAL( textChanged( const char*) ), SLOT( leTextChanged() ) );
  lab = new QLabel( le, "&x0 = ", this );
  CHECK_PTR( lab );
  lab->setFixedWidth( 25 );
  hbox2->addWidget( lab, 1 );
  hbox2->addWidget( le, 2 );

  vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addSpacing( 5 );
  hbox->addLayout( vbox, 1 );
  
  btnOk = new QPushButton( klocale->translate( "Ok" ), this );
  CHECK_PTR( btnOk );
  btnOk->setDefault( TRUE );
  connect( btnOk, SIGNAL( clicked() ), SLOT( Ok() ) );
  vbox->addWidget( btnOk, 1 );

  QPushButton* btn = new QPushButton( klocale->translate( "Cancel" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( reject() ) );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );

  le->setText( "0" );

  e = _e;
  e1 = _e1;
} // KTangentDlg constructor


void
KTangentDlg::Ok()
{
  KExpression* tmp = new KExpression;
  CHECK_PTR( tmp );

  QStrList slist;
  int nError = tmp->parse( le->text(), &slist, this );
  QDict<double> dict;
  double x0 = 1.0;
  dict.insert( "x", &x0 );
  if ( nError != err_Ok ) { delete tmp; return; }
  x0 = tmp->getValue( &dict );
  delete tmp;

  dict.clear();
  dict.insert( "x", &x0 );

  bool error = FALSE;

  double c = e->getValue( &dict );
  if( !finite( c ) ) error = TRUE;
  double temp = e1->getValue( &dict );
  if( !finite( temp ) ) error = TRUE;
  c -= temp*x0;

  double m = e1->getValue( &dict );
  if( !finite( m ) ) error = TRUE;

  if( !error ) {
    KNodePlus* plus = new KNodePlus;
    CHECK_PTR( plus );
    KNodeMult* mult = new KNodeMult;
    CHECK_PTR( mult );
    plus->left = mult;
    mult->left = new KNodeValue( m );
    CHECK_PTR( mult->left );
    mult->right = new KNodeVar( "x" );
    CHECK_PTR( mult->right );
    plus->right = new KNodeValue( c );
    CHECK_PTR( plus->right );

    KFunction* f = new KFunction;
    CHECK_PTR( f );
    f->pen = red;
    f->expression = *( new KExpression( plus ) );
    f->expression.simplify();
    f->text = f->expression.print();
    functions->append( f );

    accept();
  } // if
  else {
    KMsgBox::message( this, klocale->translate( "plot tangent" ),
		      klocale->translate( "Cannot plot a tangent in x0!" ) );
  } // else
} // KTangentDlg::Ok


void
KTangentDlg::leTextChanged()
{
  btnOk->setEnabled( QString( le->text() ).length() != 0 );
} // KTangentDlg::leTextChanged
