#ifndef _KFUNCTOOLBAR_H
#define _KFUNCTOOLBAR_H

#include <qpushbt.h>
#include <kspinbox.h>
#include <ktoolbar.h>

#include "kfunction.h"

class KFunctionSpinBox;
class KFunctionToolBar;
class KFunctionButton;

class KFunctionSpinBox : public KSpinBox
{
  Q_OBJECT

public:
  KFunctionSpinBox( QList<KFunction>*& list, QWidget* parent );
 ~KFunctionSpinBox() {};

  void setIndex( uint index );
  uint getIndex() { return _index; };

public slots:
  void slotIncrease();
  void slotDecrease();

private:
  uint _index;
  QList<KFunction>* _list;

signals:
  void selected( KFunction* );
}; // KFunctionSpinBox


class KFunctionToolBar : public KToolBar
{
  Q_OBJECT

public:
  KFunctionToolBar( QWidget* parent );

public slots:
  void edit();
  void del();
  void expressionAdded();
  void expressionDeleted( uint index );

protected:
  KFunctionSpinBox* sb;
  KFunctionButton*  fbtn;

signals:
  void delExpression( uint index );
}; // KFunctionToolBar


class KFunctionButton : public QPushButton
{
  Q_OBJECT

public:
  KFunctionButton( KFunction* f, QWidget* parent );

public slots:
  void setFunction( KFunction* f );

protected:
  virtual void drawButtonLabel( QPainter* paint );

  KFunction* _f;
}; // QPushButton

#endif

