#include <qlayout.h>
#include <qpainter.h>
#include <qpushbt.h>
#include <qtooltip.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kseparator.h>

#include "kfunctoolbar.moc"
#include "koverview.h"

RCSTAG( "$Id: kfunctoolbar.cpp,v 3.1 1998/01/24 18:01:43 kde Exp $" );


KFunctionSpinBox::KFunctionSpinBox( QList<KFunction>*& list, QWidget* parent )
  : KSpinBox( parent )
{
  connect( this, SIGNAL( valueIncreased() ), SLOT( slotIncrease() ) );
  connect( this, SIGNAL( valueDecreased() ), SLOT( slotDecrease() ) );

  _list = list;
  setValue( "" );
} // KFunctionSpinBox constructor


void
KFunctionSpinBox::setIndex( uint index )
{ 
  // check if the index is in the valid range
  if ( index < _list->count() ) {
    setValue( _list->at( _index = index )->text );
    emit selected( _list->at( _index ) );
  } // if
} // KFunctionSpinBox::setIndex


void
KFunctionSpinBox::slotIncrease()
{
  if ( _list->count() == 0 ) {
    setValue( "" );
    return;
  } // if

  _index = ( _index < _list->count()-1 ? _index + 1 : 0 );
  setIndex( _index );
} // KFunctionSpinBox::slotIncrease

void
KFunctionSpinBox::slotDecrease()
{
  if ( _list->count() == 0 ) return;
  _index = ( _index > 0 ? _index : _list->count() ) - 1;
  setIndex( _index );
} // KFunctionSpinBox::slotDecrease


KFunctionToolBar::KFunctionToolBar( QWidget* parent ) : KToolBar( parent )
{
  insertFrame( 1, 150 );
  QFrame* fr = getFrame( 1 );
  sb = new KFunctionSpinBox( functions, fr );
  CHECK_PTR( sb );
  sb->resize( 150, height() - 2 );
  sb->show();

  insertFrame( 2, 75 );
  fr = getFrame( 2 );
  fbtn = new KFunctionButton( static_cast<KFunction*>( NULL ), fr );
  CHECK_PTR( fbtn );
  QToolTip::add( fbtn,
	 klocale->translate( "change the properties of this expression" ) );
  connect( sb, SIGNAL( selected( KFunction* ) ), fbtn,
	   SLOT( setFunction( KFunction* ) ) );
  connect( fbtn, SIGNAL( clicked() ), SLOT( edit() ) );
  fbtn->setGeometry( 0, 1, 75, height() - 4 );
  fbtn->show();

  insertSeparator();

  insertFrame( 3, 75 );
  fr = getFrame( 3 );
  QPushButton* btn = new QPushButton( klocale->translate( "new" ), fr );
  CHECK_PTR( btn );
  QToolTip::add( btn, klocale->translate( "add a new expression" ) );
  connect( btn, SIGNAL( clicked() ), kapp, SLOT( newExpression() ) );
  btn->setGeometry( 0, 1, 75, height() - 4 );
  btn->show();

  insertFrame( 4, 75 );
  fr = getFrame( 4 );
  btn = new QPushButton( klocale->translate( "delete" ), fr );
  CHECK_PTR( btn );
  QToolTip::add( btn, klocale->translate( "delete this expression" ) );
  connect( btn, SIGNAL( clicked() ), this, SLOT( del() ) );
  btn->setGeometry( 0, 1, 75, height() - 4 );
  btn->show();

  insertSeparator();

  QPixmap pm = kapp->getIconLoader()->loadIcon( "viewmag-.xpm" );
  insertButton( pm, 5, SIGNAL( clicked() ), parent, SIGNAL( unzoom() ),
		TRUE, klocale->translate( "unzoom" ) );

  pm = kapp->getIconLoader()->loadIcon( "smalltext.xpm" );
  insertButton( pm, 6, SIGNAL( clicked() ), parent, SIGNAL( addLabel() ),
		TRUE, klocale->translate( "add a text label" ) );
 
  connect( kapp, SIGNAL( expressionAdded() ), SLOT( expressionAdded() ) );
  connect( kapp, SIGNAL( expressionDeleted( uint ) ),
	   SLOT( expressionDeleted( uint ) ) );
  connect( this, SIGNAL( delExpression( uint ) ),
	   kapp, SLOT( delExpression( uint ) ) );
} // KFunctionToolBar constructor


void
KFunctionToolBar::edit()
{
  if ( !functions->count() ) return;

  KFunction* f;
  f = functions->at( sb->getIndex() );
  if ( !f ) return;

  KSettingsDialog* dlg = new KSettingsDialog( f, parentWidget() );
  CHECK_PTR( dlg );
  dlg->exec();
  delete dlg;

  // update the toolbar
  sb->setIndex( sb->getIndex() ); // this will also update the button showing
                                  // the linestyle
} // KFunctionToolBar::edit


void
KFunctionToolBar::del()
{
  if ( !functions->count() ) return;

  emit delExpression( sb->getIndex() );
} // KFunctionToolBar::del


void
KFunctionToolBar::expressionAdded()
{
  // first function added?
  if ( functions->count() == 1 ) {
    fbtn->setFunction( functions->at( 0 ) );
    sb->slotIncrease();
  } // if
} // KFunctionToolBar::expressionAdded


void
KFunctionToolBar::expressionDeleted( uint index )
{
  if ( index == sb->getIndex() ) {
    sb->slotIncrease();

    if ( functions->count() == 0 ) fbtn->setFunction(
					     static_cast<KFunction*>( NULL ) );
    else fbtn->setFunction( functions->at( sb->getIndex() ) );
  } // if
} // KFunctionToolBar::expressionDeleted


KFunctionButton::KFunctionButton( KFunction* f, QWidget* parent )
  : QPushButton( "", parent )
{
  _f = f;
} // KFunctionButton constructor


void
KFunctionButton::setFunction( KFunction* f )
{
  _f = f;

  repaint( TRUE );
} // KFunctionButton::setFunction


void
KFunctionButton::drawButtonLabel( QPainter* paint )
{
  if ( !_f ) return;

  paint->setPen( _f->pen );

  if ( isDown() ) {
    paint->moveTo( 7, height() / 2 + 2 );
    paint->lineTo( width() - 3, height() / 2 + 2 );
  }
  else {
    paint->moveTo( 5, height() / 2 );
    paint->lineTo( width() - 5, height() / 2 );
  }
} // KFunctionButton::drawButtonLabel

