#include <stdlib.h>

#include <qdir.h>
#include <qfile.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qfont.h>

#include <kapp.h>

#include "expression.h"
#include "fnchooser.moc"

RCSTAG( "$Id: fnchooser.cpp,v 3.3 1998/03/17 15:04:34 kde Exp $" );

extern QStrList *lstfunctions;

KFnChooser::KFnChooser (QWidget *_parent, char *_name) :
  QDialog (_parent, _name, TRUE)
{

  QGridLayout* layout = new QGridLayout (this, 10, 4, 10, 2);
  CHECK_PTR( layout );

  listbox = new QListBox( this );
  CHECK_PTR( listbox );
  connect (listbox, SIGNAL (highlighted (int)), SLOT (slotHighlighted (int)));
  connect (listbox, SIGNAL (selected (int)), SLOT (slotSelected (int)));
  layout->addMultiCellWidget (listbox, 1, 9, 0, 1);
  
  QLabel *label = new QLabel( listbox, klocale->translate( "&Functions" ), this );
  CHECK_PTR( label );
  layout->addWidget (label, 0, 0);

  label = new QLabel( this, klocale->translate( "Description" ) );
  CHECK_PTR( label );
  layout->addWidget (label, 0, 2);
  
  btnOK=new QPushButton ( klocale->translate ("Ok"), this);
  CHECK_PTR (btnOK);
  connect (btnOK, SIGNAL (clicked()), SLOT (slotOK()));
  btnOK->setEnabled(FALSE);
  layout->addWidget (btnOK, 9, 2);

  QPushButton *cancel=new QPushButton (klocale->translate ("Cancel"), this);
  CHECK_PTR (cancel);
  connect (cancel, SIGNAL (clicked()), SLOT (reject()) );
  layout->addWidget (cancel, 9, 3);

  description = new KHTMLView (this, "description");
  CHECK_PTR (description);
  layout->addMultiCellWidget (description, 1, 8, 2, 3);

  listbox->insertStrList (lstfunctions);

  layout->activate();

}

bool KFnChooser::setExpression(const char *fn)
{
   if (dictFunctions->find (fn)==0)
    {
      //error message here -- indicates bug in code
      return FALSE;
    }
 
 if (dictFunctions->find (fn)->fnDialog==0)
    {
      fnexpression = fn;
      fnexpression += "($x$)";
      return TRUE;
    }

  //else use the fnDialog...

  return TRUE;
}

void KFnChooser::slotOK ()
{
  if (listbox->currentItem()!=-1)
    {
      if (setExpression (listbox->text (listbox->currentItem()) ) )
	accept();
      else
	reject();
    }
  else
    reject();
}

void KFnChooser::slotHighlighted (int)
{
  btnOK->setEnabled(TRUE);

  // clear the description
  description->begin();
  description->parse();
  description->end();

  QDir dir( kapp->kde_htmldir() );

  QString s = klocale->language();
  s.detach();
  s += "/ksciplot/description";
  if( !dir.cd( s ) ) {
    if( !dir.cd( "default/ksciplot/description" ) ) {
      warning( klocale->translate( "cannot find HTML descriptions under %s" ),
	       dir.path() );
      btnOK->setEnabled(TRUE);
      return;
    } // if
  } // if
  QString path( dir.path() );
  path += "/";
  path += listbox->text( listbox->currentItem() );
  path += ".html";
  QFile file( path );
  if( !file.exists() ) {
    warning( klocale->translate( "cannot find HTML description %s" ),
	     file.name() );
    return;
  } // if

  if( !file.open( IO_ReadOnly ) ) {
    warning( klocale->translate( "cannot open HTML description %s" ),
	     file.name() );
    return;
  } // if

  description->begin( file.name() );
  description->parse();
  char* buffer = static_cast<char*>( malloc( 513 ) );
  buffer[ 512 ] = 0;
  int len;
  while( ( len = file.readBlock( buffer, 512 ) ) == 512 ) {
    description->write( buffer );
  };
  buffer[ len ] = 0;
  description->write( buffer );
  free( buffer );

  description->end();
  file.close();
}

void KFnChooser::slotSelected (int)
{
  slotOK();
}

char *KFnChooser::expression (void)
{
  return fnexpression.data();
}
