#include <qdialog.h>
#include <qfile.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qregexp.h>
#include <qstrlist.h>
#include <qtstream.h>
#include <kapp.h>
#include <kmsgbox.h>

#include "fileoperations.h"
#include "kfunction.h"

RCSTAG( "$Id: fileoperations.cpp,v 3.2 1998/02/14 11:36:16 kde Exp $" );

// #define __DEBUG


class KStatusDialog : public QDialog
{
public:
  KStatusDialog( QWidget* parent, const QStrList* status ) :
    QDialog( parent, "statusDlg", TRUE )
  {
    setCaption( klocale->translate( "status" ) );
    resize( 330, 150 );

    QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
    CHECK_PTR( hbox );
    QListBox* lb = new QListBox( this );
    CHECK_PTR( lb );
    lb->insertStrList( status );
    hbox->addWidget( lb, 3 );
    QVBoxLayout* vbox = new QVBoxLayout();
    CHECK_PTR( vbox );
    hbox->addLayout( vbox, 1 );
    QPushButton* btn = new QPushButton( "&Ok", this );
    CHECK_PTR( btn );
    connect( btn, SIGNAL( clicked() ), SLOT( accept() ) );
    btn->setDefault( TRUE );
    vbox->addWidget( btn, 1 );
    vbox->addStretch( 3 );
  }; // constructor
}; // class KStatusDialog


void
addFunctionsFromFile( QString sFileName )
{
  QFile file( sFileName );
  if ( file.open( IO_ReadOnly ) ) {
    QStrList status;

    QTextStream tstream( &file );
    QString sCurrentLine;
    int nLine = 1;
    
    while( !tstream.eof() ) {
      sCurrentLine = tstream.readLine();
#ifdef __DEBUG
      debug( "%3d: %s", nLine, static_cast<const char*>( sCurrentLine ) );
#endif
      processLine( sCurrentLine, nLine, status );

      nLine++;
    }

    // reparse, as constants may have changed
    uint n;
    KFunction* f;
    for( n = 0; n < functions->count(); n++ ) {
      f = functions->at( n );
      QStrList slist;
      slist.append( "x" );
      f->expression.parse( f->text, &slist );
    } // for

    KStatusDialog* dlg = new KStatusDialog( kapp->mainWidget(), &status );
    CHECK_PTR( dlg );
    dlg->exec();
    delete dlg;
  } // if
  else {
    QString sTemp;
    sTemp.sprintf( "could not open file %s",
		   static_cast<const char*>( sFileName ) );
    KMsgBox::message( kapp->mainWidget(), klocale->translate( "error" ), sTemp,
		      KMsgBox::EXCLAMATION );
  } // else
} // addFunctionsFromFile


bool
processLine( QString sCurrentLine, int nLine, QStrList& status )
{
  QString sError;

  int nComment = sCurrentLine.find( "//" );
  if ( nComment != -1 ) {
    sCurrentLine.resize( ++nComment );
#ifdef __DEBUG
    debug( "comment removed: %s", static_cast<const char*>( sCurrentLine ) );
#endif
  } // if

  sCurrentLine = sCurrentLine.stripWhiteSpace();

  if ( sCurrentLine.isEmpty() ) {
      sError.sprintf( klocale->translate(
	"%3d: ok: no function in this line" ), nLine );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      return TRUE;
  } // if

  int nSeparator = sCurrentLine.find( ":=" );
  if ( nSeparator == -1 ) {
      sError.sprintf( klocale->translate(
	"%3d: error: separator ':=' not found" ), nLine );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      return FALSE;
  } // if

  QString sLeftPart = sCurrentLine.left( nSeparator );
  sLeftPart = sLeftPart.stripWhiteSpace();
  QString sFunctionName;

  int nBracket = sLeftPart.find( "(" );
  if ( nBracket == -1 ) sFunctionName = sLeftPart;
  else sFunctionName = sLeftPart.left( nBracket );
#ifdef __DEBUG
  debug( "function name: %s", static_cast<const char*>( sFunctionName ) );
#endif

  if ( sFunctionName == "x" ) {
    sError.sprintf( klocale->translate(
      "%3d: error: you may not define x!" ), nLine );
#ifdef __DEBUG
    debug( sError );
#endif
    status.append( sError );
    return FALSE;
  } // if

  QRegExp regexp( "[a-zA-Z_][a-zA-Z0-9_]*" );
  int nLen;
  int nStart = regexp.match( sFunctionName, 0, &nLen );

  if ( nStart != 0 ) {
    nLen = 0;
    // will surely match next if
  } // if
  if ( nLen != static_cast<int>( sFunctionName.length() ) ) {
    nLen++;
    sError.sprintf( klocale->translate(
       "%3d: error: illegal char at position %d: %c" ), nLine, nLen,
		    sFunctionName[nLen - 1] );
#ifdef __DEBUG
    debug( sError );
#endif
    status.append( sError );
    return FALSE;
  } // if

  if ( nBracket == -1 ) {
    // propably a constant
    QString sValue = sCurrentLine.right( sCurrentLine.length()-nSeparator-2 );
    sValue = sValue.stripWhiteSpace();
#ifdef __DEBUG
    debug( "sValue = %s", static_cast<const char*>( sValue ) );
#endif

    bool fOk;
    double value = sValue.toDouble( &fOk );
    if ( !fOk ) {
      sError.sprintf( klocale->translate(
        "%3d: error: illegal numeric string: %s" ), nLine,
		      static_cast<const char*>( sValue ) );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      return FALSE;
    } // if
    else {
      double* dOldValue = (*dictConstants)[ sLeftPart ];
      if ( dOldValue != NULL ) {
	QString sMsgTxt;
	sMsgTxt.sprintf( klocale->translate(
          "%s already defined with value %f!\nOverwrite?" ),
	  static_cast<const char*>( sLeftPart ), *dOldValue );
	if ( KMsgBox::yesNo( kapp->mainWidget(),
			klocale->translate( "load from file" ), sMsgTxt )
	  == 2 ) return TRUE;
      } // if

      double* d = new double( value );
      dictConstants->insert( sLeftPart, d );

      sError.sprintf( klocale->translate( "%3d: ok: added constant %s" ),
		      nLine, static_cast<const char*>( sLeftPart ) );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      return TRUE;
    } // else
  } // if bracket found
  else {
    // a function
    userFuncCall* fc = new userFuncCall();
    CHECK_PTR( fc );

    QString sParameters = sLeftPart.right( sLeftPart.length() - nBracket - 1 );
    if ( sParameters.right( 1 ) != ")" ) {
      sError.sprintf( klocale->translate( "%3d: error: no closing bracket" ),
		     nLine );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      delete fc;
      return FALSE;
    } // if
    else sParameters.truncate( sParameters.length() - 1 );
#ifdef __DEBUG
    debug( "parameters: %s", static_cast<const char*>( sParameters ) );
#endif

    // get all parameters
    int len = sParameters.length();
    int index = 0;
    int oldindex = 0;
    while( 1 ) {
      QString sTemp;
      index = sParameters.find( ",", oldindex );
      if ( index == -1 ) {
	sTemp = sParameters.right( len - oldindex );
	sTemp = sTemp.stripWhiteSpace();
#ifdef __DEBUG
	debug( "parameter: '%s'", static_cast<const char*>( sTemp ) );
#endif

	if( fc->vars.find( sTemp ) != -1 ) {
	  sError.sprintf( klocale->translate(
			  "%3d: error: paramter %s used twice!" ), nLine,
			  static_cast<const char*>( sTemp ) );
#ifdef __DEBUG
	  debug( sError );
#endif
	  status.append( sError );
	  return FALSE;
	} // if

	nStart = regexp.match( sTemp, 0, &nLen );
	if ( nStart != 0 ) {
	  nLen = 0;
	  // will surely match next if
	} // if
	if ( nLen != static_cast<int>( sTemp.length() ) ) {
	  nLen++;
	  sError.sprintf( klocale->translate(
	    "%3d: error: illegal char at position %d: %c" ), nLine, nLen,
			  sTemp[nLen - 1] );
#ifdef __DEBUG
	  debug( sError );
#endif
	  status.append( sError );
	  delete fc;
	  return FALSE;
	} // if

	fc->vars.append( sTemp );
	break;
      } // if
      sTemp = sParameters.mid( oldindex, index - oldindex );
      sTemp = sTemp.stripWhiteSpace();

#ifdef __DEBUG
      debug( "parameter: '%s'", static_cast<const char*>( sTemp ) );
#endif

      if( fc->vars.find( sTemp ) != -1 ) {
	sError.sprintf( klocale->translate(
	   "%3d: error: paramter %s used twice!" ), nLine,
			static_cast<const char*>( sTemp ) );
#ifdef __DEBUG
	debug( sError );
#endif
	status.append( sError );
	return FALSE;
      } // if

      nStart = regexp.match( sTemp, 0, &nLen );
      if ( nStart != 0 ) {
	nLen = 0;
	// will surely match next if
      } // if
      if ( nLen != static_cast<int>( sTemp.length() ) ) {
	nLen++;
	sError.sprintf( klocale->translate(
		"%3d: error: illegal char at position %d: %c" ), nLine, nLen,
			sTemp[nLen - 1] );
#ifdef __DEBUG
	debug( sError );
#endif
	status.append( sError );
	delete fc;
	return FALSE;
      } // if

      fc->vars.append( sTemp );
      oldindex = index + 1;
    } // while
    // ok. now all parameters are in the QStrList

    QString sTerm = sCurrentLine.right( sCurrentLine.length()-nSeparator-2 );
    sTerm = sTerm.stripWhiteSpace();
#ifdef __DEBUG
    debug( "sTerm = %s", static_cast<const char*>( sTerm ) );
#endif

    fc->userFunction = new KExpression();
    int nReturn = fc->userFunction->parse( sTerm, &fc->vars );
    fc->numParameters = fc->vars.count();

    funcCall* fcOld = (*dictFunctions)[ sFunctionName ];
    if ( fcOld ) {
      QString sMsgTxt;
      sMsgTxt.sprintf( klocale->translate( "%s already defined!\nOverwrite?" ),
	  static_cast<const char*>( sFunctionName ) );
      if ( KMsgBox::yesNo( kapp->mainWidget(),
			   klocale->translate( "load from file" ), sMsgTxt )
	   == 2 ) {
	delete fc;
	return TRUE;
      } // if
    } // if

    dictFunctions->insert( sFunctionName, fc );
#ifdef __DEBUG
    debug( "parse => %d", nReturn );
#endif

    if ( nReturn != err_Ok ) {
      QString sTemp = fc->userFunction->getErrorText( nReturn );
      sError.sprintf( "%3d: %s", nLine, static_cast<const char*>( sTemp ) );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      delete fc;
      return FALSE;
    } // if
    else {
      sError.sprintf( klocale->translate( "%3d: ok: added function %s" ),
		      nLine, static_cast<const char*>( sFunctionName ) );
#ifdef __DEBUG
      debug( sError );
#endif
      status.append( sError );
      return TRUE;
    } // else
  } // else (= no bracket found)
} // processLine
