;/*************************************************************************
;** funct-3.1      (command interpreter - funct)                          **
;** graph.h :                                                             **
;** Copyright (C) 2003  Jean-Marc Drezet                                  **
;**                                                                       **
;**  This library is free software; you can redistribute it and/or        **
;**  modify it under the terms of the GNU Library General Public          **
;**  License as published by the Free Software Foundation; either         **
;**  version 2 of the License, or (at your option) any later version.     **
;**                                                                       **
;**  This library is distributed in the hope that it will be useful,      **
;**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
;**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
;**  Library General Public License for more details.                     **
;**                                                                       **
;**  You should have received a copy of the GNU Library General Public    **
;**  License along with this library; if not, write to the Free           **
;**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
;**                                                                       **
;** Please mail any bug reports/fixes/enhancements to me at:              **
;**      drezet@math.jussieu.fr                                           **
;** or                                                                    **
;**      Jean-Marc Drezet                                                 **
;**      Institut de Mathematiques                                        **
;**      UMR 7586 du CNRS                                                 **
;**      173, rue du Chevaleret                                           **
;**      75013 Paris                                                      **
;**      France                                                           **
;**                                                                       **
;**************************************************************************/


#ifndef _GRAPH
#define _GRAPH

#include <interp.h>


/*---------------------------------------------------------------------------
    Graphic library specific declarations
---------------------------------------------------------------------------*/
#ifndef __PLOTLIB_X11
#include <g2.h>
#include <g2_PS.h>
#include <g2_gd.h>
#ifndef __G2LIB_X11
extern float            _GRAPH_xx[20];
#endif
#else
#include <plot.h>
#define _FUNCT_OPEN_X11       _FUNCT_plot_open_X11
#define _FUNCT_PLOT           _FUNCT_plot_plot
#define _FUNCT_SET_LINE_WIDTH _FUNCT_plot_set_line_width
#define _FUNCT_LINE_TO        _FUNCT_plot_line_to
#define _FUNCT_PEN            _FUNCT_plot_pen
#define _FUNCT_MOVE           _FUNCT_plot_move
#define _FUNCT_SET_DASH       _FUNCT_plot_set_dash
#define _FUNCT_DRAW_STRING    _FUNCT_plot_draw_string
#define _FUNCT_CLEAR          _FUNCT_plot_clear
#define _FUNCT_INK            _FUNCT_plot_ink
#define _FUNCT_CLOSE          _FUNCT_plot_close
int     _FUNCT_plot_open_X11();
void    _FUNCT_plot_plot(int, int, double, double, float *);
void    _FUNCT_plot_set_line_width(int, int, double, float *);
void    _FUNCT_plot_line_to(int, int, double, double, float *);
void    _FUNCT_plot_pen(int, int, int);
void    _FUNCT_plot_move(int, int, double, double, float *);
void    _FUNCT_plot_set_dash(int, int, int, double *, float *);
void    _FUNCT_plot_draw_string(int, int, double, double, char *, float *);
void    _FUNCT_plot_clear(int iw, int i0);
int     _FUNCT_plot_ink(int, int, double, double, double, int);
void    _FUNCT_plot_close(int, int);
extern FILE           **plot_fic;
extern plPlotter      **plotter,
                      **plotter2;
extern int              _nb_plot_color,
                        _ind_plot,
                        _nb_plot_max,
                        _nb_plot_max2,
                       *plot_color_red,
                       *plot_color_green,
                       *plot_color_blue;
extern float          **_GRAPH_xx;
#endif
#ifdef __GGILIB_X11
#include <ggi/ggi.h>
extern ggi_color        white,
                        black,
                       *ggi_col;
extern int              _nb_ggi_color,
                        ggi_line_width;
extern ggi_visual_t     ggi_vis;
extern ggi_pixel        color_ggi,
                        color_white,
                        color_black;
#define _FUNCT_OPEN_X11       _FUNCT_ggi_open_X11
#define _FUNCT_PLOT           _FUNCT_ggi_plot
#define _FUNCT_SET_LINE_WIDTH _FUNCT_ggi_set_line_width
#define _FUNCT_LINE_TO        _FUNCT_ggi_line_to
#define _FUNCT_PEN            _FUNCT_ggi_pen
#define _FUNCT_MOVE           _FUNCT_ggi_move
#define _FUNCT_SET_DASH       _FUNCT_ggi_set_dash
#define _FUNCT_DRAW_STRING    _FUNCT_ggi_draw_string
#define _FUNCT_CLEAR          _FUNCT_ggi_clear
#define _FUNCT_INK            _FUNCT_ggi_ink
#define _FUNCT_CLOSE          _FUNCT_ggi_close
int     _FUNCT_ggi_open_X11();
void    _FUNCT_ggi_plot(int, int, double, double, float *);
void    _FUNCT_ggi_set_line_width(int, int, double, float *);
void    _FUNCT_ggi_line_to(int, int, double, double, float *);
void    _FUNCT_ggi_pen(int, int, int);
void    _FUNCT_ggi_move(int, int, double, double, float *);
void    _FUNCT_ggi_set_dash(int, int, int, double *, float *);
void    _FUNCT_ggi_draw_string(int, int, double, double, char *, float *);
void    _FUNCT_ggi_clear(int iw, int i0);
int     _FUNCT_ggi_ink(int, int, double, double, double, int);
void    _FUNCT_ggi_close(int, int);
#endif
#ifdef __ALLEGROLIB_X11
extern int              _nb_allegro_color,
                       *allegro_col;
#include <allegro.h>
#define _FUNCT_OPEN_X11       _FUNCT_allegro_open_X11
#define _FUNCT_PLOT           _FUNCT_allegro_plot
#define _FUNCT_SET_LINE_WIDTH _FUNCT_allegro_set_line_width
#define _FUNCT_LINE_TO        _FUNCT_allegro_line_to
#define _FUNCT_PEN            _FUNCT_allegro_pen
#define _FUNCT_MOVE           _FUNCT_allegro_move
#define _FUNCT_SET_DASH       _FUNCT_allegro_set_dash
#define _FUNCT_DRAW_STRING    _FUNCT_allegro_draw_string
#define _FUNCT_CLEAR          _FUNCT_allegro_clear
#define _FUNCT_INK            _FUNCT_allegro_ink
#define _FUNCT_CLOSE          _FUNCT_allegro_close
int     _FUNCT_allegro_open_X11();
void    _FUNCT_allegro_plot(int, int, double, double, float *);
void    _FUNCT_allegro_set_line_width(int, int, double, float *);
void    _FUNCT_allegro_line_to(int, int, double, double, float *);
void    _FUNCT_allegro_pen(int, int, int);
void    _FUNCT_allegro_move(int, int, double, double, float *);
void    _FUNCT_allegro_set_dash(int, int, int, double *, float *);
void    _FUNCT_allegro_draw_string(int, int, double, double, char *, float *);
void    _FUNCT_allegro_clear(int iw, int i0);
int     _FUNCT_allegro_ink(int, int, double, double, double, int);
void    _FUNCT_allegro_close(int, int);
#endif
#ifdef __NULLLIB_X11
#define _FUNCT_OPEN_X11       _FUNCT_null_open_X11
#define _FUNCT_PLOT           _FUNCT_null_plot
#define _FUNCT_SET_LINE_WIDTH _FUNCT_null_set_line_width
#define _FUNCT_LINE_TO        _FUNCT_null_line_to
#define _FUNCT_PEN            _FUNCT_null_pen
#define _FUNCT_MOVE           _FUNCT_null_move
#define _FUNCT_SET_DASH       _FUNCT_null_set_dash
#define _FUNCT_DRAW_STRING    _FUNCT_null_draw_string
#define _FUNCT_CLEAR          _FUNCT_null_clear
#define _FUNCT_INK            _FUNCT_null_ink
#define _FUNCT_CLOSE          _FUNCT_null_close
int     _FUNCT_null_open_X11();
void    _FUNCT_null_plot(int, int, double, double, float *);
void    _FUNCT_null_set_line_width(int, int, double, float *);
void    _FUNCT_null_line_to(int, int, double, double, float *);
void    _FUNCT_null_pen(int, int, int);
void    _FUNCT_null_move(int, int, double, double, float *);
void    _FUNCT_null_set_dash(int, int, int, double *, float *);
void    _FUNCT_null_draw_string(int, int, double, double, char *, float *);
void    _FUNCT_null_clear(int iw, int i0);
int     _FUNCT_null_ink(int, int, double, double, double, int);
void    _FUNCT_null_close(int, int);
#endif
#ifdef __G2LIB_X11
#include <g2_X11.h>
#define _FUNCT_OPEN_X11       _FUNCT_g2_open_X11
#define _FUNCT_PLOT           _FUNCT_g2_plot
#define _FUNCT_SET_LINE_WIDTH _FUNCT_g2_set_line_width
#define _FUNCT_LINE_TO        _FUNCT_g2_line_to
#define _FUNCT_PEN            _FUNCT_g2_pen
#define _FUNCT_MOVE           _FUNCT_g2_move
#define _FUNCT_SET_DASH       _FUNCT_g2_set_dash
#define _FUNCT_DRAW_STRING    _FUNCT_g2_draw_string
#define _FUNCT_CLEAR          _FUNCT_g2_clear
#define _FUNCT_INK            _FUNCT_g2_ink
#define _FUNCT_CLOSE          _FUNCT_g2_close
int     _FUNCT_g2_open_X11();
void    _FUNCT_g2_plot(int, int, double, double, float *);
void    _FUNCT_g2_set_line_width(int, int, double, float *);
void    _FUNCT_g2_line_to(int, int, double, double, float *);
void    _FUNCT_g2_pen(int, int, int);
void    _FUNCT_g2_move(int, int, double, double, float *);
void    _FUNCT_g2_set_dash(int, int, int, double *, float *);
void    _FUNCT_g2_draw_string(int, int, double, double, char *, float *);
void    _FUNCT_g2_clear(int iw, int i0);
int     _FUNCT_g2_ink(int, int, double, double, double, int);
void    _FUNCT_g2_close(int, int);
extern int              _nb_plot_color,
                        _ind_plot,
                        _nb_plot_max,
                        _nb_plot_max2;
extern float          **_GRAPH_xx;
#endif
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
-----------------------------------------------------------------------------
    Function prototypes
-----------------------------------------------------------------------------
---------------------------------------------------------------------------*/

/*===========================================================================
                        graphcmd.c
===========================================================================*/
int     defgraph_cmd(int argc, char *argv[]);
int     graph_plot_cmd(int argc, char *argv[]);
int     graph_lineto_cmd(int argc, char *argv[]);
int     clear_graph_cmd(int argc, char *argv[]);
int     fixcolor_cmd(int argc, char *argv[]);
int     setcolor_cmd(int argc, char *argv[]);
int     fixframe_cmd(int argc, char *argv[]);
int     setframe_cmd(int argc, char *argv[]);
int     clip_line(float, float, float, float, float *, float *);
int     graph_plot_c_cmd(int argc, char *argv[]);
int     graph_lineto_c_cmd(int argc, char *argv[]);
int     set_clip_cmd(int argc, char *argv[]);
int     set_Xwin_cmd(int argc, char *argv[]);
int     draw_string_cmd(int argc, char *argv[]);
int     title_cmd(int argc, char *argv[]);
int     delete_Xwin_cmd(int argc, char *argv[]);
int     line_dash_cmd(int argc, char *argv[]);
int     line_width_cmd(int argc, char *argv[]);
/*---------------------------------------------------------------------------
-----------------------------------------------------------------------------
---------------------------------------------------------------------------*/




extern int              _GRAPH_MESS,
                        _GRAPH_PS,
                        _GRAPH_COL,
                        _GRAPH_FRAM,
                        _GRAPH_X,
                        _GRAPH_Y;
extern pfi              proc_graph[];

typedef struct _CLIP
{
    float       xinf_clip;
    float       xsup_clip;
    float       yinf_clip;
    float       ysup_clip;
} funct_clip;

#ifndef __PLOTG2LIB_X11
extern int              ind0k_gr;
#else
extern int             *ind0k_gr;
#endif

#endif

/*----------------------------
  graphic objects :
    xx[0] : width (pixels)
    xx[1] : height (pixels)
    xx[2] : graphic (g2)
    xx[3], xx[4] : coordinates of the current point

  frames :
    Ix[0] : xmin
    Ix[1] : xmax
    Ix[2] : ymin
    Ix[3] : ymax
    Ix[4] : xtic
    Ix[5] : ytic
----------------------------*/





























