/*************************************************************************
** funct-3.1      (command interpreter - funct)                          **
** geom.h : graphic functions                                            **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
**************************************************************************/

#ifndef _GEOM_INTERP
#define _GEOM_INTERP

#include "interp.h"
#include "funct.h"


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Graphic structures and transforms
----------------------------------------------------------------------
--------------------------------------------------------------------*/
typedef struct
{
   double           x;                 /* first coordinate      */
   double           y;                 /* second coordinate     */
} Point;

typedef struct
{
   double           x;                 /* first coordinate      */
   double           y;                 /* second coordinate     */
} Vector;

typedef struct
{
   Point            A;                 /* One point of the line */
   Vector           U;
} Line;

typedef struct
{
   Point            O;                 /* Center                */
   double           R;                 /* radius                */
} Circle;

typedef struct
{
   int              nb;                /* Number of vertices    */
   Point           *vertex;            /* vertices              */
   int              calc;              /* 0 if the sides have been computed,
                                          1 otherwise           */
   double           step;
   int              icurv;             /* 1 if the polygon is curvilinear,
                                          0 otherwise           */
   Vector          *tgt;               /* tangent vectors       */
   Vector          *d_tgt;             /* their derivative      */
   int             *def_tgt;
} Polygon;

typedef struct
{
    double          a;
    double          b;
    double          c;
    double          d;
} LinTransform;

typedef struct
{
    LinTransform    T;
    Point           P;
} AffTransform;

typedef struct
{
    char           *X;
    char           *Y;
} GenTransform;
/*--------------------------------------------------------------------
--------------------------------------------------------------------*/


#define _geom_eps 0.000001
#define _geom_eps2 0.000000000001
#ifndef PI
#define PI  3.141592653589793238
#endif
#define PI2 1.570796326794896619
#define PID 6.283185307179586476
#define PI3 1.047197551196597746


/*--------------------------------------------------------------------
----------------------------------------------------------------------
    Function prototypes
----------------------------------------------------------------------
--------------------------------------------------------------------*/
/*--------------------------------------------------
        geom.c
--------------------------------------------------*/
/*------- Actions ---------------------*/
int             Span(Point, Point, Line*);
int             Inters_Line_Line(Line, Line, Point*);
void            Solve_2(double, double, double, double, double, double,
                    double*, double*);
int             Sym_Cent_Point(Point, Point, Point*);
int             Sym_Cent_Line(Point, Line, Line*);
int             Sym_Line_Point(Line, Point, Point*);
int             Sym_Line_Line(Line, Line, Line*);
int             Orthog_Line(Line, Point, Line*);
int             Orthog_Proj(Line, Point, Point*);
int             Parallel_Line(Line, Point, Line*);
int             Middle_Point(Point, Point, Point*);
int             Bary_Point(Point, Point, double, Point*);
int             Bary_Many_Points(Point **, int);
int             Bary_Polyg(Polygon, Point *);
int             Rotate_Line(Line, Line*, double);
int             Bissec_Line(Line, Line, Line*);
int             Bissec2_Line(Line, Line, Line*, double);
int             Circle_Span(Point, Point, Point, Circle*);
double          Dist(Point, Point);
double          Dist_Point_Line(Point, Line);
int             Inverse_Line(Line, Line*);
int             Circle_Span4(Line, Line, Line, Circle*);
int             Inters_Line_Circle(Line, Circle, Point*, Point*);
int             Inters_Circle_Circle(Circle, Circle, Point*, Point*);
int             Tangents_to_Circle_from_Point(Point, Circle, Line*, Line*);
int             Move_Orig_Line(double, Line*);
int             Move_Orig_Line2(Point, Line*);
int             Def_Vector_Point(Point, Point, Vector*);
int             Def_Point_Vector(Point, Vector, Point*);
int             Polyg_From_Funcs(funct_d, funct_d, Polygon*);
int             Compute_Sides(Polygon*);
int             Compute_d_tgt(Polygon*);
int             Compute_Sides_dtgt(Polygon*);
int             Curvilinear_Polyg(Polygon, int, Polygon*);
int             Point_on_Polyg(Polygon, double, Point*);
int             Point_on_Polyg_v(Polygon, double, Point*, Vector *v);
int             Point_on_Polyg_v2(Polygon, double, Point*, Vector *v);
int             Evolute_Polyg(Polygon, Polygon *);
double          compute_pol_approx(double *, double *, double);
void            Add_Vector(Vector, Vector, Vector*);
void            Sub_Vector(Vector, Vector, Vector*);
void            Mult_Vector(Vector, double, Vector*);
void            Neg_Vector(Vector, Vector*);
int             Norm_Vector(Vector, Vector*);
int             Orthog_Vector(Vector, Vector*);
void            Rotate_Vector(Vector, double, Vector*);
double          Length_Vector(Vector);
void            Transform_Vector(Vector, LinTransform, Vector*);
double          Product_Vector(Vector, Vector);
double          Angle_Vector(Vector, Vector);
double          Ext_Product_Vector(Vector, Vector);
void            Oper_Vector(int, int, int, int, char *argv[], flow_data*);
void            Oper_LinTransform(int, int, int, int, char *argv[], flow_data*);
int             inverse_Lin_Transform(LinTransform, LinTransform *);
void            act_AffTr_Point(AffTransform, Point, Point*);
int             act_AffTr_Line(AffTransform, Line, Line*);
int             act_AffTr_Polyg(AffTransform, Polygon, Polygon*);
void            act_AffTr_Circle(AffTransform, Circle, Polygon *);
void            act_GenTr_Circle(GenTransform, Circle, Polygon *, flow_data*);
void            act_GenTr_XY(GenTransform, double, double, double *, double *,
                    flow_data *);
void            act_GenTr_Point(GenTransform, Point, Point *, flow_data*);
void            act_GenTr_Polyg(GenTransform, Polygon, Polygon *, flow_data*);
void            act_GenTr_Line(GenTransform, Line, Polygon *, double, double,
                    flow_data*);
void            act_GenTr_Segment(GenTransform, Point, Point, Polygon *,
                    flow_data*);
double          Det_Transform(LinTransform);
void            copy_Polyg(Polygon, Polygon*);
void            destroy_Polyg(Polygon);




/*--------------------------------------------------
        geom_cmd.c
--------------------------------------------------*/
/*------- geometric commands ----------*/
int             Point_Def_Cmd(int argc, char *argv[]);
int             Vector_Def_Cmd(int argc, char *argv[]);
int             Line_Def_Cmd(int argc, char *argv[]);
int             Span_Line_Cmd(int argc, char *argv[]);
int             Inters_Line_Line_Cmd(int argc, char *argv[]);
int             Sym_Cent_Point_Cmd(int argc, char *argv[]);
int             Sym_Cent_Line_Cmd(int argc, char *argv[]);
int             Sym_Line_Point_Cmd(int argc, char *argv[]);
int             Sym_Line_Line_Cmd(int argc, char *argv[]);
int             Orthog_Line_Cmd(int argc, char *argv[]);
int             Orthog_Proj_Cmd(int argc, char *argv[]);
int             Parallel_Line_Cmd(int argc, char *argv[]);
int             Middle_Point_Cmd(int argc, char *argv[]);
int             Bary2_Point_Cmd(int argc, char *argv[]);
int             Bary_Point_Cmd(int argc, char *argv[]);
int             Angle_Vect_Cmd(int argc, char *argv[]);
int             Rotate_Line_Cmd(int argc, char *argv[]);
int             Bissec_Line_Cmd(int argc, char *argv[]);
int             Bissec2_Line_Cmd(int argc, char *argv[]);
int             Circle_Def_Cmd(int argc, char *argv[]);
int             Circle_Span_Cmd(int argc, char *argv[]);
int             Dist_Cmd(int argc, char *argv[]);
int             Dist_Point_Line_Cmd(int argc, char *argv[]);
int             Inverse_Line_Cmd(int argc, char *argv[]);
int             Inters_Line_Circle_Cmd(int argc, char *argv[]);
int             Inters_Circle_Circle_Cmd(int argc, char *argv[]);
int             Tangents_to_Circle_from_Point_Cmd(int argc, char *argv[]);
int             Tangent_to_Polygon_at_Point_Cmd(int argc, char *argv[]);
int             Accel_to_Polygon_at_Point_Cmd(int argc, char *argv[]);
int             Move_Orig_Line_Cmd(int argc, char *argv[]);
int             Move_Orig_Line2_Cmd(int argc, char *argv[]);
int             Polyg_Def_Cmd(int argc, char *argv[]);
int             Polyg_Funct_Cmd(int argc, char *argv[]);
int             Polyg_Curv_Cmd(int argc, char *argv[]);
int             Vertex_Polyg_Cmd(int argc, char *argv[]);
int             Point_on_Polyg_Cmd(int argc, char *argv[]);
int             Def_Point_Vector_Cmd(int argc, char *argv[]);
int             Def_Vector_Point_Cmd(int argc, char *argv[]);
int             LinTransf_Def_Cmd(int argc, char *argv[]);
int             AffTransf_Def_Cmd(int argc, char *argv[]);
int             LinTransf_Coord_Cmd(int argc, char *argv[]);
int             AffTransf_Coord_Cmd(int argc, char *argv[]);
int             Show_LinTransform_Cmd(int argc, char *argv[]);
int             Show_AffTransform_Cmd(int argc, char *argv[]);
int             Inv_Lin_Transform_Cmd(int argc, char *argv[]);
int             Ext_Product_Cmd(int argc, char *argv[]);
int             Vector_Line_Cmd(int argc, char *argv[]);
int             Length_Polyg_Cmd(int argc, char *argv[]);
int             Evolute_Polyg_Cmd(int argc, char *argv[]);
int             GenTransf_Def_Cmd(int argc, char *argv[]);
int             Act_XTr_Geom_Cmd(int argc, char *argv[]);
int             All_Coord_Cmd(int argc, char *argv[]);
int             Show_All_Cmd(int argc, char *argv[]);
int             Funct_Polyg_Cmd(int argc, char *argv[]);
int             Act_GenTr_Segment_Cmd(int argc, char *argv[]);
int             Int_Product_Cmd(int argc, char *argv[]);
/*------------------------------------------------*/




/*--------------------------------------------------
        geom_draw.c
--------------------------------------------------*/
/*------- drawing commands ------------*/
int             Draw_Circle_Cmd(int argc, char *argv[]);
int             Draw_Line_Cmd(int argc, char *argv[]);
int             Draw_Point_Cmd(int argc, char *argv[]);
int             Draw_Polygon_Cmd(int argc, char *argv[]);
int             Draw_LineTo_Cmd(int argc, char *argv[]);
int             Draw_Vect_Cmd(int argc, char *argv[]);
int             Draw_All_Cmd(int argc, char *argv[]);
/*--------------------------------------------------------------------
----------------------------------------------------------------------
--------------------------------------------------------------------*/


extern  pfi         proc_geom[];
extern int          _GEOM_POINT;
extern int          _GEOM_VECTOR;
extern int          _GEOM_LINE;
extern int          _GEOM_CIRC;
extern int          _GEOM_POLYG;
extern int          _GEOM_LINTR;
extern int          _GEOM_AFFTR;
extern int          _GEOM_GENTR;
extern int          _GEOM_MESS;
extern int          _nang_circ;
extern double      *cos_circ;
extern double      *sin_circ;

#endif




























