;-------------------------------------------------------------------------
;-------- program of computation of a power series -----------------------
; serie F Np c n j
;
; F : real DP function 
; F will contain the sum of (c(p)/p!).x^p  from p=0 to p=n
;
; Np : number of points where the series is computed
; c : if  j==0  it is the function c(p)
;     if  j==1  it is a formula giving c(p) in terms of p
;     if  j==3  this parameter is not used, the program calc_func
;		is called and returns c(p) in the variable 'func'
; n : number of terms
; j : the parameter used previously
;------------------------------------------------------------------------
:serie
6
0
-1
desc_func #1
xrange xr_temp 1 #2
fix_xrange xr_temp xmin (xmax-xmin)/(#2-1)
function f_temp xr_temp
function f_temp2 xr_temp
function X_temp xr_temp
fill_func X_temp x
const_func f_temp 1
;
if= #5 L1
p=0
if= #5-1 L2
if= #5-2 L3
goto end
L1:
val_func #3 0
goto L0
L2:
func=#3
goto L0
L3:
calc_func
goto L0
;
;
L0:
rmul f_temp func f_temp2
copy_func f_temp2 #1
fact=1
;
do i 1 #4
mul_func X_temp f_temp f_temp
if= #5 L1b
p=i
if= #5-1 L2b
goto L3b
L1b:
val_func #3 i
goto next
L2b:
func=#3
goto next
L3b:
calc_func
;
next:
fact=fact*i
func=func/fact
rmul f_temp func f_temp2
add_func #1 f_temp2 #1
enddo
;
end:
destroy xr_temp
;
;
;
;
;
;------------------------------------------------------------------------
;-------- test program for 'serie' : computes the exponentiel function -- 
;------------------------------------------------------------------------
:test_serie
1
1
-1
xrange xr 1 1001
xrange xrw 1 1000
fix_xrange xr 0 .001
fix_xrange xrw -1 0.1
function xx xrw
const_func xx 1
function F xr
function F2 xr
serie F 500 xx 20 0
serie F2 500 1 20 1
save_func F F
save_func F2 F2
destroy xrw
destroy xr
;
;
;
;
;
;------------------------------------------------------------------------
;--------------------- test program for 'serie' -------------------------
;    test_serieb a
;    Computes the function sum of (cos(a*p*p)/p!)x^p 
;    for a from 0 to 10 with step 0.05
;------------------------------------------------------------------------
:test_serieb
1
1
-1
xrange xr 1 1001
fix_xrange xr 0 .001
function F xr
;
defgraph ps ps serie.ps portrait
defframe f
frame f 0 1 0 3 0.2 .5
setframe ps f
setcolor ps black
title ps f Computation of power series
string s0 orange
string s1 red
string s2 green
string s3 blue
string s4 yellow
string s5 violet
string s6 Lblue
string s7 orange
string s8 red
string s9 green
string s10 blue
string s11 yellow
string s12 violet
string s13 Lblue
string s14 orange
string s15 red
string s16 green
string s17 blue
string s18 yellow
string s19 violet
string s20 Lblue
;
;
do k 0 20
a=k*.05
serie F 500 cos(a*p*p) 20 1
setcolor ps $[s!(k)]
funct_plot F ps f 0 1 200
enddo
;
destroy xr
destroy ps
destroy f
;
;
;
;
;
;------------------------------------------------------------------------
;---------- Levy-Khintchin formula --------------------------------------
; This program computes the Levy-Khintchin transform of the function
; 	n(x) = 10*(1-x),    0 <= x <= 1
; i.e. the probability function with Poisson kernel n(x)
;------------------------------------------------------------------------
:Lev_Kh
1
1
-1
xrange xr 1 1000
fix_xrange xr 0 0.001
function n xr
fill_func n 10*(1-x)
def_four tr1 n 2048
xrange xr1 1 2000
fix_xrange xr1 0 0.0015
function_C fC xr1
trans_four tr1 fC
function fC.r xr1
function fC.i xr1
real fC fC.r
imag fC fC.i
function t xr1
fill_func t x
function R xr1
function I xr1
mul_func fC.r t R
mul_func fC.i t I
function Si xr1
comp_func sin(x) R Si
function Ex xr1
comp_func exp(-x) I Ex
function f2 xr1
div_func Si t f2
val_func fC.r 0
fix_func_R f2 1 func
function f3 xr1
mul_func f2 Ex f3
def_four tr2 f3 2048
xrange xr2 1 4000
fix_xrange xr2 0 0.01
function_C P xr2
trans_four tr2 P
function P.r xr2
function P.i xr2
real P P.r
imag P P.i
val_func P.r 0
function cnst xr2
const_func cnst func
function q xr2
sub_func cnst P.r q
x=2/pi
rmul q x q
val_func q 18
defgraph ps ps levkh.ps portrait
defframe f
frame f 0 12 0 1 2 .2
setframe ps f
setcolor ps black
title ps f Levy-Khintchin transform of n(x)=10*(1-x)
setcolor ps red
funct_plot q ps f 0 12 400
;
destroy xr
destroy xr2
destroy xr1
destroy tr1
destroy tr2
destroy ps
destroy f
;
;
;
;
;  
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  simple program producing a PS graphic
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
:lion_PS
3
0
-1
;
;
defgraph ps lionPS #2 po
@d=pi/500
@t=0
@a=320.
@b=90.
@A=@a
@B=20.
graphplot lionPS @a*#1 @b*#1
;
do i 1 1000
[1
@t=@t+@d
@x=320.+150.*sin(2.*@t)
@y=240.-150.*cos(3.*@t)
@u=@x+50.*sin(20.*@t)
@v=@y-70.*cos(20.*@t)
]
graphline lionPS @a*#1 @b*#1
graphline lionPS @x*#1 @y*#1
graphline lionPS @u*#1 @v*#1
graphline lionPS @A*#1 @B*#1
graphline lionPS @a*#1 @b*#1
graphline lionPS @x*#1 @y*#1
[1
@a=@x
@b=@y
@A=@u
@B=@v
]
enddo
;
destroy lionPS
;
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  4 graphics in 4 frames in the same PS file
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
:lion_c_b_PS
2
0
-1
;
;
defgraph ps YYY W.ps portrait
defframe f1
defframe f2
defframe f3
defframe f4
frame f1 0 800 0 600 800 600
frame f2 120 680 90 510 800 600
frame f3 240 560 180 420 800 600
frame f4 360 440 240 360 800 600
setclip .05*#1 .45*#1 .05*#1 .45*#1
setframe YYY f1 
setclip .55*#1 .95*#1 .05*#1 .45*#1 
setframe YYY f2 
setclip .05*#1 .45*#1 .55*#1 .95*#1 
setframe YYY f3 
setclip .55*#1 .95*#1 .55*#1 .95*#1
setframe YYY f4 
;
;
setcolor YYY blue
@d=pi/500
setclip .05*#1 .45*#1 .05*#1 .45*#1 
lion_plot_PS f1
setclip .55*#1 .95*#1 .05*#1 .45*#1 
lion_plot_PS f2
setclip .05*#1 .45*#1 .55*#1 .95*#1 
lion_plot_PS f3
setclip .55*#1 .95*#1 .55*#1 .95*#1
lion_plot_PS f4
;
destroy f1
destroy f2
destroy f3
destroy f4
destroy YYY
setclip 0.15 0.9 0.1 0.9
;
;
;
;
:lion_plot_PS
2
0
-1
@t=0
@a=400.
@b=112.
@A=@a
@B=25.
graphplot_c YYY #1 @a @b
;
do i 1 1000
[1
@t=@t+@d
@x=400.+187.*sin(2.*@t)
@y=300.-187.*cos(3.*@t)
@u=@x+62.*sin(20.*@t)
@v=@y-87.*cos(20.*@t)
]
graphline_c YYY #1 @a @b
graphline_c YYY #1 @x @y
graphline_c YYY #1 @u @v
graphline_c YYY #1 @A @B
graphline_c YYY #1 @a @b
graphline_c YYY #1 @x @y
[1
@a=@x
@b=@y
@A=@u
@B=@v
]
enddo
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  PS version of lion_X11_c
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
:lion_c_PS
2
0
-1
;
;
defgraph ps lion3 lion3.ps landscape
defframe f
frame f 320*(1-#1) 320*(1+#1) 240*(1-#1) 240*(1+#1) 640 480 
setframe lion3 f 
setcolor lion3 black
title lion3 f The Lion
setcolor lion3 red
@d=pi/500
@t=0
@a=320.
@b=90.
@A=@a
@B=20.
graphplot_c lion3 f @a @b
;
do i 1 1000
[1
@t=@t+@d
@x=320.+150.*sin(2.*@t)
@y=240.-150.*cos(3.*@t)
@u=@x+50.*sin(20.*@t)
@v=@y-70.*cos(20.*@t)
]
graphline_c lion3 f @a @b
graphline_c lion3 f @x @y
graphline_c lion3 f @u @v
graphline_c lion3 f @A @B
graphline_c lion3 f @a @b
graphline_c lion3 f @x @y
[1
@a=@x
@b=@y
@A=@u
@B=@v
]
enddo
;
destroy lion3
destroy f
;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  execution of all the preceeding programs
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
:all
1
1
-1
time 1
silence 0
example1
echo figure 1  created ! \n
example2
echo figure 2  created ! \n
lion_PS .7 lion1.ps
echo figure 3  created ! \n
lion_c_b_PS .9
echo figure 4  created ! \n
lion_c_PS .8
echo figure 5  created ! \n
;setclip 0.18 0.9 0.1 0.9
Func_draw
echo figure 6  created ! \n
test_bessel
echo figure 7  created ! \n
echo figure 8  created ! \n
echo figure 9  created ! \n
echo figure 10 created ! \n
Lev_Kh
echo figure 11 created ! \n
test_serieb
echo figure 12 created ! \n
example_load
echo figure 13  created ! \n
echo figure 14  created ! \n
convol1
echo figure 15  created ! \n
fft4
echo figure 16 created ! \n
echo figure 17 created ! \n
echo figure 18 created ! \n
Fix_point
echo figure 19 created ! \n
ex0
echo figure 20 created ! \n
ex1 5 6 800
echo figure 21 created ! \n
ex4 5 12 17
echo figure 22 created ! \n
ex6d
echo figure 23 created ! \n
ex7 100
echo figure 24 created ! \n
ex7b 100
echo figure 25 created ! \n
ex7c 1000
echo figure 26 created ! \n
evolx2
echo figure 27 created ! \n
evolx3
echo figure 28 created ! \n
evolx4
echo figure 29 created ! \n
evolx5
echo figure 30 created ! \n
evolx6
echo figure 31 created ! \n
evolx7
echo figure 32 created ! \n
ex9 0.85
echo figure 33 created ! \n
ex16
echo figure 34 created ! \n
echo figure 35 created ! \n
ex16c
echo figure 36 created ! \n
echo figure 37 created ! \n
ex18
echo figure 38 created ! \n
echo figure 39 created ! \n
trans3d 17 40 40
echo figure 40 created ! \n
trans3db 7 14 40
echo figure 41 created ! \n
silence 1
time
;
;
;
;

;------------------------------------------------------------------------
;-------- test program for Bessel transforms ---------------------------- 
;------------------------------------------------------------------------
:test_bessel
1
1
-1
xrange xr 1 1000
fix_xrange xr 0 0.003
xrange xr3 1 1000
fix_xrange xr3 0.001 0.03
;
function n0 xr
fill_func n0 x
def_four tr0 n0 2048
function G0 xr3
def_bes_par zz0 0 400
trans_bessel tr0 zz0 G0
function GG0 xr3
fill_func GG0 3.*jv(1,3.*x)/x
destroy tr0
destroy zz0
;
;
function n5 xr
fill_func n5 x^6
def_four tr5 n5 2048
function G5 xr3
def_bes_par zz5 5 400
trans_bessel tr5 zz5 G5
function GG5 xr3
fill_func GG5 729.*jv(6,3.*x)/x
destroy tr5
destroy zz5
;
;
;
graph_bes 0
graph_bes 5
;
destroy xr
destroy xr3
;
:graph_bes
2
1
-1
defgraph ps ps#1 G#1.ps portrait
defgraph ps ps#1b G#1b.ps portrait
fmin=0
fmax=0
min_func G#1
max_func G#1
fmin=fmin_func
fmax=fmax_func
min_func GG#1
max_func GG#1
if> fmin_func-fmin zz
fmin=fmin_func
zz:
if< fmax_func-fmax yy
fmax=fmax_func
yy
defframe f#1
frame f#1 0 30 fmin fmax 5. 9.5*#1-7.5
setframe ps#1 f#1
defframe f#1b
frame f#1b 0 5 fmin fmax 2. 9.5*#1-7.5
setframe ps#1b f#1b
;
setcolor ps#1 blue
funct_plot G#1 ps#1 f#1 0 30 1000
setcolor ps#1 red
funct_plot GG#1 ps#1 f#1 0 30 1000
;
setcolor ps#1b blue
funct_plot G#1 ps#1b f#1b 0 5 1000
setcolor ps#1b red
funct_plot GG#1 ps#1b f#1b 0 5 1000
destroy f#1
destroy f#1b
;
destroy ps#1
destroy ps#1b
;
;
;
:example_load
1
1
-1
;
;
Max=0.
Min=0.
;
; the 5 functions are loaded and creted (f1 to f5)
do i 1 5
load_create_f x!(i) f!(i) data/data!(i)
desc_func f!(i)
if< xmax-Max zz
Max=xmax
zz:
if> xmin-Min yy
Min=xmin
yy:
enddo
;
;
; the function that will contain the sum is created
xrange_f xr 1 1001
fix_xrange_f xr Min (Max-Min)/1000.
function_f f xr
;
;
; the sum is computed
do i 1 5
add_func f f!(i) f
enddo
;
;
min_func f
max_func f
;
;
;
defframe ff
frame ff  Min-2.  Max+2.  fmin_func-.2  fmax_func+.2  10. 2.
;
; graphics
defgraph ps XXps ex_load.ps po
;
;
;
draw_graph_ex_load XXps f
destroy XXps
;
;
;
;
; smooth versions of the functions
;
xrange_f xrb 1 2001
fix_xrange_f xrb Min-5 (Max+10-Min)/2000.
xrange_f xw 1 201
fix_xrange_f xw -1. 0.01
function_f liss xw
a=sqrt(pi)/sqrt(8)
fill_func liss exp(-8*x*x)/a
function_f FF xrb

do i 1 5
function_f F!(i) xrb
function_f FF!(i) xrb
copy_func f!(i) F!(i)
convol F!(i) liss FF!(i) 256
add_func FF FF!(i) FF
enddo
defgraph ps XXps2 ex_load2.ps po
draw_graph_ex_load XXps2 FF
destroy XXps2
;
;
destroy x1
destroy x2
destroy x3
destroy x4
destroy x5
destroy xr
destroy xrb
destroy xw
destroy ff
;
;
:draw_graph_ex_load
3
1
-1
;
;
setframe #1 ff
funct_plot #2 #1 ff Min Max 500
setcolor #1 red
funct_plot #(2)1 #1 ff Min Max 500
setcolor #1 green
funct_plot #(2)2 #1 ff Min Max 500
setcolor #1 blue
funct_plot #(2)3 #1 ff Min Max 500
setcolor #1 yellow
funct_plot #(2)4 #1 ff Min Max 500
setcolor #1 Lblue
funct_plot #(2)5 #1 ff Min Max 500
;
;
;
:clean_ex_load
1
1
-1
;
;
destroy XX
destroy x1
destroy x2
destroy x3
destroy x4
destroy x5
destroy xr
destroy ff
;
:fft4
1
1
-1
xrange_f xr 1 201
fix_xrange_f xr -1 0.01
function_f fr xr
fill_func fr 2.*exp(-8*x*x)*sin((.2-x)*5.)
function_f fi xr
fill_func fi log(1+x*x)*sin(1.5-x)
function_fC f xr
imag_fix fi f
real_fix fr f
defgraph ps Z fft0.ps po
defframe ff0
frame ff0 -1 1 -.6 2. .25 .2 2 1
setframe Z ff0
setcolor Z red
funct_plot fr Z ff0 -1 1 400
setcolor Z blue
funct_plot fi Z ff0 -1 1 400
def_four Tr f 1024
xrange_f X2 1 1000
fix_xrange_f X2 -25 .05
function_fC F X2
function_fC F2 X2
trans_four Tr F
fft f F2 1024
defgraph ps Xb fft1.ps po
defframe ff
frame ff -25 25 -0.6 0.6 10 .2
setframe Xb ff
setcolor Xb red
funct_plot F Xb ff -25 25 400
setcolor Xb green
funct_plot F2 Xb ff -25 25 400
function_f F2.i X2
imag F2 F2.i
function_f F.i X2
imag F F.i
defgraph ps Y fft2.ps po
setframe Y ff
setcolor Y green
funct_plot F2.i  Y ff -25 25 400
setcolor Y red
funct_plot F.i  Y ff -25 25 400
funct_plot F.i  Y ff -25 25 400
;
;
xrange_f xrb 1 401
fix_xrange_f xrb -1 0.01
fix_func_C f 201 0 0
function_fC fb xrb
copy_func f fb
function_fC F2b X2
fft fb F2b 2048
setcolor Xb blue
setcolor Y blue
function_f F2b.i X2
imag F2b F2b.i
funct_plot F2b Xb ff -25 25 400
funct_plot F2b.i  Y ff -25 25 400
;
;
destroy Xb
destroy Y
destroy Z
destroy xr
destroy xrb
destroy X2
destroy ff
destroy Tr
destroy ff0
;
:convol1
1
1
-1
xrange_f xr 1 401   
fix_xrange_f xr -2 .01
xrange_f xr2 1 401
fix_xrange_f xr2 -2 .01
xrange_f xr3 1 1001
fix_xrange_f xr3 -5 .01
function_f f xr
function_f f2 xr2
function_f f3 xr3
fill_func f exp(-8*x*x)
fill_func f2 exp(-8*x*x)
convol f f2 f3 1024
function_f f4 xr3
a=sqrt(pi)/4
fill_func f4 a*exp(-4.*x*x)
defgraph ps Xb convol1.ps po
defframe ff
frame ff -1.5 1.5 -.1 0.5 2 .2
setframe Xb ff
setcolor Xb red
funct_plot f3 Xb ff -1.5 1.5 400
setcolor Xb blue
funct_plot f4 Xb ff -1.5 1.5 400
destroy Xb
destroy xr
destroy xr2
destroy xr3
destroy ff
;
;
;
:example2
1
0
-1
;
defframe f
frame f 0 2*pi -1 1 1 .2 
dt=pi/200
;
;
defgraph ps ttt sin.ps portrait
setclip 0.1 0.7 0.1 0.7
setframe ttt f
setcolor ttt red
graphplot_c ttt f 0 0
dt=pi/200
;
do i 0 400
t=i*dt
graphline_c ttt f t sin(t)
enddo
;
destroy f
destroy ttt
;
;
;
:example1
1
1
-1
;
defgraph ps yyy example1.ps portrait 
graphplot yyy 100 100
graphline yyy 100 300
graphline yyy 500 300
graphline yyy 500 100
graphline yyy 100 100
setcolor yyy blue
graphplot yyy 150 150
graphline yyy 150 250
graphline yyy 450 250
graphline yyy 450 150
graphline yyy 150 150
destroy yyy
;
;
;
;
:Func_draw
1
1
-1
;
xrange xr 1 1001
fix_xrange xr 0 .001
function F xr
fill_func F sin(16*x)
defframe f
frame f -.1 .95 -1.1 1.1 .2 .2
defgraph ps t Func_port.ps po
setframe t f
setcolor t red
funct_plot F t f 0 1 250
destroy t
destroy f
destroy xr
;
;
;
;
:Fix_point
1
0
-1
;
xrange xr 1 4001
fix_xrange xr -pi pi/2000
function f xr
function g xr
fill_func f cos(x)
defframe F
frame F -pi pi -1 1 1 0.1 2 2
defgraph ps t Fix_point.ps po
setframe t F
title t F Iterations of the function cos(x)
setcolor t red 
funct_plot f t F -pi pi 200
function g xr
comp_func f f g
setcolor t blue             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
comp_func f g g             
funct_plot g t F -pi pi 200
destroy xr
destroy F
destroy t
;
;
;
;
:ex0
1
0
-1
;
;
defframe f
frame f 0 1 0 1 1 1
defgraph ps t ex0.ps po
setframe t f
setcolor t black
title t f Triangle with altitudes
point A
point B
point C
coord A 0.1 0.1
coord B 0.8 0.15
coord C 0.55 0.9
draw A t f
width t 2
draw_to B t f
draw_to C t f
draw_to A t f
width t 1
line AB
line BC
line CA
span_l AB A B
span_l BC B C
span_l CA C A
point HA
point HB
point HC
orthoproj A BC HA
orthoproj B CA HB
orthoproj C AB HC
draw A t f
setcolor t blue
putstring t f -O A
dash t 2
setcolor t red
draw_to HA t f
dash t 0
setcolor t blue
putstring t f -E P
draw B t f
setcolor t blue
putstring t f -E B
dash t 2
setcolor t red
draw_to HB t f
dash t 0
setcolor t blue
putstring t f -O Q
draw C t f
setcolor t blue
putstring t f -N C
dash t 2
setcolor t red
draw_to HC t f
dash t 0
setcolor t blue
putstring t f -S R
destroy A
destroy B
destroy C
destroy AB
destroy BC
destroy CA
destroy HA
destroy HB
destroy HC
destroy f
destroy t
;
;
;
;
;
;
;
;
:ex1
4
0
-1
n=#1
if> n-#2 E1
n=#2
E1:
n0=n
if> n-#3 E2
n=#3
E2:
n=n*40
n0=n0*100
dx=2*pi/n0
xrange xr 1 n0+1
fix_xrange xr 0 dx
function xx xr
function yy xr
fill_func xx 0.5+0.5*cos(#1*x)
fill_func yy 0.5+0.5*sin(#2*x)
defframe f
frame f -0.1 1.1 -0.1 1.1 0.2 0.2
defgraph ps t ex1.ps po
setframe t f
setcolor t black
title t f Lissajou curve in red and curve around it in blue
setcolor t red
polyg p 10
polyg_funct p xx yy
draw p t f
xrange xr2 1 n
dx=2*pi/n
fix_xrange xr2 0 dx
function xx2 xr2
function yy2 xr2
fill_func xx2 0.5+0.5*cos(#1*x)+0.05*cos(#3*x)
fill_func yy2 0.5+0.5*sin(#2*x)+0.05*sin(#3*x)
setcolor t blue
polyg q 10
polyg_funct q xx2 yy2
draw q t f
clean_ex1
;
;
;
;
:clean_ex1
1
1
-1
destroy xr
destroy xr2
destroy p
destroy q
destroy f
destroy t
;
;
;
;
:ex4
3
0
-1
xrange xr 1 10000
fix_xrange xr 0 2*pi/300
function xx xr
function yy xr
a=#1
b=#2
c=a-b
d=a/b-1
fill_func xx c*cos(x)+b*cos(d*x)
fill_func yy c*sin(x)-b*sin(d*x)
defframe f
frame f -abs(c)-b abs(c)+b -abs(c)-b abs(c)+b abs(c)+b abs(c)+b
defgraph ps t ex4.ps po
setframe t f
setcolor t black
title t f Hypocycloid with a=12, b=17
setcolor t red
polyg p 10
polyg_funct p xx yy
draw p t f
destroy xr
destroy p
destroy f
destroy t
;
;x = (a - b) cos(t) + b cos((a/b - 1)t), y = (a - b) sin(t) - b sin((a/b - 1)t) 
;
;
;
;
:ex6d
1
0
-1
point O
point A
point B
point C
point O2
point A2
point B2
point C2
vector OB
vector BA2
vector AA2
vector A2O2
vector BB2
vector B2O2
vector B2C
vector CC2
vector OC
defframe f
frame f -0.8 0.8 -0.8 0.8 3 3
defgraph ps tt ex6d.ps po
setcolor tt black
title tt f Moving cube
setframe tt f noax
vector U
vector V
vector Tr
dt=pi/400
i=420
t=i*dt
som_pard t 2*t 3*t abs(cos(t/4))
transl cos(5*t)/2 sin(4*t)/2
somm
drawubec
destroy O
destroy A
destroy B
destroy C
destroy O2
destroy A2
destroy B2
destroy C2
destroy f
destroy OB
destroy BA2
destroy AA2
destroy A2O2
destroy BB2
destroy B2O2
destroy B2C
destroy CC2
destroy OC
destroy U
destroy V
destroy Tr
destroy tt
;
;
;
;
:som_pard
5
0
-1
; 1 : theta0, 2 : phi0, 3 : rot
c0=cos(#1)
s0=sin(#1)
sp0=sin(#2)
cp0=cos(#2)
cr=cos(#3)
sr=sin(#3)
coord A #4*c0*cp0 #4*s0*cp0
coord B #4*(-s0*cr+sp0*c0*sr) #4*(c0*cr+sp0*s0*sr)
coord C #4*(s0*sr+sp0*c0*cr) #4*(-c0*sr+sp0*s0*cr)
;
;
;
;
;
;
;
:drawubec
1
0
-1
vect_s
; face O B A2 A
ext_prod OB BA2
if< ext_p XXX1
setcolor tt black
draw_sqr O B A2 A
setcolor tt blue
draw_diag O B A2 A
; face A A2 O2 C2
XXX1:
ext_prod AA2 A2O2
if< ext_p XXX2
setcolor tt black
draw_sqr A A2 O2 C2
setcolor tt green
draw_diag A A2 O2 C2
; face B B2 O2 A2
XXX2:
ext_prod BB2 B2O2
if< ext_p XXX3
setcolor tt black
draw_sqr B B2 O2 A2
setcolor tt red
draw_diag B B2 O2 A2
; face B2 C C2 O2
XXX3:
ext_prod B2C CC2
if< ext_p XXX4
setcolor tt black
draw_sqr B2 C C2 O2
setcolor tt blue
draw_diag B2 C C2 O2
; face B O C B2
XXX4:
ext_prod OB OC
if> ext_p XXX5
setcolor tt black
draw_sqr B O C B2
setcolor tt green
draw_diag B O C B2
; face C2 C O A
XXX5:
ext_prod CC2 OC
if< ext_p XXX6
setcolor tt black
draw_sqr C2 C O A
setcolor tt red
draw_diag C2 C O A
;
XXX6:
;
;
;
;
;
:draw_diag
5
0
-1
draw #1 tt f
draw_to #3 tt f
draw #2 tt f
draw_to #4 tt f
;
;
;
;
:somm
1
0
-1
; U=vec(OC), V=vec(OB)
vector_p O C U
vector_p O B V
point_v A U C2
point_v B U B2
point_v A V A2
point_v A2 U O2
;
;
;
;
:vect_s
1
0
-1
vector_p O B OB
vector_p B A2 BA2
vector_p A A2 AA2
vector_p A2 O2 A2O2
vector_p B B2 BB2
vector_p B2 O2 B2O2
vector_p B2 C B2C
vector_p C C2 CC2
vector_p O C OC
;
;
;
;
;
:draw_sqr
5
0
-1
draw #1 tt f
draw_to #2 tt f
draw_to #3 tt f
draw_to #4 tt f
draw_to #1 tt f
;
;
;
;
;
;
;
;
:ex7
2
0
-1
xrange xr 1 1000
fix_xrange xr 0 0.001
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy sin(pi*x*x)
defframe f
frame f -0.2 0.5 -0.5 1.5 0.2 0.2
defgraph ps G ex7.ps po
setframe G f
setcolor G black
title G f Tangents to a curve
setcolor G red
polyg p 10
polyg_funct p xx yy
draw p G f
polyg_curv p p 1035
length_pol p
dt=length_pol/#1
line L
setcolor G blue
do i 1 #1
x=i*dt
tangent_p p x L
draw L G f
enddo
destroy xr
destroy f
destroy p
destroy L
destroy G
;
;
;
;
;
;
:ex7b
2
0
-1
xrange xr 1 1000
fix_xrange xr 0 0.001
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy 0.25*sin(pi*x*x)
defframe f
frame f -0.3 0.5 -0.25 0.5. 0.1 0.1
defgraph ps G ex7b.ps po
setframe G f
setcolor G black
title G f Tangent vectors to a curve
setcolor G red
polyg p 10
polyg_funct p xx yy
draw p G f
polyg_curv p p 1035
length_pol p
dt=length_pol/#1
line L
vector v
point A
setcolor G green
do i 1 #1
x=i*dt
tangent_p p x L
vector_l L v
multiply v 0.25 v
point_pol p x A
draw A G f
draw v G f
enddo
destroy xr
destroy f
destroy p
destroy L
destroy v
destroy A
destroy G
;
;
;
;
;
;
:ex7c
2
0
-1
xrange xr 1 5000
fix_xrange xr 0 0.0002
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy 0.25*sin(pi*x*x)
defframe f
frame f -0.05 0.3 -0.1 0.3. 0.1 0.1
defgraph ps G ex7c.ps po
setframe G f
setcolor G black
title G f In green : acceleration vectors of the blue curve
setcolor G red
polyg p 10
polyg_funct p xx yy
draw p G f
polyg q 10
polyg_curv p q 2000
setcolor G blue
length_pol q
draw q G f
dt=length_pol/#1
line L
vector v
point A
point B
point B0
setcolor G green
do i 1 #1-1
x=i*dt
accel_p q x v A
multiply v 0.01 v
point_v A v B
draw_to B G f
enddo
destroy xr
destroy f
destroy A
destroy B0
destroy B
destroy p
destroy q
destroy L
destroy v
destroy G
;
;
;
;
;  Cardioid
:evolx2
1
0
-1
xrange xr 1 4000
fix_xrange xr 0 pi/1900
function xx xr
function yy xr
fill_func xx (1+cos(x))*cos(x)
fill_func yy (1+cos(x))*sin(x)
defframe f
frame f -0.5 2.5 -1.5 1.5 0.5 0.5
defgraph ps G evolx2.ps po
setframe G f
setcolor G black
title G f The cardioid in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f 0 1900
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
;  Epicycloid
:evolx3
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/600
function xx xr
function yy xr
fill_func xx cos(x)-3*cos(7*x/3)/7
fill_func yy sin(x)-3*sin(7*x/3)/7
defframe f
frame f -1.5 1.5 -1.5 1.5 0.5 0.5
defgraph ps G evolx3.ps po
setframe G f
setcolor G black
title G f An epicycloid in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f 10 900
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
;  Trifolium
:evolx4
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx cos(x)*cos(x)*(4*sin(x)*sin(x)-1)
fill_func yy sin(x)*cos(x)*(4*sin(x)*sin(x)-1)
defframe f
frame f -1.5 1.5 -1.5 1.5 0.5 0.5
defgraph ps G evolx4.ps po
setframe G f
setcolor G black
title G f The trifolium in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
;  Nephroid
:evolx5
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx 3*cos(x)-cos(3*x)
fill_func yy 3*sin(x)-sin(3*x)
defframe f
frame f -5 5 -5 5 2 2
defgraph ps G evolx5.ps po
setframe G f
setcolor G black
title G f The nephroid in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
;  Rhodonea Curve
:evolx6
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx cos(x)*sin(5*x)
fill_func yy sin(x)*sin(5*x)
defframe f
frame f -2.5 2.5 -2.5 2.5 1 1
defgraph ps G evolx6.ps po
setframe G f
setcolor G black
title G f The rhodonea curve in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
;  Tricuspoid
:evolx7
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx 2*cos(x)+cos(2*x)
fill_func yy 2*sin(x)-sin(2*x)
defframe f
frame f -9 9 -9 9 2.5 2.5
defgraph ps G evolx7.ps po
setframe G f
setcolor G black
title G f The tricuspoid in red and its evolute in blue
setcolor G red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q G f
polyg r 10
setcolor G blue
evol q r
draw r G f
destroy xr
destroy f
destroy p
destroy q
destroy r
destroy G
;
;
;
;
:ex9
2
0
-1
point A
coord A 0 0
point B
coord B 1 0
point C
coord C #1 0.8660254037844386
line AB
span_l AB A B
line BC
span_l BC B C
line AC
span_l AC A C
defframe f
frame f -0.1 1.5 -0.1 1.5 0.5 0.5
defgraph ps G ex9.ps po
setframe G f
setcolor G black
title G f A triangle and a geometric locus associated to it
draw A G f
putstring G f -SO A
draw B G f
putstring G f -SE B
draw C G f
putstring G f -N C
setcolor G red
draw B G f
draw_to C G f
draw_to A G f
draw_to B G f
point AT
point BT
point CT
point XT
vector ct
vector xt
vector bt
vector V
vector W
vector X
setcolor G blue
do i -1250 650 4
t=i/100
bary2 A B t AT
bary2 B C t BT
bary2 C A t CT
dist AT BT
ct=dist_p
dist CT BT
at=dist_p
dist AT CT
bt=dist_p
vector_p AT BT ct
vector_p AT CT bt
multiply ct bt/(at+bt+ct) V
multiply bt ct/(at+bt+ct) W
add V W X
point_v AT X XT
if> i+1250 XXX
draw XT G f
XXX:
draw_to XT G f
enddo
destroy A
destroy B
destroy C
destroy AB
destroy BC
destroy AC
destroy AT
destroy BT
destroy CT
destroy XT
destroy ct
destroy xt
destroy bt
destroy V
destroy W
destroy X
destroy f
destroy G
;
;
;
;
:ex16
1
0
-1
defframe f
frame f 0 1 0 1 1 1
defgraph ps G ex16.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (I)
circle C00
point O
coord O 0.5 0.5
coord C00 O 0.45
point A
point B
point C
point P
point P1
line BA
line AB
line BC
line AC
line lA
line lB
line lC
line lA1
line lB1
line lC1
point A0
point B0
point C0
point A1
point B1
point C1
polyg Pol 361
polyg Pol2 361
ang1=-20
ang2=210
da=pi/180
coord A 0.5+0.45*cos(ang1*da) 0.5+0.45*sin(ang1*da)
coord B 0.5+0.45*cos(ang2*da) 0.5+0.45*sin(ang2*da)
span_l AB A B
span_l BA B A
j=-1
;
do i ang1+1 ang1+361
ang=i*da
j=j+1
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
inters BC lA A0
inters AB lC C0
inters AC lB B0
inters lA lB P
middle A B C1
middle B C A1
middle A C B1
span_l lA1 A A1
span_l lB1 B B1
span_l lC1 C C1
inters lA1 lB1 P1
show P
coord Pol j point_x point_y
show P1
coord Pol2 j point_x point_y
if= i-120 ZZZ
if= i-ang1-361 ZZZb 
goto ZZZ2
ZZZb:
defgraph ps G ex16_2.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (I)
goto ZZZc
ZZZ:
draw C00 G f
setcolor G red
draw A G f
draw_to B G f
draw_to C G f
draw_to A G f
setcolor G violet
draw C G f
draw_to C0 G f
draw A G f
draw_to A0 G f
draw B G f
draw_to B0 G f
setcolor G blue
draw C G f
draw_to C1 G f
draw A G f
draw_to A1 G f
draw B G f
draw_to B1 G f
;
ZZZc:
setcolor G green
draw Pol G f 0 j
setcolor G blue
draw Pol2 G f 0 j
setcolor G red
draw A G f
draw_to B G f
setcolor G black
draw C00 G f
destroy G
ZZZ2:
enddo
destroy f
destroy O
destroy A
destroy B
destroy C
destroy P
destroy P1
destroy A0
destroy B0
destroy C0
destroy A1
destroy B1
destroy C1
destroy BA
destroy AB
destroy BC
destroy AC
destroy lA
destroy lB
destroy lC
destroy lA1
destroy lB1
destroy lC1
destroy C00
destroy Pol
destroy Pol2
;
;
;
;
:ex16c
1
0
-1
defframe f
frame f -0.6 1.6 -0.48 1.72 5 5
defgraph ps G ex16c.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (Ib)
circle C00
point O
coord O 0.5 0.5
coord C00 O 0.45
point A
point B
point C
point P
point PA
point PB
point PC
line BA
line AB
line BC
line AC
line CA
line lA
line lB
line lC
line lA2
line lB2
line lC2
polyg Pol 361
polyg Pol2 361
polyg Pol3 361
polyg Pol4 361
polyg Polb 361
polyg Pol2b 361
polyg Pol3b 361
polyg Pol4b 361
ang1=-20
ang2=210
da=pi/180
coord A 0.5+0.45*cos(ang1*da) 0.5+0.45*sin(ang1*da)
coord B 0.5+0.45*cos(ang2*da) 0.5+0.45*sin(ang2*da)
span_l AB A B
span_l BA B A
j=-1
;
do i ang1+1 ang2-1
ang=i*da
j=j+1
j0=j
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
span_l CA C A
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
bissec AB BC lB2
bissec AC BA lA2
bissec CA BC lC2
inters lA lB P
inters lC2 lA2 PB
inters lC2 lB2 PA
inters lA2 lB2 PC
show P
coord Pol j point_x point_y
show PA
coord Pol2 j point_x point_y
show PB
coord Pol3 j point_x point_y
show PC
coord Pol4 j point_x point_y
if= i-120 AZZZ
goto AZZZ2
AZZZ:
draw C00 G f
setcolor G red
draw A G f
draw_to B G f
draw_to C G f
draw_to A G f
setcolor G blue
draw lA G f
draw lA2 G f
draw lB G f
draw lB2 G f
draw lC G f
draw lC2 G f
;
setcolor G green
draw Pol G f 0 j
draw Pol2 G f 0 j
draw Pol3 G f 0 j
draw Pol4 G f 0 j
setcolor G black
setframe G f noax
destroy G
AZZZ2:
enddo
;
j=-1
do i ang2+1 ang1+359
ang=i*da
j=j+1
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
span_l CA C A
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
bissec AB BC lB2
bissec AC BA lA2
bissec CA BC lC2
inters lA lB P
inters lC2 lA2 PB
inters lC2 lB2 PA
inters lA2 lB2 PC
show P
coord Polb j point_x point_y
show PA
coord Pol2b j point_x point_y
show PB
coord Pol3b j point_x point_y
show PC
coord Pol4b j point_x point_y
if= i-ang1-359 BZZZb 
goto BZZZ2
BZZZb:
defgraph ps G ex16c_2.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (I)
setcolor G green
draw Polb G f 0 j
draw Pol2b G f 0 j
draw Pol3b G f 0 j
draw Pol4b G f 0 j
draw Pol G f 0 j0
draw Pol2 G f 0 j0
draw Pol3 G f 0 j0
draw Pol4 G f 0 j0
setcolor G black
setframe G f noax
draw C00 G f
destroy G
BZZZ2:
enddo
destroy f
destroy O
destroy A
destroy B
destroy C
destroy P
destroy PA
destroy PB
destroy PC
destroy BA
destroy AB
destroy BC
destroy AC
destroy CA
destroy lA
destroy lB
destroy lC
destroy lA2
destroy lB2
destroy lC2
destroy C00
destroy Pol
destroy Pol2
destroy Pol3
destroy Pol4
destroy Polb
destroy Pol2b
destroy Pol3b
destroy Pol4b
;
;
;
;
:ex18
1
0
-1
point A
point O
point O1
point O2
point A1
point A2
point P
point P1
point Q1
point Q
point M
vector U
line l
line lp
line lq
line ort
line ort2
line med1
line med2
polyg Pol 362
polyg Pol2 362
circle C
circle C2
coord O 0 0
coord C O 0.5
d=-3
coord A -2 0
dist A O
d2=sqrt(dist_p*dist_p-0.25)
coord C2 A d2
inters_cc C C2 P Q
span_l lp P A
span_l lq Q A
defframe f
frame f -2.2 1.2 -1.7 1.7 5 5
defgraph ps G ex18.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (II)
dt=pi/180
subex18
destroy f
destroy A
destroy A1
destroy A2
destroy O
destroy O1
destroy O2
destroy P
destroy P1
destroy Q
destroy Q1
destroy M
destroy U
destroy l
destroy lp
destroy lq
destroy ort
destroy ort2
destroy med1
destroy med2
destroy C
destroy C2
destroy Pol
destroy Pol2
;
;
;
;
:subex18
1
0
-1
j=-1
do i 0 361
j=j+1
a=i*dt
coord M 0.5*cos(a) 0.5*sin(a)
coord U -sin(a) cos(a)
coord l M U
inters l lp P
if= i-220 SS1
;if= i-361 SS3
goto SS2
SS1:
setcolor G blue
draw l G f
draw lp G f
draw lq G f
;
SS2:
trace 1
b=retval-1
if= b XXX
inters l lp P1
inters l lq Q1
b=1-retval
if= b XXX
trace 0
XXX:
middle A P1 A1
middle A Q1 A2
ortholine lp A1 ort
ortholine lq A2 ort2
if= i-220 SS1b
goto SS2b
SS1b:
setcolor G red
draw ort G f
draw ort2 G f
SS2b:
span_l med1 Q1 A1
span_l med2 P1 A2
if= i-220 SS1c
goto SS2c
SS1c:
setcolor G orange
draw med1 G f
draw med2 G f
SS2c:
inters med1 med2 O1
inters ort ort2 O2
show O1
coord Pol j point_x point_y
show O2
coord Pol2 j point_x point_y
sleep 20
if= i-220 SS1d
goto SS2d
SS1d:
setcolor G green
draw Pol G f 0 j
setcolor G violet
draw Pol2 G f 0 j
setcolor G black
draw C G f
setcolor G blue
draw lp G f
draw lq G f
setframe G f noax
destroy G
SS2d:
enddo
defgraph ps G ex18_2.ps po
setframe G f noax
setcolor G black
title G f Two geometric locus associated to a moving triangle (II)
setcolor G blue
setcolor G green
draw Pol G f 0 j
setcolor G violet
draw Pol2 G f 0 j
setcolor G black
draw C G f
setcolor G blue
draw lp G f
draw lq G f
destroy G
;
;
;
;
; trans3d 17 40 40
:trans3d
4
0
-1
transform_gen T x+sin(#1*y)/#2 y+cos(#1*x)/#2
xrange xr 1 10001
fix_xrange xr 0 pi/5000
function X xr
function Y xr
fill_func X cos(x)
fill_func Y sin(x)
polyg P 10000
polyg_funct P X Y
defframe F
if> #1-4 XXX
frame F -4 4 -4 4 2 2
goto YYY
XXX:
frame F -2 2 -2 2 1 1
YYY:
defgraph ps G trans3d.ps po
setframe G F
title G F 100 successive transforms of a circle 
setcolor G red
do i 1 #3
act T P P
enddo
setcolor G red
draw P G F
destroy P
destroy F
destroy T
destroy xr
destroy G
;
;
;
;
; trans3db 7 14 40
:trans3db
4
0
-1
transform_gen T x+sin(#1*y)/#2 y+cos(#1*x)/#2
xrange xr 1 10001
fix_xrange xr 0 pi/5000
function X xr
function Y xr
fill_func X cos(x)
fill_func Y sin(x)
polyg P 10000
polyg_funct P X Y
defframe F
if> #1-4 XXX
frame F -4 4 -4 4 2 2
goto YYY
XXX:
frame F -2 2 -2 2 1 1
YYY:
defgraph ps G trans3db.ps po
setframe G F
title G F 100 successive transforms of a circle 
setcolor G red
do i 1 #3
act T P P
enddo
setcolor G red
draw P G F
destroy P
destroy F
destroy T
destroy xr
destroy G
;
;
