/*
   fofx: function grapher for ASCII terminals
   Copyright (C) 1997 Tom Stepleton

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
   all_lcase: Converts everything to lowercase
   preparse: changes things like "sin" to easily-parsed 1-char tokens
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fofx.h"       
#include "fofx_err.h"

unsigned char *all_lcase(unsigned char *thestring)
{
  unsigned char *newstring, *newstptr, *stptr;

  if(!(newstring = calloc(strlen(thestring)+1,sizeof(unsigned char))))
    fatal_error(ALL_LCASE_ERROR,MEMORY_ERROR);

  stptr = thestring;
  newstptr = newstring;

  while(*stptr) {
    *newstptr = tolower(*stptr);

    stptr++;
    newstptr++;
  }

  return(newstring);
}

void preparse(unsigned char *phrase, unsigned char token)
{
  unsigned char *string, *newstring, *zap;
  unsigned char *newstptr, *stptr;
  int i;  

  if(!(string = calloc(strlen(function)+1,sizeof(unsigned char))))
    fatal_error(PREPARSE_ERROR,MEMORY_ERROR);

  strcpy(string,function);

  for(;;) {
    if(!(zap = strstr(string,phrase))) break;

    if(!(newstring = calloc(strlen(string)+1,sizeof(unsigned char))))
      fatal_error(PREPARSE_ERROR,MEMORY_ERROR);

    stptr = string;
    newstptr = newstring;

    while(*stptr) {
      if(stptr == zap) {
        stptr = stptr + strlen(phrase);
        *newstptr = token;
        newstptr++;
      }

      *newstptr = *stptr;
      newstptr++;
      stptr++;
    }

    *newstptr = '\0';

    strcpy(string,newstring);
    free(newstring);
  }

  free(function);
  function = string;
}
