/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY


#include "pfsinglist.hpp"

Singularity::Singularity(float X, float Y, 
			 int Type, double Mag, double Ang)
{
  x=X;
  y=Y;
  t=Type;
  ang=Ang;
  mag=Mag;
}

SingList::SingList(QObject *parent, const char *name):QObject(parent,name){
  setAutoDelete(TRUE);
  d_FreeSpeed=0.0;
  d_FreeDirection=0.0;
}

void SingList::addNewSingularity(float X, float Y, 
				 int Type,
				 double Mag, double ang,
				 bool update){
  Singularity *s=new Singularity(X,Y,Type,Mag,ang);
  append(s);
  if (update){
    emit NewItemAdded(s);
    emit ListChanged();
  };
}

void SingList::clear(){
  d_FreeSpeed=0.0;
  d_FreeDirection=0.0;
  
  last();
  while(remove()){};

  emit ListChanged();
  emit ListCleared();
}


void SingList::change(int Index, float X, float Y, 
		      int Type, double Mag, double Ang){
  Singularity *l_Sing=at(Index);
  l_Sing->x=X;
  l_Sing->y=Y;
  l_Sing->t=Type;
  l_Sing->mag=Mag;
  l_Sing->ang=Ang;

  emit ListChanged();
}

void SingList::setFreeStream(double Mag, double Ang){
  d_FreeSpeed=Mag;
  d_FreeDirection=Ang;

  emit ListChanged();
}

void SingList::setFreeSpeed(double NewVal){
  d_FreeSpeed=NewVal;

  emit ListChanged();
}
void SingList::setFreeDirection(double NewVal){
  d_FreeDirection=NewVal;

  emit ListChanged();
}
    
double SingList::getFreeSpeed(){
  return d_FreeSpeed;
}

double SingList::getFreeDirection(){
  return d_FreeDirection;
}
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
