/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY


#include "pfgrid.hpp"

Grid::Grid(int p_Interval){
  d_Interval=p_Interval;
  //  d_GridColor=QColor(0,100,0);
}

void Grid::plot(QPainter *p)
{
  QRect Region;

  QPen l_Pen(d_GridColor,0,DotLine);


  Region=p->window();
  p->setPen(l_Pen);
  for(int i=-9;i<10;i++){
    p->drawLine(-10000,i*1000,10000,i*1000);
    p->drawLine(i*1000,-10000,i*1000,10000);
  }
  p->setPen(QPen(d_GridColor,1,SolidLine));
  p->drawLine(0,-10000,0,10000);
  p->drawLine(10000,0,-10000,0);
}  

void Grid::setGridColor(QColor p_C){
  d_GridColor=p_C;
};
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
