/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFFPOINT_H
#define PFFPOINT_H 1

class FPoint
{
public:
    FPoint()	{}
    FPoint( float xpos, float ypos );

    float   x()		const;
    float   y()		const;
    void   setX( float x );
    void   setY( float y );

private:
    float xp;
    float yp;

};

inline FPoint::FPoint( float xpos, float ypos )
{ xp=(float)xpos; yp=(float)ypos; }

inline float FPoint::x() const
{ return xp; }

inline float FPoint::y() const
{ return yp; }

inline void FPoint::setX( float x )
{ xp = (float)x; }

inline void FPoint::setY( float y )
{ yp = (float)y; }

#endif // FPOINT_H
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
