/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFFILEDLG_HPP
#define PFFILEDLG_HPP 1
#include <qfiledialog.h>
#include <qbitarray.h>

class QString;
class QLineEdit;
class QComboBox;
class QLabel;
class QPushButton;
class QCheckBox;
class QGroupCox;
class QButtonGroup;

class PFFileDlg : public QDialog
{
Q_OBJECT

public:
  PFFileDlg(QString l_FileName,
	    QWidget *parent=0,
	    const char *name=0,
	    bool modal=FALSE,
	    bool open=TRUE);
  ~PFFileDlg();

  static QBitArray getOpenFileFlags(QString p_FileName, 
				  QWidget *parent = 0, 
				  const char *name = 0);
  static QString getSaveFileName(QWidget *parent = 0, 
				 const char *name = 0);
  QString fileName();

private slots:
  void setFlag(int id);


private:
  void openInit(QString l_FileName);
  void saveInit();
  
  QBitArray d_Flags;
  QPushButton *okB;
  QPushButton *cancelB;
  QButtonGroup *d_Options;
  QLineEdit *filename;
  enum{appendB,singularitiesB,datapointsB,streamlinesB,overlaysB};
  
};

#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
