/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#include "pffiledlg.hpp" 
#include <qfiledlg.h>
#include <qlined.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qchkbox.h> 
#include <qmsgbox.h>
#include <qapp.h>
#include <qstring.h>
#include <qbttngrp.h> 
#include <qlayout.h>
#include <qdir.h>

PFFileDlg::PFFileDlg( QString l_FileName, 
		      QWidget *parent, 
		      const char *name, 
		      bool modal,bool open ) : QDialog( parent, name, modal ){
  d_Flags=QBitArray(6);
  if(open) openInit(l_FileName);
  else saveInit();
}

PFFileDlg::~PFFileDlg(){};

QBitArray PFFileDlg::getOpenFileFlags(QString l_FileName, 
				      QWidget *parent, 
				      const char *name){ 
  PFFileDlg *dlg = new PFFileDlg( l_FileName, parent, name, TRUE,TRUE );
  CHECK_PTR( dlg );
  dlg->setCaption( "Open" );
  QBitArray result(8);
  if ( dlg->exec() == QDialog::Accepted ) {
    return (result);
      }
  else{
    delete dlg;
    return( result);
  };
};

QString PFFileDlg::fileName(){
  return filename->text();
};

QString PFFileDlg::getSaveFileName(QWidget *parent, const char *name){ 
    PFFileDlg *dlg = new PFFileDlg(QString(""), parent, name, TRUE,FALSE );
    CHECK_PTR( dlg );
    dlg->setCaption( "Save As" );
    QString result;
    if ( dlg->exec() == QDialog::Accepted ) {
      result=dlg->fileName();
      return (result);
    }
    else{
      delete dlg;
      result="";
      return(result);
    }
};

void PFFileDlg::openInit(QString l_FileName){
  struct OpenOptions {
    char        *name;
  };
  
  OpenOptions openOptions[] = {
    { "Append to current" },
    { "Singularities" },
    { "Data Points" },
    { "Streamlines" },
    { "Overlays" },
    { 0 } };

  d_Flags.clearBit(0);
  d_Flags.setBit(1);
  d_Flags.setBit(2);
  d_Flags.setBit(3);
  d_Flags.setBit(4);



  //overal size of dialog box
  QFontMetrics fm = fontMetrics();
  QWidget *desk = QApplication::desktop();
  int w = QMIN(fm.width("x")*50, desk->width()-50);
  int h = QMIN(fm.height()*12, desk->height()-50);
  setFixedHeight(h);
  resize(w,h);
  setMinimumWidth(w);

  //Set up filename lineedit, and browse button

  filename=new QLineEdit(this);
  filename->setFixedHeight(filename->sizeHint().height());
  filename->setText(l_FileName);

  //initialize the read option checkboxes    
  d_Options=new QButtonGroup("Read:",this,"Readbox");

  int maxwidth = 80;
  int i;
  char *n;
  for ( i=0; (n=openOptions[i].name) != 0; i++ ) {
    int w = fm.width( n );
    maxwidth = QMAX(w,maxwidth);
  }

  maxwidth = maxwidth + 20;                   // add 20 pixels
  
  for ( i=0; (n=openOptions[i].name) != 0; i++ ) {
    QCheckBox *rb = new QCheckBox( n, d_Options);
    rb->setGeometry( 10, i*30+20, maxwidth, 30 );
    if ( i != 0 )
            rb->setChecked( TRUE );
  }
  d_Options->setFixedHeight(i*30+20+5);

  connect(d_Options,SIGNAL(pressed(int)),this,SLOT( setFlag(int)));



  //OK and Cancel Buttons
  okB = new QPushButton( "OK", this, "okButton");
  okB->resize( width()/6, height()/12 );
  okB->setMinimumSize(okB->sizeHint());
  okB->setFixedHeight(okB->sizeHint().height());
  connect( okB,	SIGNAL(clicked()), SLOT(accept()) );

  cancelB = new QPushButton( "Cancel" , this, "cancelButton" );
  cancelB->resize( width()/6, height()/12 );
  cancelB->setMinimumSize(cancelB->sizeHint());
  cancelB->setFixedHeight(cancelB->sizeHint().height());
  connect(cancelB,SIGNAL(clicked()), SLOT(reject()) );



  //set up layout managers
  QGridLayout *g=new QGridLayout(this,3,1,0);
  QBoxLayout *g0=new QHBoxLayout();
  QBoxLayout *g2=new QHBoxLayout();

  g->setRowStretch(0,0);
  g->setRowStretch(1,1);
  g->setRowStretch(2,0);

  g->addLayout(g0,0,0);
  g->addLayout(g2,2,0);

  g->addWidget(d_Options,1,0);
  g0->addWidget(filename);
  //  g0->addWidget(browseB);
  g2->addWidget(okB);
  g2->addWidget(cancelB);

  g->activate();
}


void PFFileDlg::saveInit(){
  struct OpenOptions {
    char        *name;
  };
  
  OpenOptions openOptions[] = {
    //    { "TA Mode" },
    { "Singularities" },
    { "Data Points" },
    { "Streamlines" },
    { "Overlays" },
    { 0 } };


  //overal size of dialog box
  QFontMetrics fm = fontMetrics();
  QWidget *desk = QApplication::desktop();
  int w = QMIN(fm.width("x")*50, desk->width()-50);
  int h = QMIN(fm.height()*12, desk->height()-50);
  setFixedHeight(h);
  resize(w,h);
  setMinimumWidth(w);

  //Set up filename lineedit, and browse button

  filename=new QLineEdit(this);
  filename->setFixedHeight(filename->sizeHint().height());
  filename->setText(QDir::currentDirPath().data());

  d_Options=new QButtonGroup("Save:",this,"savebox");

  int maxwidth = 80;
  int i;
  char *n;
  for ( i=0; (n=openOptions[i].name) != 0; i++ ) {
    int w = fm.width( n );
    maxwidth = QMAX(w,maxwidth);
  }
  maxwidth = maxwidth + 20;                   // add 20 pixels
  
  for ( i=0; (n=openOptions[i].name) != 0; i++ ) {
    QCheckBox *rb = new QCheckBox( n, d_Options );
    rb->setGeometry( 10, i*30+20, maxwidth, 30 );
    if ( i != 0 )
            rb->setChecked( TRUE );
  }
  d_Options->setFixedHeight(i*30+20+5);

  //OK and Cancel Buttons
  okB = new QPushButton( "OK", this, "okButton");
  okB->resize( width()/6, height()/12 );
  okB->setMinimumSize(okB->sizeHint());
  okB->setFixedHeight(okB->sizeHint().height());
  connect( okB,	SIGNAL(clicked()), SLOT(accept()) );

  cancelB = new QPushButton( "Cancel" , this, "cancelButton" );
  cancelB->resize( width()/6, height()/12 );
  cancelB->setMinimumSize(cancelB->sizeHint());
  cancelB->setFixedHeight(cancelB->sizeHint().height());
  connect(cancelB,SIGNAL(clicked()), SLOT(reject()) );

  connect(d_Options,SIGNAL(pressed(int)),this,SLOT( setFlag(int)));



  //set up layout managers
  QGridLayout *g=new QGridLayout(this,3,1,0);
  QBoxLayout *g0=new QHBoxLayout();
  QBoxLayout *g2=new QHBoxLayout();

  g->setRowStretch(0,0);
  g->setRowStretch(1,1);
  g->setRowStretch(2,0);

  g->addLayout(g0,0,0);
  g->addLayout(g2,2,0);

  g->addWidget(d_Options,1,0);
  g0->addWidget(filename);
  //  g0->addWidget(browseB);
  g2->addWidget(okB);
  g2->addWidget(cancelB);

  g->activate();
}


void PFFileDlg::setFlag(int id){
  debug("Button ID %d",id);
  if(((QCheckBox*)d_Options->find(id))->isChecked()){
    d_Flags.clearBit(id);
    debug("cleared");
  }else{
    d_Flags.setBit(id);
    debug("checked");
  };
}

//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
