/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY

#ifndef PFDATAGRAPH_H
#define PFDATAGRAPH_H 1
//Qt Includes
#include <qframe.h>
#include <qmenubar.h>
#include "Qwtlib-0.2/include/qwt_plot.h"
//Custom Includes

#include "pfdatapointlist.hpp"

class DataGraph : public QFrame
{
    Q_OBJECT
public:
  DataGraph(DataPointList *Dp, QWidget *parent=0, const char *name=0);

protected:

public slots:
  void update();
  void toggleUx();
  void toggleUy();
  void toggleSpeed();
  void togglePress();
  void print();
signals:

private:
  DataPointList *d_DataPoints;
  QwtPlot *d_Plot; 
  enum{UXBUTTON,UYBUTTON,SPEEDBUTTON,PRESSBUTTON};

  QPopupMenu *d_options;
  
  bool d_ShowUXFlag;
  bool d_ShowUYFlag;
  bool d_ShowSpeedFlag;
  bool d_ShowPressureFlag;

  long UXKey;
  long UYKey;
  long SpeedKey;
  long PressKey;

};
#endif // DATAGRAPH_H
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
