/* colorpicker.cpp

Copyright (c) 1997  R. Michael Sharkey (msharkey@softarc.com)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL R. MICHAEL SHARKEY BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/
//STARTPRETTY

#include "pfcolorpicker.h"

#define	ColorButtonPosH		4
#define	ColorButtonPosV		4
#define	ColorButtonSpaceH	4
#define	ColorButtonSpaceV	4
#define	ColorButtonWidth	16
#define	ColorButtonHeight	16

QColorPicker::QColorPicker(QWidget *parent,const char *name) :
  QDialog(parent,name,TRUE)
{
  lastButtonPressed=0;
  colorIsValid=FALSE;
  setCaption("Color Picker");
  initializePalette();
  colorButtons = new QButtonGroup("Basic Colors",this,"basicColors");
  if(colorButtons!=NULL) {

    // color buttons...
    register int row,col;
    int	index;
    QColorGroup	stdActiveColorGroup = QApplication::palette()->active();
    QColor light = stdActiveColorGroup.light();
    QColor dark = stdActiveColorGroup.dark();
    QColor mid = stdActiveColorGroup.mid();
    int	colorGroupBorderOffsetH = colorButtons->fontMetrics().maxWidth();
    int	colorGroupBorderOffsetV = colorButtons->fontMetrics().height();
    colorButtons->setExclusive(TRUE);
    colorButtons->resize(
			 ((ColorButtonWidth+ColorButtonSpaceH)
			  *ColorPaletteWidth)+colorGroupBorderOffsetH,
			 (ColorButtonHeight+ColorButtonSpaceV)
			 *ColorPaletteHeight+colorGroupBorderOffsetV
			 );
    colorButtons->move(ColorButtonPosH,ColorButtonPosV);
    for(index=row=0;row<ColorPaletteHeight;row++) {
      for(col=0;col<ColorPaletteWidth;col++,index++) {
	QPushButton *button = new QPushButton(this,"ColorButton");
	QColor color = colorPalette[col][row];
	button->setToggleButton(TRUE);
	button->setPalette(QPalette(QColorGroup(color, color,
						light, dark,
						color, color,
						color),	// normal
				    QColorGroup(color, color,
						color, color,
						color, color,
						color),	// disabled
				    QColorGroup(color, color,
						light, dark,
						mid, color,
						color))	// active
			   );
	button->resize(ColorButtonWidth,ColorButtonHeight);
	button->move(ColorButtonPosH+colorGroupBorderOffsetH
		     +(col*(ColorButtonWidth+ColorButtonSpaceH)),
		     ColorButtonPosV+colorGroupBorderOffsetV
		     +(row*(ColorButtonHeight+ColorButtonSpaceV))
		     );
	button->show();
	colorButtons->insert(button,index);
      }
    }
    colorButtons->connect(colorButtons,SIGNAL(clicked(int)),
			  this,SLOT(buttonClicked(int)));

    // sample area....
    sampleRect = new QRect(
			   colorButtons->x()+colorButtons->width()
			   +(ColorButtonSpaceH * 2),
			   colorButtons->y()+colorGroupBorderOffsetV,
			   colorButtons->width()
			   -colorGroupBorderOffsetH,
			   colorButtons->height()/4
			   );

    // setup rgb sliders
    sliderRect = new QRect (
			    sampleRect->x(),
			    sampleRect->y()+sampleRect->height()+2,
			    sampleRect->width(),
			    sampleRect->height()
			    );

    redSlider = new QScrollBar(0,255,1,8,255, 
			       QScrollBar::Horizontal,
			       this,(char *)"redSlider");
    connect(redSlider,SIGNAL(sliderMoved(int)),SLOT(rgbSliderMoved(int)));
    connect(redSlider,SIGNAL(nextPage()),SLOT(rgbSliderPaged()));
    connect(redSlider,SIGNAL(prevPage()),SLOT(rgbSliderPaged()));
    connect(redSlider,SIGNAL(nextLine()),SLOT(rgbSliderPaged()));
    connect(redSlider,SIGNAL(prevLine()),SLOT(rgbSliderPaged()));
    redSlider->resize(sliderRect->width(),sliderRect->height()/3);
    redSlider->move(sliderRect->x(),sliderRect->y());
    redSlider->setBackgroundColor(QColor(255,0,0));
    redSlider->show();

    greenSlider = new QScrollBar(0,255,1,8,255, 
				 QScrollBar::Horizontal,
				 this,(char *)"greenSlider");
    connect(greenSlider,SIGNAL(sliderMoved(int)),SLOT(rgbSliderMoved(int)));
    connect(greenSlider,SIGNAL(nextPage()),SLOT(rgbSliderPaged()));
    connect(greenSlider,SIGNAL(prevPage()),SLOT(rgbSliderPaged()));
    connect(greenSlider,SIGNAL(nextLine()),SLOT(rgbSliderPaged()));
    connect(greenSlider,SIGNAL(prevLine()),SLOT(rgbSliderPaged()));
    greenSlider->resize(sliderRect->width(),sliderRect->height()/3);
    greenSlider->move(sliderRect->x(),redSlider->y()+redSlider->height());
    greenSlider->setBackgroundColor(QColor(0,255,0));
    greenSlider->show();

    blueSlider = new QScrollBar(0,255,1,8,255,
				QScrollBar::Horizontal,
				this,(char *)"blueSlider");
    connect(blueSlider,SIGNAL(sliderMoved(int)),SLOT(rgbSliderMoved(int)));
    connect(blueSlider,SIGNAL(nextPage()),SLOT(rgbSliderPaged()));
    connect(blueSlider,SIGNAL(prevPage()),SLOT(rgbSliderPaged()));
    connect(blueSlider,SIGNAL(nextLine()),SLOT(rgbSliderPaged()));
    connect(blueSlider,SIGNAL(prevLine()),SLOT(rgbSliderPaged()));
    blueSlider->resize(sliderRect->width(),sliderRect->height()/3);
    blueSlider->move(sliderRect->x(),greenSlider->y()+greenSlider->height());
    blueSlider->setBackgroundColor(QColor(0,0,255));
    blueSlider->show();

    // setup the control buttons...
    okButton = new QPushButton("OK",this);
    okButton->setDefault(TRUE);
    connect(okButton,SIGNAL(clicked()),SLOT(accept()));
    okButton->resize(sliderRect->width()/3,sliderRect->height()/2);
    okButton->move(sliderRect->x(),
		   (colorButtons->y()+colorButtons->height())
		   -(okButton->height()*2));
    okButton->show();

    cancelButton = new QPushButton("Cancel",this);
    connect(cancelButton,SIGNAL(clicked()),SLOT(reject()));
    cancelButton->resize(okButton->width(),okButton->height());
    cancelButton->move(okButton->x()+(okButton->width()*2),okButton->y());
    cancelButton->show();

    // size the dialog widget
    resize(cancelButton->x()+cancelButton->width()+ColorButtonSpaceH,
	   colorButtons->y()+colorButtons->height()+ColorButtonSpaceV);
    setMinimumSize(width(),height());
    setMaximumSize(width(),height());
    show();
  }

}

QColorPicker::~QColorPicker(void)
{
  QPushButton	*button;
  register int	index;
  for(index=0;index<ColorPaletteWidth*ColorPaletteHeight;index++) {
    button=(QPushButton *)colorButtons->find(index);
    if(button!=NULL) {
      colorButtons->remove(button);
      delete button;
    }
  }
  delete colorButtons;
  delete redSlider;
  delete greenSlider;
  delete blueSlider;
  delete sampleRect;
  delete sliderRect;
  delete okButton;
  delete cancelButton;
}

void QColorPicker::buttonClicked(int index)
{
  int	row = (index/ColorPaletteWidth);
  int	col = index-(row*ColorPaletteWidth);
  lastButtonPressed=index;
  colorSelected = colorPalette[col][row];
  redSlider->setValue(colorSelected.red());
  greenSlider->setValue(colorSelected.green());
  blueSlider->setValue(colorSelected.blue());
  colorIsValid=TRUE;
  repaint(*sampleRect,FALSE);
}

void QColorPicker::rgbSliderMoved(int /*value*/) // value is not directly interpreted
{
  int	red=	redSlider->value();
  int	green=	greenSlider->value();
  int	blue=	blueSlider->value();
  QPushButton	*button=(QPushButton *)colorButtons->find(lastButtonPressed);
  if(button!=NULL) button->setOn(FALSE);
  colorSelected = QColor(red,green,blue);
  colorIsValid=TRUE;
  repaint(*sampleRect,FALSE);
}

void QColorPicker::rgbSliderPaged()
{
  rgbSliderMoved(0);
}

void QColorPicker::paintEvent(QPaintEvent *)
{
  QPainter	paint;
  paint.begin(this);
  if(colorIsValid) {
    paint.setBrush(colorSelected);
  }
  else {
    paint.setBrush(QColor(255,255,255));
  }
  paint.fillRect(*sampleRect,paint.brush());
  paint.end();
}

void QColorPicker::initializePalette(void)
{
  unsigned char	red=0;
  unsigned char	green=0;
  unsigned char	blue=0;
  register int	row,col;
  for(row=0;row<ColorPaletteHeight;row++) {
    for(col=0;col<ColorPaletteWidth;col++) {
      colorPalette[col][row]=QColor(red,green,blue);
      red+=8;
      green+=16;
      blue+=35;
    }
  }
}
//ENDPRETTY

