/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFBASEFORM_H
#define PFBASEFORM_H 1

#include "pfstatus.hpp" 
#include "pfsingtable.hpp"
#include "pfdatatable.hpp"
#include "pfdisplay.hpp"
#include "pfdatagraph.hpp"
#include "pfaboutbox.hpp"

class QWidget;
class QPushButton;
class QButtonGroup;
class QMenuBar;

class BaseForm: public QWidget
{
Q_OBJECT
public:
  BaseForm(QWidget *parent=0, const char *name=0);

public slots:
  void refresh(); //force a repaint
  void reCalc();  //recalculate, then repaint

  void setState(int Signal); //Set the repsonse to a left click
  void doLeftClick(double X, double Y);
  void doRightClick(double X, double Y);

  void showAbout();

  void clearAll();
  void clearSingularities();
  void clearStreamlines();
  void clearDataPoints();

  void openFile();
  void saveFile();
  void saveFileAs();
  void print();

  //These functions toggle the display properties
  void toggleGrid();
  void toggleSingularities();
  void toggleStreamlines();
  void toggleDataPoints();
  void toggleSnap();
  void toggleSingTable();
  void toggleDataTable();
  void toggleDataGraph();

  void setFluidColor();
  void setGridColor();
  void setStreamlineColor();
  void setSingularityColor();
  void setDataPointColor();



private:
  
  bool getColor(QColor *a);

  PFStatus *d_PFStatus;
  PFDisplay *d_Fluid;
  SingTable *d_Table;
  DataTable *d_DataTable;
  DataGraph *d_DataGraph;
  CalcEngine *d_Engine; 
  SingList *d_SingularityList;
  StreamList *d_Streamlines;
  DataPointList *d_DataPoints;

  //This function just makes a special button, it is just here to clean
  //up the constructor
  QPushButton *addButton(char *name, 
			 QButtonGroup *grp, 
			 const char *pix, 
			 int x, int y, int w, int h,
			 char * tip);

  int d_LeftClickResponse;
  int d_RightClickResponse;

  QPopupMenu *d_display;
  QPopupMenu *d_options;

  QButtonGroup *d_AddGrp;
  QButtonGroup *d_ClrGrp;  

  enum{ADDSOURCE, ADDSINK, ADDRVORTEX, ADDLVORTEX,
	 ADDDIPOLE, ADDSTREAMLINE, ADDDATAPOINT};
  enum{GRIDBUTTON, SINGBUTTON, STREAMBUTTON, 
	 DATABUTTON, SNAPBUTTON, PRESSUREBUTTON, 
	 SINGTABLEBUTTON, DATATABLEBUTTON, 
	 DATAGRAPHBUTTON};

};
#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
