#include "qwt_plot.h"
#include "qwt_plot_pixframe.h"
#include "qwt_math.h"
#include <qrect.h>

//------------------------------------------------------------
//
//.F	QwtPlotPixFrame::mousePressEvent
//
//
//.u	Parameters
//.p	QMouseEvent *e
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotPixFrame::mousePressEvent(QMouseEvent *e)
//
//------------------------------------------------------------
void QwtPlotPixFrame::mousePressEvent(QMouseEvent *e)
{
    const QRect &r = contentsRect();
    QMouseEvent m(Event_MouseButtonDblClick, e->pos() - r.topLeft(),
                  e->button(), e->state());

    QPainter p;
    
    p.begin(this);
    
    //
    // Delete active outlines
    //
    if (d_outlineActive)
	drawOutline(p);

    d_outlineActive = FALSE;
    
    //
    // store this point as entry point
    //
    d_lastPoint = e->pos();
    d_entryPoint = e->pos();

    //
    // draw new outline
    //
    if (d_outlineEnabled)
    {
	drawOutline(p);
	d_outlineActive = TRUE;
	
    }
    
    p.end();
    
    d_mousePressed = TRUE;

    parentPlot()->plotPressed(&m);
    
}

//------------------------------------------------------------
//
//.F	QwtPlotPixFrame::mouseReleaseEvent
//
//
//.u	Parameters
//.p	QMouseEvent *e
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotPixFrame::mouseReleaseEvent(QMouseEvent *e)
//
//------------------------------------------------------------
void QwtPlotPixFrame::mouseReleaseEvent(QMouseEvent *e)
{
    const QRect &r = contentsRect();
    QMouseEvent m(Event_MouseButtonDblClick, e->pos() - r.topLeft(),
                  e->button(), e->state());

    QPainter p;
    
    if (d_outlineActive)
    {
	p.begin(this);
	drawOutline(p);
	p.end();
    }
    
    d_outlineActive = FALSE;
    d_mousePressed = FALSE;

    parentPlot()->plotReleased(&m);
    
}

//------------------------------------------------------------
//
//.F	QwtPlotPixFrame::mouseMoveEvent
//
//
//.u	Parameters
//.p	QMouseEvent *e
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotPixFrame::mouseMoveEvent(QMouseEvent *e)
//
//------------------------------------------------------------
void QwtPlotPixFrame::mouseMoveEvent(QMouseEvent *e)
{
    const QRect &r = contentsRect();
    QMouseEvent m(Event_MouseButtonDblClick, e->pos() - r.topLeft(),
                  e->button(), e->state());
    QPainter p;

    if (d_outlineActive)
    {
	p.begin(this);
	drawOutline(p);
	d_lastPoint = e->pos();
	drawOutline(p);
	p.end();
    }
    parentPlot()->plotMoved(&m);
    
}

//------------------------------------------------------------
//
//.F	QwtPlotPixFrame::paintEvent
//
//
//.u	Parameters
//.p	QPaintEvent *e
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotPixFrame::paintEvent(QPaintEvent *e)
//
//------------------------------------------------------------
void QwtPlotPixFrame::paintEvent(QPaintEvent *e)
{
    QRect r = contentsRect();
    QRect ri;
    QPainter p;

    p.begin(this);

    // if necessary, redraw frame
    if (!r.contains(e->rect(), TRUE))
       drawFrame(&p);
    
    // redraw pixmap portion
    if (r.intersects(e->rect()))
    {
	ri = r.intersect(e->rect());

	//
	// erase active outline
	//
	p.save();
	
	if (d_outlineActive)
	   drawOutline(p);

	p.restore();
	
	//
	// repaint pixmap portion
	//
	p.drawPixmap(ri.x(), ri.y(), d_pix,
		     ri.x() - r.x(), ri.y() - r.y(),
		     qwtMin(ri.width(), d_pix.width()),
		     qwtMin(ri.height(), d_pix.height()));

	//
	// redraw outline
	//
	if (d_outlineActive)
	   drawOutline(p);

    }

    p.end();
    
}


//------------------------------------------------------------
//
//.S	QwtPlotPixFrame::enableOutline
//
//
//.s	Parameters
//.p	bool tf
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtPlotPixFrame::enableOutline(bool tf)
//
//------------------------------------------------------------
void QwtPlotPixFrame::enableOutline(bool tf)
{

    QPainter p;
    p.begin(this);

    //
    //	If the mouse is pressed, erase existing outline
    //  or draw new outline if 'tf' changes the 'enabled' state.
    //
    if ((tf != d_outlineEnabled) && d_mousePressed)
    {
	drawOutline(p);
	d_outlineActive = tf;
    }
    d_outlineEnabled = tf;

    p.end();

}


//------------------------------------------------------------
//
//.S	QwtPlotPixFrame::setOutlineStyle
//
//
//.s	Parameters
//.p	int os
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtPlotPixFrame::setOutlineStyle(int os)
//
//------------------------------------------------------------
void QwtPlotPixFrame::setOutlineStyle(Qwt::Shape os)
{

    QPainter p;
    
    p.begin(this);
    
    //
    // erase old outline
    //
    if (d_outlineActive)
	drawOutline(p);

    d_outline = os;

    //
    // draw new outline 
    //
    if (d_outlineActive)
	drawOutline(p);

    p.end();
    
}

//------------------------------------------------------------
//
//.S	QwtPlotPixFrame::setOutlinePen
//
//
//.s	Parameters
//.p	const QPen &c
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtPlotPixFrame::setOutlinePen(const QPen &c)
//
//------------------------------------------------------------
void QwtPlotPixFrame::setOutlinePen(const QPen &c)
{
    d_pen = c;
}

//------------------------------------------------------------
//
//.S	QwtPlotPixFrame::drawOutline
//
//
//.s	Parameters
//.p	
//
//.s	Return Type
//		void
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	void QwtPlotPixFrame::drawOutline()
//
//------------------------------------------------------------
void QwtPlotPixFrame::drawOutline(QPainter &p)
{

    
    const QRect &r = this->contentsRect();
    QPen pn = d_pen;
    
    pn.setColor(QColor(0, (pixmapBackground().pixel() ^ d_pen.color().pixel())));
    
    p.setPen(pn);
    p.setRasterOp(XorROP);
    p.setClipRect(this->contentsRect());
    p.setClipping(TRUE);

    switch(d_outline)
    {
    case Qwt::VLine:

	p.drawLine(d_lastPoint.x(), r.top(), d_lastPoint.x(), r.bottom());
	break;
	
    case Qwt::HLine:

	p.drawLine(r.left(), d_lastPoint.y(), r.right(), d_lastPoint.y());
	break;
	
    case Qwt::Cross:

	p.drawLine(r.left(), d_lastPoint.y(), r.right(), d_lastPoint.y());
	p.drawLine(d_lastPoint.x(), r.top(), d_lastPoint.x(), r.bottom());
	break;

    case Qwt::Rect:
	
	p.drawRect(d_entryPoint.x(), d_entryPoint.y(),
		   d_lastPoint.x() - d_entryPoint.x() + 1,
		   d_lastPoint.y() - d_entryPoint.y() + 1);
	break;
	
    case Qwt::Ellipse:

	p.drawEllipse(d_entryPoint.x(), d_entryPoint.y(),
		   d_lastPoint.x() - d_entryPoint.x() + 1,
		   d_lastPoint.y() - d_entryPoint.y() + 1);
	break;
    default:
	break;
    }
}


