#include "qwt_plot.h"
#include "qwt_math.h"

//------------------------------------------------------------
//.C      Accessing and Manipulating the Coordinate Grid
//------------------------------------------------------------

//------------------------------------------------------------
//
//.F	QwtPlot::enableGridX
//	Enable or disable vertical gridlines.
//
//.u	Syntax
//.f	void QwtPlot::enableGridX(bool tf = TRUE)
//
//
//.u	Parameters
//.p	bool tf		-- Enable (TRUE) or disable (FALSE).
//			   Defaults to TRUE. 
//
//------------------------------------------------------------
void QwtPlot::enableGridX(bool tf)
{
    d_grid.enableX(tf);
}

//------------------------------------------------------------
//
//.F	QwtPlot::enableGridY
//	Enable or disable horizontal gridlines
//
//.u	Syntax
//.f	void QwtPlot::enableGridY(bool tf)
//
//.u	Parameters
//.p	bool tf		--  enable (TRUE) or disable (FALSE).
//			    Defaults to TRUE.
//------------------------------------------------------------
void QwtPlot::enableGridY(bool tf)
{
    d_grid.enableY(tf);
}

//------------------------------------------------------------
//
//.F	QwtPlot::enableGridXMin
//	Enable or disable vertical gridlines for the minor
//	scale marks
//
//.u	Syntax
//.f	void QwtPlot::enableGridXMin(bool tf)
//
//
//.u	Parameters
//.p	bool tf		--  enable (TRUE) or disable (FALSE).
//			    Defaults to TRUE.
//------------------------------------------------------------
void QwtPlot::enableGridXMin(bool tf)
{
    d_grid.enableXMin(tf);
}

//------------------------------------------------------------
//
//.F	QwtPlot::enableGridYMin
//	Enable or disable horizontal gridlines for
//	the minor scale marks.
//
//.u	Syntax
//.f	void QwtPlot::enableGridYMin(bool tf)
//
//
//.u	Parameters
//.p	bool tf		--  enable (TRUE) or disable (FALSE).
//			    Defaults to TRUE.
//------------------------------------------------------------
void QwtPlot::enableGridYMin(bool tf)
{
    d_grid.enableYMin(tf);
}


//------------------------------------------------------------
//
//.F	QwtPlot::setGridXAxis
//	Attach the grid to an x axis
//
//.u	Syntax
//.f	void QwtPlot::setGridXAxis(int axis)
//
//
//.u	Parameters
//.p	int axis	-- x axis to be attached
//
//
//------------------------------------------------------------
void QwtPlot::setGridXAxis(int axis)
{
    if ((axis==xBottom)||(axis==xTop))
    {
	d_grid.setXAxis(axis);
	d_grid.setXDiv(d_sdiv[axis]);
    }
}

//------------------------------------------------------------
//
//.F	QwtPlot::setGridYAxis
//	Attach the grid to an y axis
//
//.u	Syntax
//.f	void QwtPlot::setGridYAxis(int axis)
//
//.u	Parameters
//.p	int axis	-- x axis to be attached
//
//------------------------------------------------------------
void QwtPlot::setGridYAxis(int axis)
{
    if ((axis==yLeft) || (axis == yRight))
    {
	d_grid.setYAxis(axis);
	d_grid.setYDiv(d_sdiv[axis]);
    }
}

//------------------------------------------------------------
//
//.F	QwtPlot::setGridPen
//	Change the grid's pens for major and minor gridlines
//
//.u    Syntax
//.f	void QwtPlot::setGridPen(const QPen &p)
//
//.u	Parameters
//.p	const QPen &p	--	new pen
//
//------------------------------------------------------------
void QwtPlot::setGridPen(const QPen &p)
{
    d_grid.setPen(p);
}

//------------------------------------------------------------
//
//.F	QwtPlot::setGridMinPen
//	Change the pen for the minor gridlines
//
//.u	Syntax
//.f	void QwtPlot::setGridMinPen(const QPen &p)
//
//.u	Parameters
//.p	const QPen &p	--	new pen
//
//------------------------------------------------------------
void QwtPlot::setGridMinPen(const QPen &p)
{
    d_grid.setMinPen(p);
}

//------------------------------------------------------------
//
//.F	QwtPlot::setGridMajPen
//	Change the pen for the major gridlines
//
//.u	Syntax
//.f	void QwtPlot::setGridMajPen(const QPen &p)
//
//.u Parameters
//.p	const QPen &p	--	new pen
//
//------------------------------------------------------------
void QwtPlot::setGridMajPen(const QPen &p)
{
    d_grid.setMajPen(p);
}












