#ifndef QWT_SYMBOL_H
#define QWT_SYMBOL_H

#include <qglobal.h>
#include <qwt.h>
#include <qbrush.h>
#include <qpen.h>
#include <qpoint.h>
#include <qsize.h>
#include <qpntarry.h>

class QPainter;

class QwtSymbol
{
public:

    enum Style { None, Ellipse, Rect, Diamond, Triangle, DTriangle,
	UTriangle, LTriangle, RTriangle, Cross, XCross, StyleCnt }; 
    
protected:

    QBrush d_brush;
    QPen d_pen;
    QSize d_size;
    QPointArray d_pa;
    Style d_style;
    
public:

    QwtSymbol();
    QwtSymbol(Style st, const QBrush &bd, const QPen &pn, const QSize &s);
    virtual ~QwtSymbol();
    
    void setSize(const QSize &s);
    void setSize(int a, int b = -1);
    void setBrush(const QBrush& b);
    void setPen(const QPen &p);
    void setStyle (Style s);

    const QBrush& brush() const { return d_brush; }
    const QPen& pen() const { return d_pen; }
    const QSize& size() const { return d_size; }
    Style style() const { return d_style; } 
    
    void draw(QPainter *p, const QPoint &pt); 
    void draw(QPainter *p, int x, int y);
    virtual void draw(QPainter *p, const QRect &r);
    
};



#endif
