#ifndef QWT_SLIDER_H
#define QWT_SLIDER_H

#include <qwt_sclif.h>
#include <qwt_sldbase.h>
#include <qwt_scldraw.h>
class QwtSlider : public QwtSliderBase, public QwtScaleIf
{

 public:
	enum Orientation{Vertical, Horizontal};
	enum ScalePos {	None, Left, Right, Top, Bottom };
	enum { BgTrough = 0x1, BgSlot = 0x2 };  
      
 private:

	QRect d_sliderRect;

	int d_thumbLength;
	int d_thumbHalf;
	int d_thumbWidth;
	int d_borderWidth;
	int d_bwTrough;
	int d_scaleDist;
	int d_xMargin;
	int d_yMargin;
	
	int d_resized;
	bool d_autoResize;
	double d_scaleStep;

	Orientation d_orient;
	ScalePos d_scalePos;
	int d_bgStyle;
	int markerPos;

	
 public:

	QwtSlider(QWidget *parent, const char *name = 0,
		  Orientation orient = Horizontal,
		  ScalePos scalePos = None,
		  int bgStyle = BgTrough);
	
	~QwtSlider();
	void setThumbLength(int l);
	void setThumbWidth(int w);
//	void setOrientation(Orientation o);
	void setBorderWidth(int bw);
       	void setMargins(int x, int y);
	QSize sizeHint() const;
	
protected:

	virtual void drawSlider (QPainter *p, const QRect &r);
	double getValue(const QPoint &p);
	void getScrollMode( const QPoint &p, int &scrollMode, int &direction);
	void resizeEvent(QResizeEvent *e);
	void paintEvent (QPaintEvent *e);
	void valueChange();
	void rangeChange();
	void scaleChange();
	void fontChange(const QFont &oldFont);

private:
	void drawHsBgSlot(QPainter *, const QRect&, const QRect&,const QBrush&);
	void drawVsBgSlot(QPainter *, const QRect&, const QRect&,const QBrush&);
	
};

#endif






