#ifndef QWT_SCALE_H
#define QWT_SCALE_H

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>

#include <qwt_sclif.h>
#include <qwt_autoscl.h>

class QwtScale : public QWidget
{
    QwtScaleDraw d_scale;
    QwtScaleDiv d_sdiv;
    
    int d_borderDist[2];
    int d_scaleLength;
    int d_baseDist;

    int d_titleOffset;
    QString d_title;
    int d_titleDist;
    QFont d_titleFont;
    QColor d_titleColor;

public:

    enum Orientation { Left, Right, Top, Bottom };

    QwtScale(QwtScale::Orientation, QWidget *parent, const char *name = 0);
    ~QwtScale();
    
    void setTitle(const char *title);
    void setBorderDist(int start, int end);
    void setScale(const QwtScaleDiv &sd);
    
    void setBaselineDist(int bd);
    void setTitleFont(const QFont &f);
    void setTitleColor(const QColor &c);
    void enableTitle(bool tf);

    const QFont &titleFont() const { return d_titleFont; }
    const QColor &titleColor() const { return d_titleColor; }
    const QString& title() const { return d_title; }
    int minBorderDist() const;
    
    QSize sizeHint() const;

protected:

    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent *e);
    void scaleChange();
    void fontChange(const QFont &oldfont);
    const QwtDiMap &map() const { return d_scale; }

private:
    void resizeScale();
				  
    
};

#endif




