#ifndef QWT_PLOT_PIXFRAME_H
#define QWT_PLOT_PIXFRAME_H

#include <qwt_pixframe.h>
#include <qwt_plot_item.h>

class QwtPlotPixFrame : public QwtPixFrame, public QwtPlotItem
{
private:

    bool d_outlineEnabled;
    bool d_outlineActive;
    bool d_mousePressed;
    Qwt::Shape d_outline;

    QPen d_pen;
    QPoint d_entryPoint;
    QPoint d_lastPoint;
   
public:
    QwtPlotPixFrame(QwtPlot *parent)
       : QwtPixFrame(parent), QwtPlotItem(parent), d_pen(red){}
    void setOutlinePen(const QPen &p);
    void setOutlineStyle(Qwt::Shape os);
    void enableOutline(bool tf);

    bool outlineEnabled() const { return d_outlineEnabled; }
    Qwt::Shape outlineStyle() const { return d_outline; }
    const QPen& outlinePen() const { return d_pen; }
    
private:    
    void drawOutline(QPainter &p);

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
};


#endif
