#ifndef QWT_PLOT_ITEM
#define QWT_PLOT_ITEM

#include <qglobal.h>
//
//	Base classes inherited by all items
//	included by QwtPlot
//

class QwtPlot;

class QwtPlotItem
{
private:
    bool d_enabled;
    QwtPlot *d_parent;

protected:
    QwtPlot *parentPlot() { return d_parent; }

public:
    
    QwtPlotItem(QwtPlot *parent, bool nbl = TRUE);

    virtual void itemChanged();
    
    virtual void setEnabled(bool tf) { d_enabled = tf; itemChanged(); }
    bool enabled() { return d_enabled; }
};
			

class QwtPlotMappedItem : public QwtPlotItem 
{
private:
    int d_xAxis;
    int d_yAxis;
    
public:

    QwtPlotMappedItem(QwtPlot *parent, bool nbl = TRUE)
       : QwtPlotItem(parent, nbl) {  }
    
    int xAxis() const { return d_xAxis; }
    int yAxis() const { return d_yAxis; }

    void setXAxis(int axis);
    void setYAxis(int axis);
};

#endif




