#ifndef QWT_PLOT_CLASSES_H
#define QWT_PLOT_CLASSES_H

#include <qwt_plot_item.h>

//
//  Special classes used by QwtPlot
//

class QwtPlotCurve: public QwtCurve, public QwtPlotMappedItem
{
public:
    QwtPlotCurve(QwtPlot* parent, const char *name = 0)
       : QwtCurve(name), QwtPlotMappedItem(parent) {}
    
    ~QwtPlotCurve() {}
    
protected:
    void curveChanged() { itemChanged(); }

};



class QwtPlotGrid: public QwtGrid, public QwtPlotMappedItem
{
public:

    QwtPlotGrid(QwtPlot *parent)
       : QwtPlotMappedItem(parent) {}
    
    ~QwtPlotGrid() {}

protected:

    void gridChanged() { itemChanged(); }
};


class QwtPlotMarker: public QwtMarker, public QwtPlotMappedItem 
{
private:
    
    double d_xValue;
    double d_yValue;
    
public:
    
    QwtPlotMarker(QwtPlot *parent)
       : QwtPlotMappedItem(parent) {}

    ~QwtPlotMarker() {}
    
    double xValue() const { return d_xValue; }
    double yValue() const { return d_yValue; }

    void setXValue(double val) { d_xValue = val; markerChanged(); }
    void setYValue(double val) { d_yValue = val; markerChanged(); }

protected:

    void markerChanged() { itemChanged(); }

};




#endif




