#ifndef QWT_MATH_H
#define QWT_MATH_H

#include <math.h>

#define LOG10_2 	0.30102999566398119802  /* log10(2) */
#define LOG10_3 	0.47712125471966243540  /* log10(3) */
#define LOG10_5 	0.69897000433601885749  /* log10(5) */
#define M_2PI 		6.28318530717958623200  /* 2 pi */

#define LOG_MIN 1.0e-100
#define LOG_MAX 1.0e100


double qwtCeil125(double x);
double qwtFloor125(double x);
double qwtGetMin (double *array, int size);
double qwtGetMax( double *array, int size);
void qwtTwistArray(double *array, int size);
int qwtChkMono(double *array, int size);
void qwtLinSpace(double *array, int size, double xmin, double xmax);
void qwtLogSpace(double *array, int size, double xmin, double xmax);


template <class T>
inline const T& qwtMax (const T& x, const T& y) 
{
    return ( x > y ? x : y );
}

template <class T>
inline const T& qwtMin ( const T& x, const T& y)
{
    return ( x < y ? x : y );
}

template <class T>
inline T qwtAbs (const T& x)
{
    return( x > T(0) ? x : -x );
}

template <class T>
inline int qwtSign(const T& x)
{
    if (x > T(0))
       return 1;
    else if (x < T(0))
       return (-1);
    else
       return 0;
}			 

template <class T>
inline T qwtSqr(const T&x)
{
    return x*x;
}

template <class T>
void qwtCopyArray(T *dest, T *src, int n) 
{
    int i;
    for (i=0; i<n;i++ )
       dest[i] = src[i];
}

template <class T>
void qwtShiftArray(T *arr, int size, int di)
{
    int i, delta;
    T* buffer = 0;
    
    delta = qwtAbs(di);

    if ((delta > 0) && (delta < size))
    {
	if ((buffer = new T[delta]))
	{
	    if (di < 0)			// shift left
	    {
		qwtCopyArray(buffer, arr, delta);
		qwtCopyArray(&arr[0], &arr[delta], size - delta);
		qwtCopyArray(&arr[size - delta], buffer, delta);
		
	    }
	    else			// shift right
	    {
		qwtCopyArray(buffer, &arr[size - delta], delta);
		for ( i = size-delta-1; i >= 0; i-- )
		   arr[i + delta] = arr[i];
		qwtCopyArray(arr, buffer, delta);
	    }
	}
    }
    
    if (buffer != 0) delete[] buffer;
}

template <class T>
void qwtSwap( T &x1, T& x2)
{
    T tmp;
    tmp = x1;
    x1 = x2;
    x2 = tmp;
}

inline int qwtInt(double x)
{
    return int(rint(x));
}

template <class T>
void qwtSort(const T& x1, const T& x2, T& xmin, T& xmax)
{
    T buffer;
    
    if (x2 < x1)
    {
	buffer = x1;
	xmin = x2;
	xmax = buffer;
    }
    else
    {
	xmin = x1;
	xmax = x2;
    }
}

template <class T>
void qwtSort(T& x1, T& x2)
{
    T buffer;
    
    if (x2 < x1)
    {
	buffer = x1;
	x1 = x2;
	x2 = buffer;
    }
}

template <class T>
T qwtLim(const T& x, const T& x1, const T& x2)
{
    T rv;
    T xmin, xmax;
    
    xmin = qwtMin(x1, x2);
    xmax = qwtMax(x1, x2);

    if ( x < xmin )
       rv = xmin;
    else if ( x > xmax )
       rv = xmax;
    else
       rv = x;

    return rv;
}


#endif




