#ifndef QWT_MARKER_H
#define QWT_MARKER_H

#include <qglobal.h>
#include <qwt_symbol.h>
#include <qwt_dimap.h>
#include <qpen.h>
#include <qfont.h>
#include <qrect.h>
#include <qstring.h>

class QwtMarker
{
public:

    enum LineStyle {NoLine, HLine, VLine, Cross};
    
private:
    
    QString d_label;
    QPen d_pen;
    QPen d_tPen;
    QFont d_font;
    QwtSymbol d_sym;
    QwtDiMap d_xMap;
    QwtDiMap d_yMap;
    int d_align;
    LineStyle d_style;
    
public:

    QwtMarker();
    virtual ~QwtMarker();
    const QwtMarker & operator=(const QwtMarker&);
    
    void setLineStyle(LineStyle st);
    void setSymbol(const QwtSymbol &s);
    void setLabel(const char *txt);
    void setLabelAlignment(int align);
    void setLabelPen(const QPen &p);
    void setLinePen(const QPen &p);
    void setFont(const QFont &f);
    
    void draw(QPainter *p, int x, int y, const QRect &r);

    LineStyle lineStyle() const { return d_style; }
    const QwtSymbol &symbol() const { return d_sym; }
    const QPen &labelPen() const { return d_tPen; }
    const QPen &linePen() const { return d_pen; }
    const QFont &font() const { return d_font; }
    int labelAlignment() const { return d_align; }
    const QString& label() const { return d_label; }

protected:
    virtual void markerChanged() {}
};


#endif


