#ifndef QWT_GRID_H
#define QWT_GRID_H

#include <qglobal.h>
#include <qpen.h>
#include <qwt_dimap.h>
#include <qwt_scldiv.h>
#include <qpainter.h>

class QwtGrid
{

protected:

    bool d_xEnabled;
    bool d_yEnabled;
    bool d_xMinEnabled;
    bool d_yMinEnabled;

    QwtScaleDiv d_sdx;
    QwtScaleDiv d_sdy;

    QPen d_majPen;
    QPen d_minPen;

public:

    QwtGrid();
    virtual ~QwtGrid();
    const QwtGrid &operator=(const QwtGrid &g);

    void draw(QPainter *p, const QRect &r, const QwtDiMap &mx, const QwtDiMap &my);

    void enableX(bool tf);
    void enableY(bool tf);
    void enableXMin(bool tf);
    void enableYMin(bool tf);
    
    void setXDiv(const QwtScaleDiv &sx);
    void setYDiv(const QwtScaleDiv &sy);
    
    void setPen(const QPen &p);
    void setMajPen(const QPen &p);
    void setMinPen(const QPen &p);

    const QPen& majPen() const { return d_majPen; }
    const QPen& minPen() const { return d_minPen; }
    
    bool xEnabled() const{ return d_xEnabled; }
    bool xMinEnabled() const { return d_xMinEnabled; }
    bool yEnabled() const { return d_yEnabled; }
    bool yMinEnabled() const {return d_yMinEnabled; }

    const QwtScaleDiv &xScaleDiv() const { return d_sdx; }
    const QwtScaleDiv &yScaleDiv() const { return d_sdy; }

protected:
    virtual void gridChanged() {}
    
};



#endif
