#ifndef QWT_DBLRANGE_H
#define QWT_DBLRANGE_H

#include <qglobal.h>

class QwtDblRange
{
    
private:

    static const double MinRelStep;
    static const double DefaultRelStep;
    static const double MinEps;
    
    double d_minValue;
    double d_maxValue;
    double d_step;
    int d_pageSize;
    double d_value;
    double d_exactValue;
    double d_exactPrevValue;
    double d_prevValue;
    bool d_periodic;

    void setNewValue(double x,int align = 0);
    
public:
    
    QwtDblRange();
    
    virtual void fitValue(double);
    virtual void incValue(int);
    virtual void incPages(int);
    void setPeriodic(bool tf);
    void setRange(double vmin, double vmax, double vstep = 0.0,
		  int pagesize = 1);
    void setStep(double);
    virtual void setValue(double);
    
    double maxValue() const { return d_maxValue; }
    double minValue() const { return d_minValue; }
    bool periodic() const { return d_periodic; }
    double step() const;
    int pageSize() const { return d_pageSize; }
    double value() const { return d_value; }
    
protected:
    
    double exactValue() const { return d_exactValue; }
    double exactPrevValue() const { return d_exactPrevValue; }
    double prevValue() const { return d_prevValue; }
    virtual void valueChange();
    virtual void stepChange();
    virtual void rangeChange();
    
};



#endif




