#ifndef QWT_COUNTER_H
#define QWT_COUNTER_H

#include <qwidget.h>
#include <qwt_drange.h>

class QwtArrowButton;
class QLabel;

class QwtCounter : public QWidget, public QwtDblRange
{

    Q_OBJECT

public:

    enum Button { Button1, Button2, Button3, ButtonCnt }; 
 
private:

    int tmrID;
    int d_tmrIntv;
    int d_tick;
    int d_editable;

    QwtArrowButton *btnL[ButtonCnt];
    QwtArrowButton *btnR[ButtonCnt];
    QLabel *lblValue;

    int d_incValue;
    int d_Inc[ButtonCnt];
    int d_nButtons;
	
    void valueChange();
	
	
public:

    QwtCounter(QWidget *parent = 0, char *name = 0);
    ~QwtCounter();
	
    void setNumButtons(int n);
    void setIncSteps(QwtCounter::Button btn, int nSteps);

    int incSteps(QwtCounter::Button btn) const;
    int numButtons() const { return d_nButtons; } 

    void setEnabled(bool tf);
    QSize sizeHint() const;

protected:

    void fontChange(const QFont &f);
    void resizeEvent(QResizeEvent *e);
    void timerEvent(QTimerEvent *e);

private slots:

    void btnL1Dn();
    void btnL2Dn();
    void btnL3Dn();
    void btnR1Dn();
    void btnR2Dn();
    void btnR3Dn();
    void btnUp();


 signals:

    void valueChanged(double);
    void buttonReleased(double);
    
};

#endif

