#ifndef QWT_CLRFLTR_H
#define QWT_CLRFLTR_H

#include <qcolor.h>


class QwtColorFilter
{
public:
    virtual ~QwtColorFilter() {}
    virtual QColor operator()(const QColor& c) const { return c;}
};


class QwtFltrDim : public QwtColorFilter
{
private:
    
    int d_dim;
public:
    
    QwtFltrDim(int dim = 100);
    QColor operator()(const QColor &c) const;
    int dimFactor() const { return d_dim; }
};


class QwtFltrGray : public QwtColorFilter
{
private:
    bool d_inv;
public:
    QwtFltrGray(bool inv = FALSE) {d_inv = inv;}
    QColor operator()(const QColor &c) const;
};

class QwtFltrInv : public QwtColorFilter
{
public:
    QColor operator()(const QColor &c) const;
};


extern QwtColorFilter NoColorFilter;

#endif



