#include <qapp.h>
#include <math.h>
#include "sliders.h"

//------------------------------------------------------------
//		curvdemo1
//
//	This example program features some of the different
//	display styles of the QwtCurve class
//------------------------------------------------------------


SliderDemo::SliderDemo(QWidget *p)
: QWidget(p)
{
    
    sldV1 = new QwtSlider(this, "", QwtSlider::Vertical, QwtSlider::Left,
			  QwtSlider::BgSlot);
    sldV2 = new QwtSlider(this, "", QwtSlider::Vertical, QwtSlider::None,
			  QwtSlider::BgTrough);
    sldV3 = new QwtSlider(this, "", QwtSlider::Vertical, QwtSlider::Right,
			  QwtSlider::BgSlot|QwtSlider::BgTrough);
    
    sldH1 = new QwtSlider(this, "", QwtSlider::Horizontal, QwtSlider::Top,
			  QwtSlider::BgTrough);
    sldH2 = new QwtSlider(this, "", QwtSlider::Horizontal, QwtSlider::Left,
			  QwtSlider::BgSlot|QwtSlider::BgTrough);
    sldH3 = new QwtSlider(this, "", QwtSlider::Horizontal, QwtSlider::Bottom,
			  QwtSlider::BgSlot);


    //
    //	Slider Properties
    //
    sldV1->setRange(0.0, 100.0, 1.0, 5);
    sldV1->setScaleMaxMinor(5);
    
    sldV2->setRange(0.0,100.0,1.0, 10);

    sldV3->setThumbWidth(20);
    sldV3->setBorderWidth(1);
    sldV3->setRange(0.0, 4.0, 0.01);
    sldV3->setScale(1.0, 1.0e4, TRUE);
    sldV3->setScaleMaxMinor(10);
    
    sldH1->setThumbWidth(10);
    sldH1->setRange(-10.0, 10.0, 1.0, 0); // paging disabled

    sldH2->setRange(0.0, 1.0, 0.01, 5);
    sldH3->setRange(1000.0, 3000.0, 10.0, 10);

    sldH3->setThumbWidth(25);
    sldH3->setThumbLength(12);
    sldH3->setMargins(10, 0);
    
    lblV1 = new QLabel("0.0",this);
    lblV2 = new QLabel("0.0",this);
    lblV3 = new QLabel("0.0",this);
    lblH1 = new QLabel("0.0",this);
    lblH2 = new QLabel("0.0",this);
    lblH3 = new QLabel("0.0",this);

    lblHTitle = new QLabel("Horizontal Sliders", this);
    lblVTitle = new QLabel("Vertical Sliders", this);
    lblHTitle->setFont(QFont("Helvetica", 14, QFont::Bold));
    lblVTitle->setFont(lblHTitle->font());
    
    lytGrid = new QGridLayout(this, 5,5,20,10);
    
    lblHTitle->setMinimumSize(lblHTitle->sizeHint());
    lblVTitle->setMinimumSize(lblVTitle->sizeHint());
    lytGrid->addMultiCellWidget(lblVTitle, 0,0,0,2);
    lytGrid->addMultiCellWidget(lblHTitle, 0,0,3,4);

    sldV1->setMinimumSize(sldV1->sizeHint().width(), 100);
    sldV1->setMaximumSize(sldV1->sizeHint().width(), 1000);

    sldV2->setMinimumSize(20, 100);
    sldV2->setMaximumSize(20, 1000);

    sldV3->setMinimumSize(sldV3->sizeHint().width(), 100);
    sldV3->setMaximumSize(sldV3->sizeHint().width(), 1000);

    lytGrid->addMultiCellWidget(sldV1, 1,3,0,0, AlignRight);
    lytGrid->addMultiCellWidget(sldV2, 1,3,1,1, AlignHCenter);
    lytGrid->addMultiCellWidget(sldV3, 1,3, 2, 2, AlignLeft);

    sldH1->setMaximumSize(1000, sldH1->sizeHint().height());
    sldH1->setMinimumSize(150, sldH1->sizeHint().height());

    sldH2->setMinimumSize(150, 20);
    sldH2->setMaximumSize(1000, 20);

    sldH3->setMinimumSize(150, sldH3->sizeHint().height());
    sldH3->setMaximumSize(1000, sldH3->sizeHint().height());
    
    lytGrid->addWidget(sldH1, 1, 3, AlignTop);
    lytGrid->addWidget(sldH2, 2, 3, AlignVCenter);
    lytGrid->addWidget(sldH3, 3, 3, AlignBottom);

    lblV1->setFixedSize(60,30);
    lblV1->setAlignment(AlignHCenter);
    lblV2->setFixedSize(60,30);
    lblV2->setAlignment(AlignHCenter);
    lblV3->setFixedSize(60,30);
    lblV3->setAlignment(AlignLeft);
    
    lytGrid->addWidget(lblV1, 4, 0, AlignRight);
    lytGrid->addWidget(lblV2, 4, 1, AlignHCenter);
    lytGrid->addWidget(lblV3, 4, 2, AlignLeft);

    lblH1->setFixedSize(50,30);
    lblH1->setAlignment(AlignVCenter);
    lblH2->setFixedSize(50,30);
    lblH2->setAlignment(AlignVCenter);
    lblH3->setFixedSize(50,30);
    lblH3->setAlignment(AlignVCenter);

    lytGrid->addWidget(lblH1, 1, 4, AlignVCenter);
    lytGrid->addWidget(lblH2, 2, 4, AlignVCenter);
    lytGrid->addWidget(lblH3, 3, 4, AlignVCenter);

    lytGrid->setColStretch(0,1);
    lytGrid->setColStretch(1,3);
    lytGrid->setColStretch(2,1);
    lytGrid->setColStretch(3,10);
    lytGrid->setColStretch(4,0);

    lytGrid->setRowStretch(0,1);
    lytGrid->setRowStretch(1,3);
    lytGrid->setRowStretch(2,10);
    lytGrid->setRowStretch(3,3);
    lytGrid->setRowStretch(4,0);
    
    connect(sldH1, SIGNAL(valueChanged(double)), lblH1, SLOT(setNum(double)));
    connect(sldH2, SIGNAL(valueChanged(double)), lblH2, SLOT(setNum(double)));
    connect(sldH3, SIGNAL(valueChanged(double)), lblH3, SLOT(setNum(double)));
    connect(sldV1, SIGNAL(valueChanged(double)), lblV1, SLOT(setNum(double)));
    connect(sldV2, SIGNAL(valueChanged(double)), lblV2, SLOT(setNum(double)));
    connect(sldV3, SIGNAL(valueChanged(double)), SLOT(setV3(double)));
    
    
    setMinimumSize(550,250);
    
}

void SliderDemo::setV3(double value)
{
    lblV3->setNum(pow(10.0, value));
}

SliderDemo::~SliderDemo()
{

}


//
//  MAIN
//
int main (int argc, char **argv)
{
    QApplication a(argc, argv);
    QApplication::setFont(QFont("Helvetica",10));

    SliderDemo w(0);

    a.setMainWidget(&w);
    w.show();

    return a.exec();
}











