#include <qapp.h>
#include <math.h>
#include "radio.h"
#include "tunerfrm.h"
#include "ampfrm.h"

//
//  CONSTRUCT MAIN WINDOW
//
MainWin::MainWin()
: QWidget()
{

    frmTuner = new TunerFrame(this);
    frmTuner->setFrameStyle(QFrame::Panel|QFrame::Raised);
    frmAmp = new AmpFrame(this);
    frmAmp->setFrameStyle(QFrame::Panel|QFrame::Raised);
    setFixedSize(720,240);

    frmTuner->move(0,0);
    frmAmp->move(0,120);
    
    connect(frmTuner, SIGNAL(fieldChanged(double)), frmAmp, SLOT(setMaster(double)));

    frmTuner->setFreq(90.0);    
}

//
//  DESTRUCTOR
//
MainWin::~MainWin()
{
    delete frmTuner;
    delete frmAmp;
}



//
//  MAIN
//
int main (int argc, char **argv)
{
    QApplication a(argc, argv);
    MainWin w;

    a.setMainWidget(&w);
    w.show();

    return a.exec();
}











