#include <qapp.h>
#include <qwidget.h>
#include <qwt_plot.h>
#include <qwt_math.h>
extern "C"
{
#include <stdlib.h>
}

const int PLOT_SIZE = 201;		// 0 to 200

//-----------------------------------------------------------------
//		data_plot.cpp
//
//	This example shows how to display time-varying data
//	using QwtPlot.
//
//-----------------------------------------------------------------

class MainWin : public QWidget
{
private:
    QwtPlot *plot;
    int tid;
    double x[PLOT_SIZE], y[PLOT_SIZE], z[PLOT_SIZE];
public:
    MainWin();
    ~MainWin();
protected:
    void resizeEvent(QResizeEvent *e);
    void timerEvent(QTimerEvent *e);
};


//
//	Initialize main window
//
MainWin::MainWin()
: QWidget(0,0)
{
    
    int i;
    long cRight, cLeft;
    long mY;

    tid = 0;
    
    // Allocate the QwtPlot widget 
    plot = new QwtPlot(this);

    //  Initialize data
    for (i = 0; i< PLOT_SIZE; i++)
    {
	x[i] = 0.5 * double(i);		// time axis
	y[i] = 0;
	z[i] = 0;
    }

    // Assign a title
    plot->setTitle("Another Simple QwtPlot Demonstration");

    // Insert new curves
    cRight = plot->insertCurve("Data Moving Right");
    cLeft = plot->insertCurve("Data Moving Left");

    // Set curve styles
    plot->setCurvePen(cRight, QPen(red));
    plot->setCurvePen(cLeft, QPen(blue));

    // Attach (don't copy) data. Both curves use the same x array.
    plot->setCurveRawData(cRight, x, y, PLOT_SIZE);
    plot->setCurveRawData(cLeft, x, z, PLOT_SIZE);

    //  Insert zero line at y = 0
    mY = plot->insertLineMarker("", QwtPlot::yLeft);     
    plot->setMarkerYPos(mY, 0.0);

    // Set axis titles
    plot->setAxisTitle(QwtPlot::xBottom, "Time/seconds");
    plot->setAxisTitle(QwtPlot::yLeft, "Values");
    
    // Display a legend
    plot->enableLegend(TRUE);

    // Generate timer event every 500ms
    tid = startTimer(50);
    
}


//
//	Generate new values every 500ms. 
//
void MainWin::timerEvent(QTimerEvent *e)
{
    static double phase = 0.0;

    if (phase > (M_PI - 0.0001)) phase = 0;

    // y moves from left to right:
    // Shift y array right and assign new value to y[0].
    qwtShiftArray(y, PLOT_SIZE, 1);
    y[0] = sin(phase) * (-1.0 + 2.0 * double(rand()) / double(RAND_MAX));

    // z moves from right to left:
    // Shift z array left and assign new value to z[n-1].
    qwtShiftArray(z, PLOT_SIZE, -1);
    z[PLOT_SIZE - 1] = 0.8 - (2.0 * phase/M_PI) + 0.4 * double(rand()) / double(RAND_MAX);

    // update the display
    plot->replot();

    phase += M_PI * 0.02;
    
}

MainWin::~MainWin()
{
    delete plot;
    if (tid) killTimer(tid);
}

//
//	Adjust QwtPlot's size
//
void MainWin::resizeEvent(QResizeEvent *e)
{
    plot->resize(e->size());
    plot->move(0,0);
}

int main(int argc, char **argv)
{
    QApplication a(argc, argv);
    MainWin w;
    a.setMainWidget(&w);
    w.show();
    return a.exec(); 
}













