/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTHEADER
#define _QDBTHEADER

#include <qwidget.h>
#include <qlist.h>

#include "qdbtsection.h"
#include "qdbttabcell.h"

typedef QList<QdbtSection> SectionList;

class QdbtTabular;

struct QdbtHeadCell
{
  int width;
  int position;
  bool resizable;
};

class QdbtHeader : public QWidget
{
  Q_OBJECT

  friend class QdbtSection;

  public:
    QdbtHeader(QWidget *parent=0,const char *name=0);
    virtual ~QdbtHeader();
    int  heightHint() const { return barHeight; }
    int  columnWidthHint(int col);
    void insertCol(int col);
    void removeCol(int col);
    void setColumnWidth(int c,int w);
    void setColumns(int num);
    void setFont(const QFont &font);
    void changeSection(QdbtSection *section,int col);
    QdbtSection *section(int col);
    void setPalette(const QPalette &);

  public slots:
    void resizeSection(int x);
    void setHeaderOffset(int);

  signals:
    void signalColumnWidth(int c,int w);
    void setTableOffset(int);
    void updateTable();
    void sectionClicked(int);
    void exposeColumn(int);

  protected:
    void resizeEvent(QResizeEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void updateDividerCursor(int);
    void paintEvent(QPaintEvent *);
    void keyPressEvent(QKeyEvent *);
    
  private slots:
    void sectionClicked(QdbtSection *);
    void setResizable(QdbtSection *,bool);
    void initFocusPolicy();

  private:
    void updateHeader();
    int  computeHeight();
      
    int  barHeight;
    int  divider;
    SectionList       sections; 
    QArray<QdbtHeadCell> headCells;
    QdbtTabular         *parent;
};

#endif
