/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qapp.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qpixmap.h>

#include <qdbt/qdbttabcell.h>
#include <qdbt/qdbtsection.h>
#include "example4.h"

const QColor base(230,200,200);

MyTabular::MyTabular(QWidget *parent,const char *name,WFlags f) :
  QdbtTabular(parent,name,f)
{
  currentCell=QPoint(-1,-1);

  QColorGroup cg=colorGroup();
  QColorGroup newCg(black,base,base.light(),
                    base.dark(),base,black,base.dark(110));
  setPalette(QPalette(newCg,newCg,newCg));
}

MyTabular::~MyTabular()
{
}

// the mouse press handler shows how you can make a table where
// the user can only select one cell at a time
void MyTabular::mousePressEvent(QMouseEvent *e)
{
  int rowClicked=findRow(e->y());
  int colClicked=findCol(e->x());
  
  // check if the user clicked a valid cell that differs from the
  // current cell
  if (rowClicked!=-1 && colClicked>0 && 
    !(rowClicked==currentCell.x() && colClicked==currentCell.y()))
  {
    // remove the highlight from the current cell (if any)
    if (currentCell.x()!=-1 && currentCell.y()>0)
    {
      QdbtTableCell *c=(QdbtTableCell *)cell(currentCell.x(),currentCell.y());
      if (c) 
      {
        c->setSelected(FALSE); 
        changeCell(c,currentCell.x(),currentCell.y());
      }
    }
    // get a copy of the new cell
    QdbtTableCell *c=(QdbtTableCell *)cell(rowClicked,colClicked);
    // check if it is the null cell (these cannot be selected)
    if (c) 
    {
      // select the local cell
      c->setSelected(TRUE);
      // replace the cell in the table with this one
      changeCell(c,rowClicked,colClicked);
    }
    // store the new location of the currenly selected cell
    currentCell.setX(rowClicked);
    currentCell.setY(colClicked);
  }
}

void MyTabular::mouseDoubleClickEvent(QMouseEvent *e)
{
  int rowClicked=findRow(e->y());
  int colClicked=findCol(e->x());
  if (rowClicked!=-1 && colClicked>0)
  {
    editCell(rowClicked,colClicked); 
  } 
}

// constructor
Example::Example(QWidget *parent,const char *name, WFlags f) 
      : QWidget(parent,name,f)
{
  // Set the caption of the window
  setCaption("Example4");

  // The Layout managers
  QGridLayout *layout  = new QGridLayout(this,2,1,5);
  QBoxLayout  *buttons = new QBoxLayout(QBoxLayout::LeftToRight);
  
  // create three tables
  MyTabular *tabular=new MyTabular(this);

  // set the number of row/columns
  tabular->setDimensions(5,3);
  
  // let's test the insertCol function, just for fun.
  tabular->insertCol(3);
 
  // let's test the insertCol function, just for fun.
  tabular->insertRow(5);

  // set the minimum size of the table
  tabular->setMinimumSize(100,100);

  // select cell instead of rows
  tabular->selectByRow(FALSE);

  // set the font of the heading
  tabular->setHeaderFont(QFont("helvetica",16,QFont::Bold));

  // set the font of the cells
  tabular->setCellFont(QFont("helvetica",12,QFont::Normal));

  // Load the folder pixmap (No error checking!)
  QPixmap folder;
  folder.load("folder3d.xpm");

  QdbtSection *section;
  section=tabular->section(0);
  section->setResizable(FALSE);
  section=tabular->section(1);
  section->setText("Left");
  section=tabular->section(2);
  section->setText("Center");
  section->setAlignment(AlignCenter);
  section=tabular->section(3);
  section->setText("Right");
  section->setAlignment(AlignRight);

  QdbtTableCell cell;
  cell.setEditable(TRUE);
  cell.setSelectable(FALSE);

  // first column
  cell.setAlignment(AlignLeft);
  cell.setPixmap(0);
  cell.setBackground(tabular->colorGroup().base().dark(120));
  cell.setText("Text only");
  tabular->changeCell(&cell,0,0); 
  cell.setText("Pixmap only");
  tabular->changeCell(&cell,1,0); 
  cell.setText("Pimap left");
  tabular->changeCell(&cell,2,0); 
  cell.setText("Pimap right");
  tabular->changeCell(&cell,3,0); 
  cell.setText("Pimap top");
  tabular->changeCell(&cell,4,0); 
  cell.setText("Pimap bottom");
  tabular->changeCell(&cell,5,0); 
  
  // second column
  cell.setBackground(tabular->colorGroup().base());
  cell.setText("left");
  tabular->changeCell(&cell,0,1);
  cell.setText(0);
  cell.setPixmap(&folder);
  cell.setPixmapAlignment(AlignLeft);
  tabular->changeCell(&cell,1,1);
  cell.setText("left");
  tabular->changeCell(&cell,2,1);
  cell.setPixmapAlignment(AlignRight);
  tabular->changeCell(&cell,3,1);
  cell.setPixmapAlignment(AlignTop);
  tabular->changeCell(&cell,4,1);
  cell.setPixmapAlignment(AlignBottom);
  tabular->changeCell(&cell,5,1);


  // third column
  cell.setAlignment(AlignCenter);
  cell.setText("center");
  cell.setPixmap(0);
  tabular->changeCell(&cell,0,2);
  cell.setText(0);
  cell.setPixmap(&folder);
  cell.setPixmapAlignment(AlignLeft);
  tabular->changeCell(&cell,1,2);
  cell.setText("center");
  tabular->changeCell(&cell,2,2);
  cell.setPixmapAlignment(AlignRight);
  tabular->changeCell(&cell,3,2);
  cell.setPixmapAlignment(AlignTop);
  tabular->changeCell(&cell,4,2);
  cell.setPixmapAlignment(AlignBottom);
  tabular->changeCell(&cell,5,2);

  // forth column
  cell.setAlignment(AlignRight);
  cell.setText("right");
  cell.setPixmap(0);
  tabular->changeCell(&cell,0,3);
  cell.setText(0);
  cell.setPixmap(&folder);
  cell.setPixmapAlignment(AlignRight);
  tabular->changeCell(&cell,1,3);
  cell.setText("right");
  cell.setPixmapAlignment(AlignLeft);
  tabular->changeCell(&cell,2,3);
  cell.setPixmapAlignment(AlignRight);
  tabular->changeCell(&cell,3,3);
  cell.setPixmapAlignment(AlignTop);
  tabular->changeCell(&cell,4,3);
  cell.setPixmapAlignment(AlignBottom);
  tabular->changeCell(&cell,5,3);

  tabular->setColumnWidth(0,tabular->columnWidthHint(0));
  tabular->setColumnWidth(1,tabular->columnWidthHint(1)+100);
  tabular->setColumnWidth(2,tabular->columnWidthHint(2)+100);
  tabular->setColumnWidth(3,tabular->columnWidthHint(3)+100);

  // Create the close button
  QPushButton *close  = new QPushButton("Close",this);

  // Set its minimum sizes
  close ->setMinimumSize(close->sizeHint());

  // Add Widgets and layouts to the layout-manager
  layout->addWidget(tabular,0,0);
  layout->addLayout(buttons,1,0);
  layout->setColStretch(0,1); // make the table strechable
  layout->setRowStretch(0,1);

  // Add the Widget to the button layout
  buttons->addStretch(1);
  buttons->addWidget(close);

  // don't forget to activate the top layout manager
  layout->activate();

  // Let the close button quit the application
  connect(close,  SIGNAL(clicked()),qApp,SLOT(quit()));
  
  // Resize the widget to its minimal size
  resize(layout->mainWidget()->sizeHint());

}

// destructor
Example::~Example()
{
}

int main(int argc,char **argv)
{
  QApplication app(argc, argv);
  Example example;
  app.setMainWidget(&example);
  example.resize(640,340);
  example.show();
  return app.exec();  
}
