/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _EXAMPLE2_H
#define _EXAMPLE2_H

#include <qwidget.h>
#include <qlabel.h>
#include <qpopmenu.h>

#include <qdbt/qdbttabular.h>

class MyTabular : public QdbtTabular
{
  Q_OBJECT

  public:
    MyTabular(QWidget *parent=0,const char *name=0,WFlags f=0);
   ~MyTabular();
    void buildPopupMenu();
  
  signals:
    void setStatus(const char *);

  public slots:
    void setCellText(int index);

  protected:
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);
    void leaveTableEvent(QEvent *e);
    void resizeEvent(QResizeEvent *);

  private:
    QPopupMenu *popMenu;
    int clickedRow,clickedCol;
};

class Example : public QWidget
{
  Q_OBJECT

  public:
    Example(QWidget *parent=0, const char *name=0, WFlags f=0);
   ~Example();

  public slots:
    void showStatus(const char *);

  private:
    QLabel *status;
};

#endif
