#include "all.h"

/*------------------------------------------------------------------*/
/*      Find the function callped *cp, and return it's number       */
/*------------------------------------------------------------------*/

/* You can add a function, you MUST place it in alphabetical order  */
/* and give it the next unused index number			    */

/* ret = Type of returned value,  1=number, 2=string */
/* np = number of paramters expected */
/* Parameters p0...p4  ==  1=number, 2=string, 0=none (e.g. height()) .  */

#define NKEYS (sizeof keywfn / sizeof(struct keyw))
struct keyw { char *word; int index; int ret,np,p[5]; } keywfn[] = {
		" ",0		,1 ,0 ,0,0,0,0,0
		,"+",1		,1 ,0 ,0,0,0,0,0
		,"-",2		,1 ,0 ,0,0,0,0,0
		,"ABS",3	,1 ,1 ,1,0,0,0,0
		,"ACOS",53	,1 ,1 ,1,0,0,0,0
		,"ASIN",54	,1 ,1 ,1,0,0,0,0
		,"ATN",4	,1 ,1 ,1,0,0,0,0
		,"CHR$",52	,2 ,1 ,1,0,0,0,0
		,"COS",5	,1 ,1 ,1,0,0,0,0
		,"CVTCOLOR",49  ,1 ,1 ,2,0,0,0,0
		,"CVTFONT",50	,1 ,1 ,2,0,0,0,0
		,"CVTGREY",45	,1 ,1 ,1,0,0,0,0
		,"CVTINT",46	,1 ,1 ,1,0,0,0,0
		,"CVTMARKER",48 ,1 ,1 ,2,0,0,0,0
		,"CVTRGB",47	,1 ,3 ,1,1,1,0,0
		,"DATE$",6	,2 ,0 ,0,0,0,0,0
		,"DEVICE$",51	,2 ,0 ,0,0,0,0,0
		,"EOF",55	,1 ,1 ,1,0,0,0,0
		,"EXP",7	,1 ,1 ,1,0,0,0,0
		,"FEOF",55	,1 ,1 ,1,0,0,0,0
		,"FIX",8	,1 ,1 ,1,0,0,0,0
		,"HEIGHT",9	,1 ,1 ,0,0,0,0,0
		,"INT",10	,1 ,1 ,1,0,0,0,0
		,"LEFT$",11	,2 ,2 ,2,1,0,0,0
		,"LEN",12	,1 ,1 ,2,0,0,0,0
		,"LOG",13	,1 ,1 ,1,0,0,0,0
		,"LOG10",14	,1 ,1 ,1,0,0,0,0
		,"NOT",15	,1 ,1 ,1,0,0,0,0
		,"NUM$",16	,2 ,1 ,1,0,0,0,0
		,"NUM1$",17	,2 ,1 ,1,0,0,0,0
		,"PAGEHEIGHT",18,1 ,1 ,0,0,0,0,0
		,"PAGEWIDTH",19	,1 ,1 ,0,0,0,0,0
		,"POS",20	,1 ,3 ,2,2,1,0,0
		,"RIGHT$",21	,2 ,2 ,2,1,0,0,0
		,"RND",22	,1 ,1 ,1,0,0,0,0
		,"SEG$",23	,2 ,3 ,2,1,1,0,0
		,"SGN",24	,1 ,1 ,1,0,0,0,0
		,"SIN",25	,1 ,1 ,1,0,0,0,0
		,"SQR",26	,1 ,1 ,1,0,0,0,0
		,"SQRT",27	,1 ,1 ,1,0,0,0,0
		,"TAN",28	,1 ,1 ,1,0,0,0,0
		,"TDEPTH",29	,1 ,1 ,2,0,0,0,0
		,"THEIGHT",30	,1 ,1 ,2,0,0,0,0
		,"TIME$",31	,2 ,0 ,0,0,0,0,0
		,"TWIDTH",32	,1 ,1 ,2,0,0,0,0
		,"VAL",33	,1 ,1 ,2,0,0,0,0
		,"WIDTH",34	,1 ,1 ,0,0,0,0,0
		,"XEND",35	,1 ,1 ,0,0,0,0,0
		,"XG",36	,1 ,1 ,1,0,0,0,0
		,"XGRAPH",36	,1 ,1 ,1,0,0,0,0
		,"XMAX",37	,1 ,1 ,0,0,0,0,0
		,"XMIN",38	,1 ,1 ,0,0,0,0,0
		,"XPOS",39	,1 ,1 ,0,0,0,0,0
		,"YEND",40	,1 ,1 ,0,0,0,0,0
		,"YG",41	,1 ,1 ,1,0,0,0,0
		,"YGRAPH",41	,1 ,1 ,1,0,0,0,0
		,"YMAX",42	,1 ,1 ,0,0,0,0,0
		,"YMIN",43	,1 ,1 ,0,0,0,0,0
		,"YPOS",44	,1 ,1 ,0,0,0,0,0
} ;

int binsearch(char *word, struct keyw tab[], int n);

find_un(char *cp, int *idx,int *ret,int *np,int **plist)
{
	int i;
	i = binsearch(cp,keywfn,NKEYS);
	*idx = keywfn[i].index;
	*ret = keywfn[i].ret;
	*np =  keywfn[i].np;
	*plist = &keywfn[i].p[0];
}

/*------------------------------------------------------------------*/
/* Simple binary search 					    */
/*------------------------------------------------------------------*/
binsearch(char *word, struct keyw tab[], int n)
{
	int cond,low,high,mid;
	low = 0;
	high = n-1;
	while (low <= high) {
		mid = (low+high) / 2;
		if ((cond = strcmp(word,tab[mid].word)) < 0)
			high = mid - 1;
		else if (cond > 0)
			low = mid + 1;
		else
			return mid;
	}
	return 0;
}


























