/* this is for a   Laserjet series II printer, which I think doesn't
like the compressed data format */

#define XSIZECM 19		/* 150 dpi*/
#define YSIZECM 27		/* */
#define NXBITS 1128 	/* (XSIZECM/2.54)*150  rounded up to nearest byte */
#define NYBITS 1600

extern int hp_plus;
#include "bitmap.h"
dvitype(void)
{
	if (hp_plus)
	 printf("Deskjet/Laserjet  (usage: dvilj [-old] [-debug] [outfile.prt])\n  (use -old for printers which cannot handle data compression.)");
	else
	 printf("Deskjet/Laserjet  (NO COMPRESSION)");
}
int ljsendline(char *s, int nc, int y);
bitmap_print(void)
{
	int x,y,nout;
	static unsigned char out_buff[NXBITS+30];
	unsigned char swapbit[256];
	unsigned char swapnib[16]={0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15};
	unsigned char *o,c;
	int nc,i,n1,n2;

	printf("Writing out bitmap\n");
	for (i=0;i<256;i++) {
		n1 = i & 0xf;
		n2 = (i >> 4) & 0xf;
		swapbit[i] = swapnib[n2] | (swapnib[n1] << 4);
	}
	pprintf("%cE",27); 	/* reset  */
	pprintf("\x1b*t150R");	/* set resolution 150 dpi */
	/* pprintf("\x1b&a%.1fH",0.0); */			/* move x */
	/* pprintf("\x1b&a%.1fV",((NYBITS-y)/150.0)*720.0); */	/* move y */
	if (hp_plus)  pprintf("\x1b*b1M");	/* compact */
	pprintf("\x1b*r1A");			/* start graphics at cur pos */
	for (y=(nybits-1); y>=0; y--) {
	    for (nout=(nxbits/8);  bitmap[y][nout-1]==0 && nout>0; nout--);
	    o = &out_buff[0];
	    for (x=0; x<nout ; x++) {
		c = bitmap[y][x];
		nc = 0;
		if (hp_plus) {
		    for (;x<(nout-1) && bitmap[y][x+1]==c && nc<250; x++) nc++;
		    *o++ = nc;
		}
		*o++ = swapbit[c];
	  }
	  ljsendline(out_buff,o-out_buff,y);
	}
	pprintf("\x1b*rB");	/* end graphics */
	pprintf("\x0c");	/* form feed, reset origin */
}
ljsendline(char *s, int nc,int y)
{
	pprintf("\x1b*b%dW",nc);	/* send y bytes */
	printmem(s,nc);
}


