#include "all.h"
#include <math.h>
#include "mygraph.h"   /* Prototypes for all the graph routines */
#define true (!false)
#define false 0
int ncvec=0;
int cvec_list(int32 *pcode);
double cvecx[30],cvecy[30];
double dcvecx[30],dcvecy[30];
int rbezier(double x1, double y1, double x2, double y2, double x3, double y3);
g_curve(int32 *pcode)
{
	double oox,ooy;
	double oval;
	int ct=2,i;
	double dx1,dy1;

	ncvec = 0;
	cvec_list(pcode);
	dx1 = cvecx[1] - cvecx[0];
	dy1 = cvecy[1] - cvecy[0];
	dcvecx[0] = cvecx[ncvec] - cvecx[ncvec-1];
	dcvecy[0] = cvecy[ncvec] - cvecy[ncvec-1];
	for (i=0;i<=ncvec;i++) {
		cvecx[i] = cvecx[i] - dx1;
		cvecy[i] = cvecy[i] - dy1;
	}
	for (i=1;i<ncvec;i++) {
		dcvecx[i] = (cvecx[i+1] - cvecx[i-1]) * .25;
		dcvecy[i] = (cvecy[i+1] - cvecy[i-1]) * .25;
	}
	for (i=1; i<ncvec-1; i++) {
		rbezier(dcvecx[i],dcvecy[i],dcvecx[i+1],dcvecy[i+1]
			,cvecx[i+1],cvecy[i+1]);
	}
}
rbezier(double x1, double y1, double x2, double y2, double x3, double y3)
{
	double cx,cy;
	g_get_xy(&cx,&cy);
	g_bezier(x1+cx,y1+cy,x3-x2,y3-y2,x3,y3);
}
cvec_list(int32 *pcode)
{
	char ostr[90];
	int i,cp=0,otyp;
	double cx,cy,x1,y1,x2,y2;
	g_get_xy(&cx,&cy);
	ncvec = 0;
	cvecx[0] = cx;
	cvecy[0] = cy;
	while ( *(pcode + cp++)==111) {
		if (ncvec>27) {gprint("Too many param in curve\n"); return; }
		eval(pcode,&cp,&x1,ostr,&otyp);
		eval(pcode,&cp,&y1,ostr,&otyp);
		cvecx[++ncvec] = x1;
		cvecx[ncvec] = cvecx[ncvec] + cvecx[ncvec-1];
		cvecy[ncvec] = y1;
		cvecy[ncvec] = cvecy[ncvec] + cvecy[ncvec-1];
	}
}



