#ifdef __TURBOC__
#include <alloc.h>
#endif
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"

#ifndef __TURBOC__
#define huge
#endif
#define true (!false)
#define false 0
unsigned char (huge *bitmap)[NXBITS/8+2];
int d_open(double x, double y);
extern int gdebug;
extern int nxbits,nybits;
#define dbg if (gdebug==true)
int bitmap_print(void);
int bitmap_free(void);
int bitmap_alloc(void);
int bitmap_paint(int row, int x1, int x2);
int printmem(char *x,int n);

#ifdef aix
void pprintf(va_list);
#else
void pprintf(va_list arg_list, ...);
#endif
int dvitype(void);



/*--------------------------------------------------------------*/
/*	Bitmap output for EPSON printers 			*/
/*--------------------------------------------------------------*/
int bitmap_print(void);
char *bitmap_line(int y);
int bitmap_size(int *xbits, int *ybits, double *width, double *height);
bitmap_size(int *xbits, int *ybits, double *width, double *height)
{
	*xbits = NXBITS; *ybits = NYBITS; *width = XSIZECM; *height = YSIZECM;
}
int print_row(int i);

bitmap_free(void)
{
	if (bitmap==NULL) return;
#ifdef __TURBOC__
	farfree(bitmap);
#else
	free(bitmap);
#endif
	bitmap = 0;
}
bitmap_alloc(void)
{
	int32 bsize;
	if (bitmap!=NULL) return;
	bsize = ((int32) nybits+1)*(NXBITS/8+2);
#ifdef __TURBOC__
	bitmap = farcalloc(nybits+1,NXBITS/8 +2);
	printf("Core memory left %ld,  just used %ld  %d %d \n"
		,coreleft(),bsize,NXBITS,nybits);
#else
	bitmap = calloc(nybits+1,(NXBITS/8+2));
#endif
	dbg printf("bitmap allocated %p \n",bitmap);
	if (bitmap==0) gle_abort("Not able to allocate bitmap \n");
}


unsigned int grey_bits[] = {0x0000, 0x0200, 0x0802, 0x0a02,
		0x5050, 0x5250, 0x5852, 0x5a52,
		0xa5a5, 0xa7a5, 0xada7, 0xafa7,
		0xf5f5, 0xf7f5, 0xfdf7, 0xfff7, 0xffff};
unsigned int cur_bits[4];
#define NGREY 17
set_grey(float f)
{
	int i,j,m;
	i = (1.0-f)*(NGREY-.8);
	m = grey_bits[i];
	for (j=0; j<4; j++) {
		cur_bits[j] = m & 0x000f;
		m = m >> 4;
	}
}
bitmap_paint(int row, int x1, int x2)
{
	int i,xm,ym,xadd=0;
	x1-=1; x2-=1;
	if (x1<0) x1 = 0;
	if (x2>=nxbits) x2 = nxbits-1;
	dbg printf("paint row,%d   %d %d \n",row,x1,x2);
	ym = row % 4;
	if ((row & 4)>0) xadd = 1;
	for (;x1<=x2;x1++) {
		xm = 1 << ((x1+xadd) % 4);
		if ((cur_bits[ym] & xm)!=0) {
			i = bitmap[row][x1/8];
			bitmap[row][x1/8] = i | (1 << (x1 % 8));
		}
	}
}
char *bitmap_line(int y)
{
	return &bitmap[y][0];
}
bitmap_pixel(int x, int y)
{
	static char *line;
	static int ly= -2;
/*	if (x<0 || x>nxbits || y < 0 || y > nybits) return; */
	if (ly!=y) line = &bitmap[y][0];
	line[x/8] |= (1 << (x % 8));
	ly = y;
}




