


/**************************************************************************/
/******************* DEFINICIONES GENERALES *******************************/
/**************************************************************************/
/** Propiedad de TxinoSoft Co. ************************/
/******************************************************/
/** Copyright (c) 1995. J.Fernando Moyano *************/
/******************************************************/


#ifndef _GENERAL_DEFS
#define _GENERAL_DEFS


/***************************************************************************/
/**************** DEFINICIONES DE LITERALES Y MACROS BASICAS ***************/
/***************************************************************************/

/******* LITERALES CONSTANTES BASICAS **********/

#ifndef NULL
 #define NULL  0
#endif /* NULL */

#ifndef BOOLDEFS
 #define FALSE 0
 #define TRUE  1
 #define OFF   0
 #define ON    1
#endif /* BOOLDEFS */


/******** MACROS matematicas triviales **********/


#ifndef MAX
 #define MAX(a,b)  (a)>(b) ? (a) : (b)
#endif /* MAX(a,b) */

#ifndef MIN
  #define MIN(a,b)  (a)<(b) ? (a) : (b)
#endif /* MIN(a,b) */

#ifndef ABS
 #define ABS(a) (a)>=0 ? (a) : -(a)
#endif /* ABS(a) */

#ifndef SIG
  #define SIG(a) (a)>=0 ? (1) : (-1)
#endif /* SIG(a) */



/**************************************************************************/
/************************ Definicion de tipos *****************************/
/**************************************************************************/


#ifndef _TIPOS_DEF
#define _TIPOS_DEF

typedef unsigned char BYTE;      // TIPOS SIMPLES SIN SIGNO
typedef unsigned char byte;
typedef unsigned char BOOLEAN;
typedef unsigned char boolean;
typedef unsigned int  WORD;
typedef unsigned int  word;
typedef unsigned long DWORD;
typedef unsigned long dword;
typedef long     LONG;
typedef void     VOID;

typedef word fixnum;
typedef word FIXNUM;    // Ns en coma fija de 32 bits.

#define MAKE_FIX(i,d)   ((fixnum(i)<<16)|(d))   // Macro para crear Ns en coma fija.
#define INT_PART(a)        (int((a)>>16))
#define DEC_PART(a)        (int((a)&0x0000ffff))


typedef VOID * VOIDPTR;      // PUNTEROS
typedef void * voidptr;

typedef BYTE * BYTEPTR;
typedef byte * byteptr;

typedef char * STRPTR;
typedef char * strptr;

typedef int * INTPTR;
typedef int * intptr;

typedef WORD * WORDPTR;
typedef word * wordptr;

typedef LONG * LONGPTR;
typedef long * longptr;

typedef DWORD *  DWORDPTR;
typedef dword *  dwordPTR;

#endif /*_TIPOS_DEFS */

/************************************************************************/



typedef struct
{
  int index;
  int r;
  int g;
  int b;
  int pixel;
  
  void set(int i,int rr,int gg,int bb,int pix) { index=i;r=rr;g=gg;b=bb;pixel=pix; }
}rgb_str;  






#endif /* GENERAL_DEFS */


/************************** FIN *****************************************/



