dnl $Id: acinclude.m4,v 1.7 2003/02/16 10:24:40 aa5779 Stable $
dnl Copyright (C) 2002 by Artem V. Andreev
dnl
dnl    This program is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    This program is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with this program; if not, write to the Free Software
dnl    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl
dnl

AC_DEFUN(UTIL_TEST_CFLAGS,
		[AC_CACHE_CHECK([whether $CC supports $1], utils_cv_prog_cc_[]m4_translit([$1], [+=-], [p_]),  
								[cflags_saved=$CFLAGS
								CFLAGS="$1"
								AC_TRY_COMPILE([], [;], 
													[utils_cv_prog_cc_[]m4_translit([$1], [+=-], [p_])=yes], 
													[utils_cv_prog_cc_[]m4_translit([$1], [+=-], [p_])=no])
								CFLAGS=$cflags_saved
								]
						)
		if test "$utils_cv_prog_cc_[]m4_translit([$1], [+=-], [p_])" = "yes"; then
		   $2
		   :
		else
		   $3
		   :
		fi
		]
)

AC_DEFUN(UTIL_COMMON_CFLAGS,
[if test "$GCC" = "yes"; then
	UTIL_TEST_CFLAGS(-a, [PROFILE_CFLAGS="-pg -a"], [PROFILE_CFLAGS="-pg -fprofile-arcs"])
   CFLAGS='-funsigned-char -Wall'
   OPTCFLAGS=-O2 
   if test "$ac_cv_prog_cc_g" = "yes"; then
      DEBUG_CFLAGS=-g 
   fi  	 
else
		CFLAGS=""
		case $host in
			 *-*-solaris*)
				UTIL_TEST_CFLAGS(-xCC, CFLAGS=-xCC)
				UTIL_TEST_CFLAGS(-pg, [PROFILE_CFLAGS=-pg],
									[UTIL_TEST_CFLAGS([-xpg],
											[PROFILE_CFLAGS='-xpg'],
											[UTIL_TEST_CFLAGS([-xprofile=collect],
												[PROFILE_CFLAGS='-xprofile=collect']
										)]
									)]
								)
				;;
			*-*-osf*)
				UTIL_TEST_CFLAGS(-unsigned, CFLAGS=-unsigned)
				UTIL_TEST_CFLAGS(-check, [CFLAGS="$CFLAGS -check"])
				UTIL_TEST_CFLAGS(-prof_gen, PROFILE_CFLAGS=-prof_gen)
				;;
			*-*-hpux*)
				UTIL_TEST_CFLAGS(+uc, CFLAGS=+uc)
				UTIL_TEST_CFLAGS(+w1, [CFLAGS="$CFLAGS +w1"])
				UTIL_TEST_CFLAGS(-G, PROFILE_CFLAGS=-G)
				UTIL_TEST_CFLAGS(+O2, OPTCFLAGS=+O2)
				;;
			*)
				;;
		esac
		if test -z "$OPTCFLAGS"; then
				UTIL_TEST_CFLAGS(-O2, OPTCFLAGS=-O2)
				if test -z "$OPTCFLAGS"; then
					UTIL_TEST_CFLAGS(-O, OPTCFLAGS=-O)
				fi
		fi
		if test -z "$DEBUG_CFLAGS"; then
		   if test "$ac_cv_prog_cc_g" = "yes"; then
			  DEBUG_CFLAGS=-g
		   fi
		fi
fi

AC_CACHE_CHECK([whether $CC supports C99 style comments], 
				util_cv_prog_cc_comments,
				[AC_TRY_COMPILE([], [ // comment
									],
									util_cv_prog_cc_comments=yes,
									util_cv_prog_cc_comments=no
									)
				] 
			   )
AC_C_CHAR_UNSIGNED

AC_ARG_ENABLE(optimize, AC_HELP_STRING([--disable-optimize], [don't use optimizing C compiler]),,
[
case $host in
	alpha*-*-freebsd*)
		enable_optimize=no
		;;
	*)
		enable_optimize=yes
		;;
esac
]
)
if test "$enable_optimize" = "no"; then
   OPTCFLAGS=""
fi
AC_ARG_ENABLE(debug, AC_HELP_STRING([--disable-debug], [disable debugging info]),, enable_debug=yes)
if test "$enable_debug" != "no"; then
	AC_ARG_ENABLE(profile, AC_HELP_STRING([--enable-profile], [turn on profiling support]),, enable_profile=no)
	if test "$enable_profile" = "gcov" -a "$CC" = "gcc"; then
		PROFILE_CFLAGS='-fprofile-arcs -ftest-coverage'
	fi
	if test "$enable_profile" != "no"; then
		if test -z "$PROFILE_CFLAGS"; then
			AC_MSG_WARN([no profiling flags defined])
		else
			CFLAGS="$CFLAGS $PROFILE_CFLAGS"
		fi
	else
		CFLAGS="$CFLAGS $OPTCFLAGS"
	fi
	CFLAGS="$CFLAGS $DEBUG_CFLAGS"
else
	enable_profile=no
	CFLAGS="$CFLAGS $OPTCFLAGS"
fi
])
