/*****************************************************************************/
/* File: crunch.c                                                            */
/* Author: David Chatenay                                                    */
/* Last Modified: Thu Jan 16 1997                                            */
/*                                                                           */
/* The front-end to the Crunch library, used to crunch files.                */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "crunch.h"


#define CRUNCHER_VERSION "1.1"


/* Banner displayed each time */
static void Banner()
{
    (void)fprintf(stderr, "Cruncher v" CRUNCHER_VERSION "\n");
    (void)fprintf(stderr, FULL_NAME " v" FULL_VERSION "\n");
    (void)fprintf(stderr, "By " AUTHOR_NAME "\n\n");
}


/* Display a short usage of the program */
static void Usage(char *n)
{
    (void)fprintf(stderr, "Usage: %s -ahsw [file]\n", n);
    (void)fprintf(stderr, "        a: Adaptative Huffman\n");
    (void)fprintf(stderr, "        h: Standard Huffman\n");
    (void)fprintf(stderr, "        s: Lempel Ziv Storer Szymanski\n");
    (void)fprintf(stderr, "        w: Lempel Ziv Welch\n");
    exit(-1);
}


int main(int argc, char *argv[])
{
    char FileName[1024];
    int r=0, in, out;
    float cr;

    /* First check */
    Banner();
    if (argc != 3)
        Usage(argv[0]);

    /* Open in */
    if ((in = OpenR(argv[2], 0644)) == -1)
	return -1;

    /* Build out filename */
    (void)sprintf(FileName, "%s.jz", argv[2]);
    /* Open out file */
    if ((out = OpenW(FileName, 0644)) == -1)
      return -1;

    switch (argv[1][1]) {
    case 'a':
	r = AdaptativeHuffmanEncode(in, out, &cr);
	break;
    case 'h':
	r = HuffmanEncode(in, out, &cr);
	break;
    case 'w':
	r = LzwEncode(in, out, &cr);
        break;
    case 's':
	r = LzssEncode(in, out, &cr);
	break;
    default:
	(void)fprintf(stderr, "Invalid option: %s\n", argv[1]);
	Usage(argv[0]);
    }

    if (r == -1) {
	(void)fprintf(stderr, "There was an error during encoding.\n");
	(void)close(out);
	if(unlink(FileName) == -1)
	    perror(FileName);
	return -1;
    }

    (void)fprintf(stderr, "Compression rate: %2.2f%%\n", cr * 100.0);

    /* Close files */
    (void)close(in);
    (void)close(out);

    return r;
}
