/*****************************************************************************/
/* File: crc.c                                                               */
/* Author: David Chatenay                                                    */
/* Last Modified: Thu Oct 17 1996                                            */
/*                                                                           */
/* Contains:                                                                 */
/* - CRC16 and CRC32 functions                                               */
/*****************************************************************************/
#include "common.h"
#include "crunch.h"


/* CRC poly is:  0x04c11db7  */
/* It's the standard crc for */
/* Ethernet and FDDI frames. */

/* Initialised table of crc_32 codes to speed up */
static dword crc32_table[256] = {
    0x0,        0x4c11db7,  0x9823b6e,  0xd4326d9,
    0x130476dc, 0x17c56b6b, 0x1a864db2, 0x1e475005,
    0x2608edb8, 0x22c9f00f, 0x2f8ad6d6, 0x2b4bcb61,
    0x350c9b64, 0x31cd86d3, 0x3c8ea00a, 0x384fbdbd,
    0x4c11db70, 0x48d0c6c7, 0x4593e01e, 0x4152fda9,
    0x5f15adac, 0x5bd4b01b, 0x569796c2, 0x52568b75,
    0x6a1936c8, 0x6ed82b7f, 0x639b0da6, 0x675a1011,
    0x791d4014, 0x7ddc5da3, 0x709f7b7a, 0x745e66cd,
    0x9823b6e0, 0x9ce2ab57, 0x91a18d8e, 0x95609039,
    0x8b27c03c, 0x8fe6dd8b, 0x82a5fb52, 0x8664e6e5,
    0xbe2b5b58, 0xbaea46ef, 0xb7a96036, 0xb3687d81,
    0xad2f2d84, 0xa9ee3033, 0xa4ad16ea, 0xa06c0b5d,
    0xd4326d90, 0xd0f37027, 0xddb056fe, 0xd9714b49,
    0xc7361b4c, 0xc3f706fb, 0xceb42022, 0xca753d95,
    0xf23a8028, 0xf6fb9d9f, 0xfbb8bb46, 0xff79a6f1,
    0xe13ef6f4, 0xe5ffeb43, 0xe8bccd9a, 0xec7dd02d,
    0x34867077, 0x30476dc0, 0x3d044b19, 0x39c556ae,
    0x278206ab, 0x23431b1c, 0x2e003dc5, 0x2ac12072,
    0x128e9dcf, 0x164f8078, 0x1b0ca6a1, 0x1fcdbb16,
    0x18aeb13,  0x54bf6a4,  0x808d07d,  0xcc9cdca,
    0x7897ab07, 0x7c56b6b0, 0x71159069, 0x75d48dde,
    0x6b93dddb, 0x6f52c06c, 0x6211e6b5, 0x66d0fb02,
    0x5e9f46bf, 0x5a5e5b08, 0x571d7dd1, 0x53dc6066,
    0x4d9b3063, 0x495a2dd4, 0x44190b0d, 0x40d816ba,
    0xaca5c697, 0xa864db20, 0xa527fdf9, 0xa1e6e04e,
    0xbfa1b04b, 0xbb60adfc, 0xb6238b25, 0xb2e29692,
    0x8aad2b2f, 0x8e6c3698, 0x832f1041, 0x87ee0df6,
    0x99a95df3, 0x9d684044, 0x902b669d, 0x94ea7b2a,
    0xe0b41de7, 0xe4750050, 0xe9362689, 0xedf73b3e,
    0xf3b06b3b, 0xf771768c, 0xfa325055, 0xfef34de2,
    0xc6bcf05f, 0xc27dede8, 0xcf3ecb31, 0xcbffd686,
    0xd5b88683, 0xd1799b34, 0xdc3abded, 0xd8fba05a,
    0x690ce0ee, 0x6dcdfd59, 0x608edb80, 0x644fc637,
    0x7a089632, 0x7ec98b85, 0x738aad5c, 0x774bb0eb,
    0x4f040d56, 0x4bc510e1, 0x46863638, 0x42472b8f,
    0x5c007b8a, 0x58c1663d, 0x558240e4, 0x51435d53,
    0x251d3b9e, 0x21dc2629, 0x2c9f00f0, 0x285e1d47,
    0x36194d42, 0x32d850f5, 0x3f9b762c, 0x3b5a6b9b,
    0x315d626,  0x7d4cb91,  0xa97ed48,  0xe56f0ff,
    0x1011a0fa, 0x14d0bd4d, 0x19939b94, 0x1d528623,
    0xf12f560e, 0xf5ee4bb9, 0xf8ad6d60, 0xfc6c70d7,
    0xe22b20d2, 0xe6ea3d65, 0xeba91bbc, 0xef68060b,
    0xd727bbb6, 0xd3e6a601, 0xdea580d8, 0xda649d6f,
    0xc423cd6a, 0xc0e2d0dd, 0xcda1f604, 0xc960ebb3,
    0xbd3e8d7e, 0xb9ff90c9, 0xb4bcb610, 0xb07daba7,
    0xae3afba2, 0xaafbe615, 0xa7b8c0cc, 0xa379dd7b,
    0x9b3660c6, 0x9ff77d71, 0x92b45ba8, 0x9675461f,
    0x8832161a, 0x8cf30bad, 0x81b02d74, 0x857130c3,
    0x5d8a9099, 0x594b8d2e, 0x5408abf7, 0x50c9b640,
    0x4e8ee645, 0x4a4ffbf2, 0x470cdd2b, 0x43cdc09c,
    0x7b827d21, 0x7f436096, 0x7200464f, 0x76c15bf8,
    0x68860bfd, 0x6c47164a, 0x61043093, 0x65c52d24,
    0x119b4be9, 0x155a565e, 0x18197087, 0x1cd86d30,
    0x29f3d35,  0x65e2082,  0xb1d065b,  0xfdc1bec,
    0x3793a651, 0x3352bbe6, 0x3e119d3f, 0x3ad08088,
    0x2497d08d, 0x2056cd3a, 0x2d15ebe3, 0x29d4f654,
    0xc5a92679, 0xc1683bce, 0xcc2b1d17, 0xc8ea00a0,
    0xd6ad50a5, 0xd26c4d12, 0xdf2f6bcb, 0xdbee767c,
    0xe3a1cbc1, 0xe760d676, 0xea23f0af, 0xeee2ed18,
    0xf0a5bd1d, 0xf464a0aa, 0xf9278673, 0xfde69bc4,
    0x89b8fd09, 0x8d79e0be, 0x803ac667, 0x84fbdbd0,
    0x9abc8bd5, 0x9e7d9662, 0x933eb0bb, 0x97ffad0c,
    0xafb010b1, 0xab710d06, 0xa6322bdf, 0xa2f33668,
    0xbcb4666d, 0xb8757bda, 0xb5365d03, 0xb1f740b4
};

/* Initialised table of crc_16 codes to speed up */
static word crc16_table[256] = {
    0x0000, 0x1db7, 0x3b6e, 0x26d9, 0x76dc, 0x6b6b, 0x4db2, 0x5005, 
    0xedb8, 0xf00f, 0xd6d6, 0xcb61, 0x9b64, 0x86d3, 0xa00a, 0xbdbd, 
    0xc6c7, 0xdb70, 0xfda9, 0xe01e, 0xb01b, 0xadac, 0x8b75, 0x96c2, 
    0x2b7f, 0x36c8, 0x1011, 0x0da6, 0x5da3, 0x4014, 0x66cd, 0x7b7a, 
    0x9039, 0x8d8e, 0xab57, 0xb6e0, 0xe6e5, 0xfb52, 0xdd8b, 0xc03c, 
    0x7d81, 0x6036, 0x46ef, 0x5b58, 0x0b5d, 0x16ea, 0x3033, 0x2d84, 
    0x56fe, 0x4b49, 0x6d90, 0x7027, 0x2022, 0x3d95, 0x1b4c, 0x06fb, 
    0xbb46, 0xa6f1, 0x8028, 0x9d9f, 0xcd9a, 0xd02d, 0xf6f4, 0xeb43, 
    0x3dc5, 0x2072, 0x06ab, 0x1b1c, 0x4b19, 0x56ae, 0x7077, 0x6dc0, 
    0xd07d, 0xcdca, 0xeb13, 0xf6a4, 0xa6a1, 0xbb16, 0x9dcf, 0x8078, 
    0xfb02, 0xe6b5, 0xc06c, 0xdddb, 0x8dde, 0x9069, 0xb6b0, 0xab07, 
    0x16ba, 0x0b0d, 0x2dd4, 0x3063, 0x6066, 0x7dd1, 0x5b08, 0x46bf, 
    0xadfc, 0xb04b, 0x9692, 0x8b25, 0xdb20, 0xc697, 0xe04e, 0xfdf9, 
    0x4044, 0x5df3, 0x7b2a, 0x669d, 0x3698, 0x2b2f, 0x0df6, 0x1041, 
    0x6b3b, 0x768c, 0x5055, 0x4de2, 0x1de7, 0x0050, 0x2689, 0x3b3e, 
    0x8683, 0x9b34, 0xbded, 0xa05a, 0xf05f, 0xede8, 0xcb31, 0xd686, 
    0x7b8a, 0x663d, 0x40e4, 0x5d53, 0x0d56, 0x10e1, 0x3638, 0x2b8f, 
    0x9632, 0x8b85, 0xad5c, 0xb0eb, 0xe0ee, 0xfd59, 0xdb80, 0xc637, 
    0xbd4d, 0xa0fa, 0x8623, 0x9b94, 0xcb91, 0xd626, 0xf0ff, 0xed48, 
    0x50f5, 0x4d42, 0x6b9b, 0x762c, 0x2629, 0x3b9e, 0x1d47, 0x00f0, 
    0xebb3, 0xf604, 0xd0dd, 0xcd6a, 0x9d6f, 0x80d8, 0xa601, 0xbbb6, 
    0x060b, 0x1bbc, 0x3d65, 0x20d2, 0x70d7, 0x6d60, 0x4bb9, 0x560e, 
    0x2d74, 0x30c3, 0x161a, 0x0bad, 0x5ba8, 0x461f, 0x60c6, 0x7d71, 
    0xc0cc, 0xdd7b, 0xfba2, 0xe615, 0xb610, 0xaba7, 0x8d7e, 0x90c9, 
    0x464f, 0x5bf8, 0x7d21, 0x6096, 0x3093, 0x2d24, 0x0bfd, 0x164a, 
    0xabf7, 0xb640, 0x9099, 0x8d2e, 0xdd2b, 0xc09c, 0xe645, 0xfbf2, 
    0x8088, 0x9d3f, 0xbbe6, 0xa651, 0xf654, 0xebe3, 0xcd3a, 0xd08d, 
    0x6d30, 0x7087, 0x565e, 0x4be9, 0x1bec, 0x065b, 0x2082, 0x3d35, 
    0xd676, 0xcbc1, 0xed18, 0xf0af, 0xa0aa, 0xbd1d, 0x9bc4, 0x8673, 
    0x3bce, 0x2679, 0x00a0, 0x1d17, 0x4d12, 0x50a5, 0x767c, 0x6bcb, 
    0x10b1, 0x0d06, 0x2bdf, 0x3668, 0x666d, 0x7bda, 0x5d03, 0x40b4, 
    0xfd09, 0xe0be, 0xc667, 0xdbd0, 0x8bd5, 0x9662, 0xb0bb, 0xad0c
};


/* The CRC16 function */
word CRC16(byte *p, long l)
{
    word crc=0xffff;
    long i;

    for (i=0; i<l; i++) {
	crc = (word)((crc << 8) ^ crc16_table[(crc >> 8) ^ *p]);
	p++;
    }

    return ~crc;
}


/* The CRC32 function */
dword CRC32(byte *p, long l)
{
    dword crc=0xffffffff;
    long i;
    
    for (i=0; i<l; i++) {
	crc = (word)((crc << 8) ^ crc32_table[(crc >> 24) ^ *p]);
	p++;
    }

    return ~crc;
}
