/*****************************************************************************/
/* File: buffer.c                                                            */
/* Author: David Chatenay                                                    */
/* Last Modified: Tue Jan 14 1997                                            */
/*                                                                           */
/* Implementation of buffered IOs functions                                  */
/*****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "crunch.h"
#include "buffer.h"


Buffer *NewBuffer(int fd)
{
    Buffer *b;

    b = (Buffer*)Malloc(sizeof(Buffer));
    ResetBuffer(b);
    b->fd = fd;
    b->total = 0;
    return b;
}


int AddCode(Code *c, Buffer *b)
{
    int  i, l, r, sbc, rbc;
    byte *p, *buffer;
 
    p = c->code;
    l = c->code_len / 8;
    r = c->code_len % 8;
    buffer = b->buffer;
    if (b->bit_count == 0) {
        for (i=0; i<l; i++) {
            buffer[b->byte_count] = p[i];
            IncrCountO(b);
        }
        if (r != 0) {
            buffer[b->byte_count] = p[l] & Mask[r];
            b->bit_count = r;
        }
    } else {
        sbc = b->bit_count;
        rbc = 8 - b->bit_count;
        for (i=0; i<l; i++) {
            buffer[b->byte_count] |= (p[i] << sbc);
            IncrCountO(b);
            buffer[b->byte_count] = (p[i] >> rbc);
        }
        if (r != 0)
            if (sbc + r > 8) {
                buffer[b->byte_count] |= (p[l] << sbc);
                IncrCountO(b);
                buffer[b->byte_count] = (p[l] >> rbc) & Mask[r-rbc];
                b->bit_count = r - rbc;
            } else {
                buffer[b->byte_count] |= ((p[l] & Mask[r]) << sbc);
                b->bit_count = sbc + r;
                if (b->bit_count == 8) {
                    IncrCountO(b);
                    b->bit_count = 0;
                }
            }
        else
            b->bit_count = sbc;
    }
    return 0;
}


int ReadCode(Code *c, Buffer *b)
{
    int i, l, r, sbc, rbc;
    byte *p, *buffer;
    
    p = c->code;
    l = c->code_len / 8;
    r = c->code_len % 8;
    buffer = b->buffer;
    if (b->bit_count == 0) {
        for (i=0; i<l; i++) {
            p[i] = buffer[b->byte_count];
            IncrCountI(b);
        }
        if (r != 0) {
            p[l] = buffer[b->byte_count] & Mask[r];
            b->bit_count = r;
        }
    } else {
        sbc = b->bit_count;
        rbc = 8 - b->bit_count;
        for (i=0; i<l; i++) {
            p[i] = (buffer[b->byte_count] >> sbc);
            IncrCountI(b);
            p[i] |= (buffer[b->byte_count] << rbc);
        }
        if (r != 0)
            if (sbc + r > 8) {
                p[l] = (buffer[b->byte_count] >> sbc);
                IncrCountI(b);
                p[l] |= ((buffer[b->byte_count] & Mask[r - rbc]) << rbc);
                b->bit_count = r - rbc;
            } else {
                p[l] = (buffer[b->byte_count] >> sbc) & Mask[r];
                b->bit_count = sbc + r;
                if (b->bit_count == 8) {
                    IncrCountI(b);
                    b->bit_count = 0;
                }
            }
        else
            b->bit_count = sbc;
    }
    return 0;
}


byte CodeLength(dword d)
{
    dword m=1;
    byte l=0;
    
    while (d >= m) {
        m = m << 1;
        l++;
    }
    return l;
}


int AddCodeToBlock(Code *c, byte *block, dword size, dword *bytec, word *bitc)
{
    int  i, l, r, sbc, rbc;
    byte *p;
 
    p = c->code;
    l = c->code_len / 8;
    r = c->code_len % 8;
    if ((*bitc) == 0) {
        for (i=0; i<l; i++) {
            block[(*bytec)] = p[i];
	    (*bytec)++;
	    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
        }
        if (r != 0) {
            block[(*bytec)] = p[l] & Mask[r];
            (*bitc) = r;
        }
    } else {
        sbc = (*bitc);
        rbc = 8 - (*bitc);
        for (i=0; i<l; i++) {
            block[(*bytec)] |= (p[i] << sbc);
	    (*bytec)++;
	    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
            block[(*bytec)] = (p[i] >> rbc);
        }
        if (r != 0)
            if (sbc + r > 8) {
                block[(*bytec)] |= (p[l] << sbc);
		(*bytec)++;
		if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
                block[(*bytec)] = (p[l] >> rbc) & Mask[r-rbc];
                (*bitc) = r - rbc;
            } else {
                block[(*bytec)] |= ((p[l] & Mask[r]) << sbc);
                (*bitc) = sbc + r;
                if ((*bitc) == 8) {
		    (*bytec)++;
		    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
                    (*bitc) = 0;
                }
            }
        else
            (*bitc) = sbc;
    }

    return 0;
}


int ReadCodeFromBlock(Code *c, byte *block, dword size, dword *bytec,
		      word *bitc)
{
    int i, l, r, sbc, rbc;
    byte *p;

    p = c->code;
    l = c->code_len / 8;
    r = c->code_len % 8;
    if ((*bitc) == 0) {
        for (i=0; i<l; i++) {
            p[i] = block[(*bytec)];
	    (*bytec)++;
	    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
        }
        if (r != 0) {
            p[l] = block[(*bytec)] & Mask[r];
            (*bitc) = r;
        }
    } else {
        sbc = (*bitc);
        rbc = 8 - (*bitc);
        for (i=0; i<l; i++) {
            p[i] = (block[(*bytec)] >> sbc);
            (*bytec)++;
	    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
            p[i] |= (block[(*bytec)] << rbc);
        }
        if (r != 0)
            if (sbc + r > 8) {
                p[l] = (block[(*bytec)] >> sbc);
                (*bytec)++;
		if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
                p[l] |= ((block[(*bytec)] & Mask[r - rbc]) << rbc);
                (*bitc) = r - rbc;
            } else {
                p[l] = (block[(*bytec)] >> sbc) & Mask[r];
                (*bitc) = sbc + r;
                if ((*bitc) == 8) {
                    (*bytec)++;
		    if ((*bytec) > size) { DEBUG0("Limit\n"); return -1; }
                    (*bitc) = 0;
                }
            }
        else
            (*bitc) = sbc;
    }
    return 0;
}
