/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk
    declarations for widgets
*/

//
//	WIDGETS.CC		20.11.1998
//

#ifndef _WIDGETS_H_
#define _WIDGETS_H_

#pragma interface

#include <unistd.h>
#include "fastgl.h"
#ifdef __WATCOMC__
#ifdef __DOS__
#include <direct.h>
#else
#include <dirent.h>
#endif // dos
#else
#include <dirent.h>
#endif // watcom


#define	FDIALOG_OPEN	1
#define	FDIALOG_SAVE	2
#define	FDIALOG_MODAL	4
#define	FDIALOG_SAVEDIR	8

typedef struct mydirent
{
	struct dirent item;
	int		type;	// 0 for dir, 1 for file
} mydirent;
	
//
// filename length max. 63 chars
// max. visible is 20 chars
//
class FileDialog
{
		static  char path[256];
		static  char tmppath[256];
		char 	filename[256];
		char	*filter;
		int 	mode;
		int		files,fls,dirs;
		int		maxfiles;
		void 	(*fileselect1)(char *);
		void 	(*fileselect2)(char *, FileDialog *);
		void	reload(void);
		static	Window	*wnd;
		EditBox *nameEBox;
		struct 	mydirent *filebuffer;
		char	*memory;
		int		param;
		ListBox *list;
		PushButton *ok, *cancel, *mkdir, *up, *down;
		int		Selected(void);
		void	Refresh(char *);
		void 	_init(char *dir, char *flt, char *namewnd, int m, int ink, int paper);
		static 	void InputName(CallBack);
	public:
		static	FileDialog *instance;
		FileDialog(void (*filesel)(char *, FileDialog *), char *dir=0, char *flt=0, char *namewnd="File Dialog", int m=FDIALOG_OPEN, int ink=0, int paper=PM);
		FileDialog(void (*filesel)(char *), char *dir=0, char *flt=0, char *namewnd="File Dialog", int m=FDIALOG_OPEN, int ink=0, int paper=PM);
		~FileDialog()
		{
			if (memory) delete memory;
			if (wnd) if (wnd->GetStatus() & WEXIST) delete wnd;
			instance = 0;
		}
		char	*GetDir(void) { return path; }
		char	*GetName(void) { return filename; }
		void	SetDir(char *d) { strcpy(path, d); reload(); }
		void	SetFilter(char *f) { filter=f; reload(); }
		void	SetMode(int m) { mode=m; }
		static  void myproc(GuiEvent *p);
		static  void drawone(int,int,int,int,void *);
		void	SetParam(int p) { param = p; }
		int		GetParam(void) { return param; }
};

class TextEditor {

public:
		enum 	{ FGMAX_LINE=32768, FGMAX_LINESIZE=512 };
protected:
		class FGLINE
		{
			public:
			unsigned size;         		/* amount of memory allocated */
			unsigned char *text;         /* the characters */
		};

		class FGBUFFER
		{
			public:
			char name[256];              /* name of the file */
			char buffer[FGMAX_LINESIZE];   /* name of the file */
			int  posx, posy;
			int  line;      		        /* cursor position within the line */
			int  lines;                  // all lines
			int  flags;                  /* flags about the buffer state */
			int  top;                    /* top line on the screen */
			int  ovr;
			int  hscroll;                /* offset when screen is scrolled sideways */
			int  sel_line1;               /* line that the selection began at */
			int  sel_pos1;                /* selection offset within the line */
			int  sel_line2;               /* offset in lines from sel_line to cursor */
			int  sel_pos2;                /* selection offset within the line */
		};

		Window *Text_EditorPtr;
		Window *OptionsPtr;
		Window *String_SearchPtr;
		int lfonly, font_save;
		FGBUFFER buf;
		FGLINE text[FGMAX_LINE];
		char s[1028];
		int WX, WY;
		char srch_str[33];
		int last_found;
		int _font;
		int TABSIZE;
		int nodraw,inblock,ronly;
		int X, Y, W, H;
		TextEditor **self;
//
		void file(void);
		int  _memcmp(unsigned char *from, unsigned char *co, unsigned kolko, unsigned l);
		int  Find(int from, int count, int size);
		void Clear(void);
		void _goto(void);
		static void SearchProc(GuiEvent *p);
		void search(void);
		static void SetFont(CallBack);
		static void OptionsProc(GuiEvent *p);
		static void file_proc(CallBack);
		void options(void);
		static char * terminate(char *s);
		FGLINE *create_line(char *s, int at);
		void Init(void);
		void SaveAsBuffer2(void);
		void OpenBuffer2(void);
		static void OpenBuffer1(char *s, FileDialog *);
		static void SaveAsBuffer1(char *s, FileDialog *);
		void ShowCursor(int trigger);
		void ShowLine(int scr, char *s);
		void ShowBuffer(void);
		int  isempty(char *s);
		void CKey(int k);
		void Key(int k);
		void SaveChanges(void);
		static void Text_EditorProc(GuiEvent *p);
		void Open(char *s);
		void Destruct(void);
	public:
		TextEditor(TextEditor **, char *arg, int font=3, int ink=CGRAY3, int paper=CBLACK);
		void NewBuffer(void);
		void OpenBuffer(char *s);
		void ReopenBuffer(void);
		void SaveBuffer(void);
		void SaveAsBuffer(char *s);
		void Close(void);
		void Goto(int);
		void ReadOnlyMode(void) { ronly = 1; };
		~TextEditor();
};

class ColorDialog
{
		static	Window *wnd;
		void (*fnc)(FGPixel);
		int		curr;
		FGPixel color;
		SlideBarV *sl1, *sl2, *sl3;
		int		cd_r, cd_g, cd_b;
		static unsigned int custom_colors[256];
		void FocusTo(int a);
	public:
		static	ColorDialog *instance;
		~ColorDialog()
		{
			if (wnd) if (wnd->GetStatus() & WEXIST) delete wnd;
			instance = 0;
		}
		ColorDialog(char *capture, void (*f)(FGPixel), FGPixel bgc=PM);
		static void SetColorsProc(GuiEvent *p);
		void UpdatePalette(void);
		static int Import(char *name);
		static int Export(char *name);
		unsigned int * GetColors(void) { return custom_colors; }
};

#endif
